/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.rest.factory;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;
import org.springframework.util.MultiValueMap;

public class ChainingRestHttpRequestCredentialFactory
implements RestHttpRequestCredentialFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingRestHttpRequestCredentialFactory.class);
    private final List<RestHttpRequestCredentialFactory> chain;

    public ChainingRestHttpRequestCredentialFactory(RestHttpRequestCredentialFactory ... chain) {
        this.chain = Stream.of(chain).collect(Collectors.toList());
    }

    public void registerCredentialFactory(RestHttpRequestCredentialFactory factory) {
        this.chain.add(factory);
    }

    @Override
    public List<Credential> fromRequestBody(MultiValueMap<String, String> requestBody) {
        OrderComparator.sort(this.chain);
        return this.chain.stream().map(f -> f.fromRequestBody(requestBody)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Generated
    public List<RestHttpRequestCredentialFactory> getChain() {
        return this.chain;
    }

    @Generated
    public ChainingRestHttpRequestCredentialFactory(List<RestHttpRequestCredentialFactory> chain) {
        this.chain = chain;
    }
}

