/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.rest.audit;

import java.net.URI;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

public class RestResponseEntityAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    private final boolean includeEntityBody;

    public String[] resolveFrom(JoinPoint auditableTarget, Object returnValue) {
        if (returnValue instanceof ResponseEntity) {
            return this.getAuditResourceFromResponseEntity((ResponseEntity)returnValue);
        }
        return new String[0];
    }

    private String[] getAuditResourceFromResponseEntity(ResponseEntity entity) {
        HttpHeaders headers = entity.getHeaders();
        ToStringBuilder result = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
        result.append("status", (Object)(entity.getStatusCodeValue() + "-" + entity.getStatusCode().name()));
        URI location = headers.getLocation();
        if (location != null) {
            result.append("location", (Object)location);
        }
        if (this.includeEntityBody && entity.getBody() != null) {
            result.append("body", (Object)entity.getBody().toString());
        }
        return new String[]{result.toString()};
    }

    @Generated
    public RestResponseEntityAuditResourceResolver(boolean includeEntityBody) {
        this.includeEntityBody = includeEntityBody;
    }
}

