/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apereo.cas.util.serialization.TicketIdSanitizationUtils;

public final class LoggingUtils {
    private LoggingUtils() {
    }

    public static LogEvent prepareLogEvent(LogEvent logEvent) {
        String messageModified = TicketIdSanitizationUtils.sanitize((String)logEvent.getMessage().getFormattedMessage());
        SimpleMessage message = new SimpleMessage(messageModified);
        Log4jLogEvent newLogEvent = Log4jLogEvent.newBuilder().setLevel(logEvent.getLevel()).setLoggerName(logEvent.getLoggerName()).setLoggerFqcn(logEvent.getLoggerFqcn()).setContextData((StringMap)new SortedArrayStringMap(logEvent.getContextData())).setContextStack(logEvent.getContextStack()).setEndOfBatch(logEvent.isEndOfBatch()).setIncludeLocation(logEvent.isIncludeLocation()).setMarker(logEvent.getMarker()).setMessage((Message)message).setNanoTime(logEvent.getNanoTime()).setSource(logEvent.getSource()).setThreadName(logEvent.getThreadName()).setThrownProxy(logEvent.getThrownProxy()).setThrown(logEvent.getThrown()).setTimeMillis(logEvent.getTimeMillis()).build();
        return newLogEvent;
    }
}

