/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class GroovyMultifactorAuthenticationProviderBypass
extends DefaultMultifactorAuthenticationProviderBypass {
    private static final long serialVersionUID = -4909072898415688377L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyMultifactorAuthenticationProviderBypass.class);
    private final Resource groovyScript;

    public GroovyMultifactorAuthenticationProviderBypass(MultifactorAuthenticationProviderBypassProperties bypass) {
        super(bypass);
        this.groovyScript = bypass.getGroovy().getLocation();
    }

    @Override
    public boolean shouldMultifactorAuthenticationProviderExecute(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        try {
            Principal principal = authentication.getPrincipal();
            LOGGER.debug("Evaluating multifactor authentication bypass properties for principal [{}], service [{}] and provider [{}] via Groovy script [{}]", new Object[]{principal.getId(), registeredService, provider, this.groovyScript});
            return (Boolean)ScriptingUtils.executeGroovyScript((Resource)this.groovyScript, (Object[])new Object[]{authentication, principal, registeredService, provider, LOGGER, request}, Boolean.class);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return super.shouldMultifactorAuthenticationProviderExecute(authentication, registeredService, provider, request);
        }
    }
}

