/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnRestfulAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    private static final long serialVersionUID = -6249488544306639050L;
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnRestfulAttributeReleasePolicy.class);
    private String endpoint;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<String, Object> getAttributesInternal(Principal principal, Map<String, Object> attributes, RegisteredService service) {
        try (StringWriter writer = new StringWriter();){
            MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)writer, attributes);
            HttpResponse response = HttpUtils.executePost((String)this.endpoint, (String)writer.toString(), (Map)CollectionUtils.wrap((String)"principal", (Object)principal.getId(), (String)"service", (Object)service.getId()));
            if (response.getStatusLine().getStatusCode() != 200) return new HashMap<String, Object>(0);
            Map map = (Map)MAPPER.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new HashMap<String, Object>(0);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReturnRestfulAttributeReleasePolicy rhs = (ReturnRestfulAttributeReleasePolicy)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.endpoint, (Object)rhs.endpoint).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.endpoint).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("endpoint", (Object)this.endpoint).toString();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

