/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnAllowedAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    private static final long serialVersionUID = -5771481877391140569L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnAllowedAttributeReleasePolicy.class);
    private List<String> allowedAttributes;

    public ReturnAllowedAttributeReleasePolicy() {
        this(new ArrayList<String>());
    }

    public ReturnAllowedAttributeReleasePolicy(List<String> allowedAttributes) {
        this.setAllowedAttributes(allowedAttributes);
    }

    public void setAllowedAttributes(List<String> allowed) {
        this.allowedAttributes = allowed;
    }

    public List<String> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    @Override
    protected Map<String, Object> getAttributesInternal(Principal principal, Map<String, Object> attrs, RegisteredService service) {
        return this.authorizeReleaseOfAllowedAttributes(attrs);
    }

    protected Map<String, Object> authorizeReleaseOfAllowedAttributes(Map<String, Object> attrs) {
        TreeMap<String, Object> resolvedAttributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        resolvedAttributes.putAll(attrs);
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>(resolvedAttributes.size());
        this.getAllowedAttributes().stream().map(attr -> new Object[]{attr, resolvedAttributes.get(attr)}).filter(pair -> pair[1] != null).forEach(attribute -> {
            LOGGER.debug("Found attribute [{}] in the list of allowed attributes", attribute[0]);
            attributesToRelease.put((String)attribute[0], attribute[1]);
        });
        return attributesToRelease;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReturnAllowedAttributeReleasePolicy rhs = (ReturnAllowedAttributeReleasePolicy)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.getAllowedAttributes(), rhs.getAllowedAttributes()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(13, 133).appendSuper(super.hashCode()).append(this.getAllowedAttributes()).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("allowedAttributes", this.getAllowedAttributes()).toString();
    }
}

