/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class GroovyScriptAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptAttributeReleasePolicy.class);
    private static final long serialVersionUID = 1703080077563402223L;
    private String groovyScript;

    public GroovyScriptAttributeReleasePolicy() {
    }

    public GroovyScriptAttributeReleasePolicy(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    @Override
    protected Map<String, Object> getAttributesInternal(Principal principal, Map<String, Object> attributes, RegisteredService service) {
        try {
            Object[] args = new Object[]{attributes, LOGGER, principal, service};
            AbstractResource resource = ResourceUtils.getResourceFrom((String)this.groovyScript);
            return (Map)ScriptingUtils.executeGroovyScript((Resource)resource, (Object[])args, Map.class);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            LOGGER.warn("Groovy script [{}] does not exist or cannot be loaded", (Object)this.groovyScript);
            return new HashMap<String, Object>(0);
        }
    }
}

