/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.cache;

import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalAttributesRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributes;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.apereo.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.apereo.services.persondir.support.merger.NoncollidingAttributeAdder;
import org.apereo.services.persondir.support.merger.ReplacingAttributeAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractPrincipalAttributesRepository
implements PrincipalAttributesRepository,
Closeable {
    private static final String DEFAULT_CACHE_EXPIRATION_UNIT = TimeUnit.HOURS.name();
    private static final long DEFAULT_CACHE_EXPIRATION_DURATION = 2L;
    private static final long serialVersionUID = 6350245643948535906L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPrincipalAttributesRepository.class);
    protected long expiration;
    protected String timeUnit;
    protected MergingStrategy mergingStrategy;
    private transient IPersonAttributeDao attributeRepository;

    protected AbstractPrincipalAttributesRepository() {
        this(2L, DEFAULT_CACHE_EXPIRATION_UNIT);
    }

    public AbstractPrincipalAttributesRepository(long expiration, String timeUnit) {
        this.expiration = expiration;
        this.timeUnit = timeUnit;
    }

    public void setMergingStrategy(MergingStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy;
    }

    public MergingStrategy getMergingStrategy() {
        return this.mergingStrategy;
    }

    protected Map<String, Object> convertPersonAttributesToPrincipalAttributes(Map<String, List<Object>> attributes) {
        return attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size() == 1 ? ((List)entry.getValue()).get(0) : entry.getValue(), (e, f) -> f == null ? e : f));
    }

    private static Map<String, List<Object>> convertPrincipalAttributesToPersonAttributes(Principal p) {
        TreeMap<String, List<Object>> convertedAttributes = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        Map principalAttributes = p.getAttributes();
        principalAttributes.entrySet().stream().forEach(entry -> {
            Object values = entry.getValue();
            String key = (String)entry.getKey();
            if (values instanceof List) {
                convertedAttributes.put(key, (List)values);
            } else {
                convertedAttributes.put(key, CollectionUtils.wrap(values));
            }
        });
        return convertedAttributes;
    }

    protected Map<String, List<Object>> retrievePersonAttributesToPrincipalAttributes(String id) {
        IPersonAttributes attrs = this.getAttributeRepository().getPerson(id);
        if (attrs == null) {
            LOGGER.debug("Could not find principal [{}] in the repository so no attributes are returned.", (Object)id);
            return new HashMap<String, List<Object>>(0);
        }
        Map attributes = attrs.getAttributes();
        if (attributes == null) {
            LOGGER.debug("Principal [{}] has no attributes and so none are returned.", (Object)id);
            return new HashMap<String, List<Object>>(0);
        }
        return attributes;
    }

    public Map<String, Object> getAttributes(Principal p) {
        Map<String, Object> cachedAttributes = this.getPrincipalAttributes(p);
        if (cachedAttributes != null && !cachedAttributes.isEmpty()) {
            LOGGER.debug("Found [{}] cached attributes for principal [{}] that are [{}]", new Object[]{cachedAttributes.size(), p.getId(), cachedAttributes});
            return cachedAttributes;
        }
        if (this.getAttributeRepository() == null) {
            LOGGER.debug("No attribute repository is defined for [{}]. Returning default principal attributes for [{}]", (Object)this.getClass().getName(), (Object)p.getId());
            return cachedAttributes;
        }
        Map<String, List<Object>> sourceAttributes = this.retrievePersonAttributesToPrincipalAttributes(p.getId());
        LOGGER.debug("Found [{}] attributes for principal [{}] from the attribute repository.", (Object)sourceAttributes.size(), (Object)p.getId());
        if (this.mergingStrategy == null || this.mergingStrategy.getAttributeMerger() == null) {
            LOGGER.debug("No merging strategy found, so attributes retrieved from the repository will be used instead.");
            return this.convertAttributesToPrincipalAttributesAndCache(p, sourceAttributes);
        }
        Map<String, List<Object>> principalAttributes = AbstractPrincipalAttributesRepository.convertPrincipalAttributesToPersonAttributes(p);
        LOGGER.debug("Merging current principal attributes with that of the repository via strategy [{}]", (Object)((Object)((Object)this.mergingStrategy)).getClass().getSimpleName());
        try {
            Map mergedAttributes = this.mergingStrategy.getAttributeMerger().mergeAttributes(principalAttributes, sourceAttributes);
            return this.convertAttributesToPrincipalAttributesAndCache(p, mergedAttributes);
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            builder.append(e.getClass().getName().concat("-"));
            if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                builder.append(e.getMessage());
            }
            LOGGER.error("The merging strategy [{}] for [{}] has failed to produce principal attributes because: [{}]. This usually is indicative of a bug and/or configuration mismatch. CAS will skip the merging process and will return the original collection of principal attributes [{}]", new Object[]{this.mergingStrategy, p.getId(), builder.toString(), principalAttributes});
            return this.convertAttributesToPrincipalAttributesAndCache(p, principalAttributes);
        }
    }

    private Map<String, Object> convertAttributesToPrincipalAttributesAndCache(Principal p, Map<String, List<Object>> sourceAttributes) {
        Map<String, Object> finalAttributes = this.convertPersonAttributesToPrincipalAttributes(sourceAttributes);
        this.addPrincipalAttributes(p.getId(), finalAttributes);
        return finalAttributes;
    }

    protected abstract void addPrincipalAttributes(String var1, Map<String, Object> var2);

    protected abstract Map<String, Object> getPrincipalAttributes(Principal var1);

    public void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    private IPersonAttributeDao getAttributeRepository() {
        try {
            if (this.attributeRepository == null) {
                ApplicationContext context = ApplicationContextProvider.getApplicationContext();
                if (context != null) {
                    return (IPersonAttributeDao)context.getBean("attributeRepository", IPersonAttributeDao.class);
                }
                LOGGER.warn("No application context could be retrieved, so no attribute repository instance can be determined.");
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return this.attributeRepository;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("mergingStrategy", (Object)this.mergingStrategy).append("expiration", this.expiration).append("timeUnit", (Object)this.timeUnit).toString();
    }

    public long getExpiration() {
        return this.expiration;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String unit) {
        this.timeUnit = unit;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractPrincipalAttributesRepository rhs = (AbstractPrincipalAttributesRepository)obj;
        return new EqualsBuilder().append((Object)this.timeUnit, (Object)rhs.timeUnit).append(this.expiration, rhs.expiration).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 133).append((Object)this.timeUnit).append(this.expiration).toHashCode();
    }

    public static enum MergingStrategy {
        REPLACE,
        ADD,
        NONE,
        MULTIVALUED;


        public IAttributeMerger getAttributeMerger() {
            String name = this.name().toUpperCase();
            switch (name.toUpperCase()) {
                case "REPLACE": {
                    return new ReplacingAttributeAdder();
                }
                case "ADD": {
                    return new NoncollidingAttributeAdder();
                }
                case "MULTIVALUED": {
                    return new MultivaluedAttributeMerger();
                }
            }
            return null;
        }
    }
}

