/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.DefaultAdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.policy.AllAuthenticationPolicy;
import org.apereo.cas.authentication.policy.AnyAuthenticationPolicy;
import org.apereo.cas.authentication.policy.GroovyScriptAuthenticationPolicy;
import org.apereo.cas.authentication.policy.NotPreventedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.RequiredHandlerAuthenticationPolicy;
import org.apereo.cas.authentication.policy.RequiredHandlerAuthenticationPolicyFactory;
import org.apereo.cas.authentication.policy.RestfulAuthenticationPolicy;
import org.apereo.cas.authentication.policy.UniquePrincipalAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.AuthenticationPolicyProperties;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.client.RestTemplate;

@Configuration(value="casCoreAuthenticationPolicyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuthenticationPolicyConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuthenticationPolicyConfiguration.class);
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired(required=false)
    @Qualifier(value="geoLocationService")
    private GeoLocationService geoLocationService;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"authenticationPolicyExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer authenticationPolicyExecutionPlanConfigurer() {
        return plan -> {
            AuthenticationPolicyProperties police = this.casProperties.getAuthn().getPolicy();
            if (police.getReq().isEnabled()) {
                LOGGER.debug("Activating authentication policy [{}]", (Object)RequiredHandlerAuthenticationPolicy.class.getSimpleName());
                plan.registerAuthenticationPolicy((AuthenticationPolicy)new RequiredHandlerAuthenticationPolicy(police.getReq().getHandlerName(), police.getReq().isTryAll()));
            } else if (police.getAll().isEnabled()) {
                LOGGER.debug("Activating authentication policy [{}]", (Object)AllAuthenticationPolicy.class.getSimpleName());
                plan.registerAuthenticationPolicy((AuthenticationPolicy)new AllAuthenticationPolicy());
            } else if (police.getNotPrevented().isEnabled()) {
                LOGGER.debug("Activating authentication policy [{}]", (Object)NotPreventedAuthenticationPolicy.class.getSimpleName());
                plan.registerAuthenticationPolicy(this.notPreventedAuthenticationPolicy());
            } else if (police.getUniquePrincipal().isEnabled()) {
                LOGGER.debug("Activating authentication policy [{}]", (Object)UniquePrincipalAuthenticationPolicy.class.getSimpleName());
                plan.registerAuthenticationPolicy((AuthenticationPolicy)new UniquePrincipalAuthenticationPolicy((TicketRegistry)this.ticketRegistry.getIfAvailable()));
            } else if (!police.getGroovy().isEmpty()) {
                LOGGER.debug("Activating authentication policy [{}]", (Object)GroovyScriptAuthenticationPolicy.class.getSimpleName());
                police.getGroovy().forEach(groovy -> plan.registerAuthenticationPolicy((AuthenticationPolicy)new GroovyScriptAuthenticationPolicy(this.resourceLoader, groovy.getScript())));
            } else if (!police.getRest().isEmpty()) {
                LOGGER.debug("Activating authentication policy [{}]", (Object)RestfulAuthenticationPolicy.class.getSimpleName());
                police.getRest().forEach(r -> plan.registerAuthenticationPolicy((AuthenticationPolicy)new RestfulAuthenticationPolicy(new RestTemplate(), r.getEndpoint())));
            } else if (police.getAny().isEnabled()) {
                LOGGER.debug("Activating authentication policy [{}]", (Object)AnyAuthenticationPolicy.class.getSimpleName());
                plan.registerAuthenticationPolicy((AuthenticationPolicy)new AnyAuthenticationPolicy(police.getAny().isTryAll()));
            }
        };
    }

    @Bean
    public AuthenticationPolicy notPreventedAuthenticationPolicy() {
        return new NotPreventedAuthenticationPolicy();
    }

    @ConditionalOnMissingBean(name={"adaptiveAuthenticationPolicy"})
    @Bean
    @RefreshScope
    public AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy() {
        return new DefaultAdaptiveAuthenticationPolicy(this.geoLocationService, this.casProperties.getAuthn().getAdaptive());
    }

    @ConditionalOnMissingBean(name={"requiredHandlerAuthenticationPolicyFactory"})
    @Bean
    public ContextualAuthenticationPolicyFactory requiredHandlerAuthenticationPolicyFactory() {
        return new RequiredHandlerAuthenticationPolicyFactory();
    }
}

