/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceContact;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public interface RegisteredService
extends Serializable,
Comparable<RegisteredService> {
    public static final long INITIAL_IDENTIFIER_VALUE = -1L;

    public RegisteredServiceExpirationPolicy getExpirationPolicy();

    public RegisteredServiceProxyPolicy getProxyPolicy();

    public String getServiceId();

    public long getId();

    public String getName();

    public String getTheme();

    public String getDescription();

    public String getResponseType();

    public int getEvaluationOrder();

    public void setEvaluationOrder(int var1);

    public void setId(long var1);

    public RegisteredServiceUsernameAttributeProvider getUsernameAttributeProvider();

    public RegisteredServiceMultifactorPolicy getMultifactorPolicy();

    public Set<String> getRequiredHandlers();

    public RegisteredServiceAccessStrategy getAccessStrategy();

    public boolean matches(Service var1);

    public boolean matches(String var1);

    public LogoutType getLogoutType();

    public RegisteredServiceAttributeReleasePolicy getAttributeReleasePolicy();

    public String getLogo();

    public String getInformationUrl();

    public String getPrivacyUrl();

    public URL getLogoutUrl();

    public RegisteredServicePublicKey getPublicKey();

    default public Map<String, RegisteredServiceProperty> getProperties() {
        return new LinkedHashMap<String, RegisteredServiceProperty>(0);
    }

    public List<RegisteredServiceContact> getContacts();

    @JsonIgnore
    default public String getFriendlyName() {
        return this.getClass().getSimpleName();
    }

    default public void initialize() {
    }

    public static enum LogoutType {
        NONE,
        BACK_CHANNEL,
        FRONT_CHANNEL;

    }
}

