/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.apache.ApacheClient;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.NoteResult;
import org.apache.zeppelin.client.ParagraphResult;
import org.apache.zeppelin.common.SessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import unirest.shaded.org.apache.http.client.HttpClient;
import unirest.shaded.org.apache.http.impl.client.CloseableHttpClient;
import unirest.shaded.org.apache.http.impl.client.HttpClients;

public class ZeppelinClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinClient.class);
    private ClientConfig clientConfig;

    public ZeppelinClient(ClientConfig clientConfig) throws Exception {
        this.clientConfig = clientConfig;
        Unirest.config().defaultBaseUrl(clientConfig.getZeppelinRestUrl() + "/api");
        if (clientConfig.isUseKnox()) {
            try {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) {
                        return true;
                    }
                }).build();
                CloseableHttpClient customHttpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
                Unirest.config().httpClient((Function)ApacheClient.builder((HttpClient)customHttpClient));
            }
            catch (Exception e) {
                throw new Exception("Fail to setup httpclient of Unirest", e);
            }
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    private void checkResponse(HttpResponse<JsonNode> response) throws Exception {
        if (response.getStatus() == 302) {
            throw new Exception("Please login first");
        }
        if (response.getStatus() != 200) {
            String message = response.getStatusText();
            if (response.getBody() != null && ((JsonNode)response.getBody()).getObject() != null && ((JsonNode)response.getBody()).getObject().has("message")) {
                message = ((JsonNode)response.getBody()).getObject().getString("message");
            }
            throw new Exception(String.format("Unable to call rest api, status: %s, statusText: %s, message: %s", response.getStatus(), response.getStatusText(), message));
        }
    }

    private void checkJsonNodeStatus(JsonNode jsonNode) throws Exception {
        if (!"OK".equalsIgnoreCase(jsonNode.getObject().getString("status"))) {
            throw new Exception(StringEscapeUtils.unescapeJava((String)jsonNode.getObject().getString("message")));
        }
    }

    public String getVersion() throws Exception {
        HttpResponse response = Unirest.get((String)"/version").asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return jsonNode.getObject().getJSONObject("body").getString("version");
    }

    public SessionInfo newSession(String interpreter) throws Exception {
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)"/session").queryString("interpreter", (Object)interpreter)).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return this.createSessionInfoFromJson(jsonNode.getObject().getJSONObject("body"));
    }

    public void stopSession(String sessionId) throws Exception {
        HttpResponse response = ((HttpRequestWithBody)Unirest.delete((String)"/session/{sessionId}").routeParam("sessionId", sessionId)).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
    }

    public SessionInfo getSession(String sessionId) throws Exception {
        HttpResponse response = ((GetRequest)Unirest.get((String)"/session/{sessionId}").routeParam("sessionId", sessionId)).asJson();
        if (response.getStatus() == 404) {
            String statusText = response.getStatusText();
            if (((JsonNode)response.getBody()).getObject().has("message")) {
                statusText = ((JsonNode)response.getBody()).getObject().getString("message");
            }
            if (statusText.contains("No such session")) {
                return null;
            }
        }
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        JSONObject bodyObject = jsonNode.getObject().getJSONObject("body");
        return this.createSessionInfoFromJson(bodyObject);
    }

    public List<SessionInfo> listSessions() throws Exception {
        return this.listSessions(null);
    }

    public List<SessionInfo> listSessions(String interpreter) throws Exception {
        GetRequest getRequest = Unirest.get((String)"/session");
        if (interpreter != null) {
            getRequest.queryString("interpreter", (Object)interpreter);
        }
        HttpResponse response = getRequest.asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        JSONArray sessionJsonArray = jsonNode.getObject().getJSONArray("body");
        ArrayList<SessionInfo> sessionInfos = new ArrayList<SessionInfo>();
        for (int i = 0; i < sessionJsonArray.length(); ++i) {
            sessionInfos.add(this.createSessionInfoFromJson(sessionJsonArray.getJSONObject(i)));
        }
        return sessionInfos;
    }

    private SessionInfo createSessionInfoFromJson(JSONObject sessionJson) {
        SessionInfo sessionInfo = new SessionInfo();
        if (sessionJson.has("sessionId")) {
            sessionInfo.setSessionId(sessionJson.getString("sessionId"));
        }
        if (sessionJson.has("noteId")) {
            sessionInfo.setNoteId(sessionJson.getString("noteId"));
        }
        if (sessionJson.has("interpreter")) {
            sessionInfo.setInterpreter(sessionJson.getString("interpreter"));
        }
        if (sessionJson.has("state")) {
            sessionInfo.setState(sessionJson.getString("state"));
        }
        if (sessionJson.has("weburl")) {
            sessionInfo.setWeburl(sessionJson.getString("weburl"));
        }
        if (sessionJson.has("startTime")) {
            sessionInfo.setStartTime(sessionJson.getString("startTime"));
        }
        return sessionInfo;
    }

    public void login(String userName, String password) throws Exception {
        if (this.clientConfig.isUseKnox()) {
            HttpResponse response = ((GetRequest)Unirest.get((String)(this.clientConfig.getKnoxSSOUrl() + "?originalUrl=" + this.clientConfig.getZeppelinRestUrl())).basicAuth(userName, password)).asString();
            if (response.getStatus() != 200) {
                throw new Exception(String.format("Knox SSO login failed, status: %s, statusText: %s", response.getStatus(), response.getStatusText()));
            }
            response = Unirest.get((String)"/security/ticket").asString();
            if (response.getStatus() != 200) {
                throw new Exception(String.format("Fail to get ticket after Knox SSO, status: %s, statusText: %s", response.getStatus(), response.getStatusText()));
            }
        } else {
            HttpResponse response = Unirest.post((String)"/login").field("userName", (Object)userName).field("password", password).asJson();
            if (response.getStatus() != 200) {
                throw new Exception(String.format("Login failed, status: %s, statusText: %s", response.getStatus(), response.getStatusText()));
            }
        }
    }

    public String createNote(String notePath) throws Exception {
        return this.createNote(notePath, "");
    }

    public String createNote(String notePath, String defaultInterpreterGroup) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("name", notePath);
        bodyObject.put("defaultInterpreterGroup", defaultInterpreterGroup);
        HttpResponse response = Unirest.post((String)"/notebook").body(bodyObject.toString()).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return jsonNode.getObject().getString("body");
    }

    public void deleteNote(String noteId) throws Exception {
        HttpResponse response = ((HttpRequestWithBody)Unirest.delete((String)"/notebook/{noteId}").routeParam("noteId", noteId)).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
    }

    public String cloneNote(String noteId, String destPath) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("name", destPath);
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)"/notebook/{noteId}").routeParam("noteId", noteId)).body(bodyObject.toString()).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return jsonNode.getObject().getString("body");
    }

    public void renameNote(String noteId, String newNotePath) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("name", newNotePath);
        HttpResponse response = ((HttpRequestWithBody)Unirest.put((String)"/notebook/{noteId}/rename").routeParam("noteId", noteId)).body(bodyObject.toString()).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
    }

    public NoteResult queryNoteResult(String noteId) throws Exception {
        JSONObject infoJsonObject;
        HttpResponse response = ((GetRequest)Unirest.get((String)"/notebook/{noteId}").routeParam("noteId", noteId)).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        JSONObject noteJsonObject = jsonNode.getObject().getJSONObject("body");
        boolean isRunning = false;
        if (noteJsonObject.has("info") && (infoJsonObject = noteJsonObject.getJSONObject("info")).has("isRunning")) {
            isRunning = Boolean.parseBoolean(infoJsonObject.getString("isRunning"));
        }
        String notePath = null;
        if (noteJsonObject.has("path")) {
            notePath = noteJsonObject.getString("path");
        }
        ArrayList<ParagraphResult> paragraphResultList = new ArrayList<ParagraphResult>();
        if (noteJsonObject.has("paragraphs")) {
            JSONArray paragraphJsonArray = noteJsonObject.getJSONArray("paragraphs");
            for (int i = 0; i < paragraphJsonArray.length(); ++i) {
                paragraphResultList.add(new ParagraphResult(paragraphJsonArray.getJSONObject(i)));
            }
        }
        return new NoteResult(noteId, notePath, isRunning, paragraphResultList);
    }

    public NoteResult executeNote(String noteId) throws Exception {
        return this.executeNote(noteId, new HashMap<String, String>());
    }

    public NoteResult executeNote(String noteId, Map<String, String> parameters) throws Exception {
        this.submitNote(noteId, parameters);
        return this.waitUntilNoteFinished(noteId);
    }

    public NoteResult submitNote(String noteId) throws Exception {
        return this.submitNote(noteId, new HashMap<String, String>());
    }

    public NoteResult submitNote(String noteId, Map<String, String> parameters) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("params", parameters);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)"/notebook/job/{noteId}").routeParam("noteId", noteId)).queryString("blocking", (Object)"false")).queryString("isolated", (Object)"true")).body(bodyObject).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return this.queryNoteResult(noteId);
    }

    public String importNote(String notePath, String noteContent) throws Exception {
        JSONObject bodyObject = new JSONObject(noteContent);
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)"/notebook/import").queryString("notePath", (Object)notePath)).body(bodyObject).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return jsonNode.getObject().getString("body");
    }

    public NoteResult waitUntilNoteFinished(String noteId) throws Exception {
        NoteResult noteResult;
        while ((noteResult = this.queryNoteResult(noteId)).isRunning()) {
            Thread.sleep(this.clientConfig.getQueryInterval());
        }
        return noteResult;
    }

    public NoteResult waitUntilNoteFinished(String noteId, long timeoutInMills) throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutInMills) {
            NoteResult noteResult = this.queryNoteResult(noteId);
            if (!noteResult.isRunning()) {
                return noteResult;
            }
            Thread.sleep(this.clientConfig.getQueryInterval());
        }
        throw new Exception("Note is not finished in " + timeoutInMills / 1000L + " seconds");
    }

    public String addParagraph(String noteId, String title, String text) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("title", title);
        bodyObject.put("text", text);
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)"/notebook/{noteId}/paragraph").routeParam("noteId", noteId)).body(bodyObject.toString()).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return jsonNode.getObject().getString("body");
    }

    public void updateParagraph(String noteId, String paragraphId, String title, String text) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("title", title);
        bodyObject.put("text", text);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.put((String)"/notebook/{noteId}/paragraph/{paragraphId}").routeParam("noteId", noteId)).routeParam("paragraphId", paragraphId)).body(bodyObject.toString()).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
    }

    public ParagraphResult executeParagraph(String noteId, String paragraphId, String sessionId, Map<String, String> parameters) throws Exception {
        this.submitParagraph(noteId, paragraphId, sessionId, parameters);
        return this.waitUtilParagraphFinish(noteId, paragraphId);
    }

    public ParagraphResult executeParagraph(String noteId, String paragraphId, Map<String, String> parameters) throws Exception {
        return this.executeParagraph(noteId, paragraphId, "", parameters);
    }

    public ParagraphResult executeParagraph(String noteId, String paragraphId, String sessionId) throws Exception {
        return this.executeParagraph(noteId, paragraphId, sessionId, new HashMap<String, String>());
    }

    public ParagraphResult executeParagraph(String noteId, String paragraphId) throws Exception {
        return this.executeParagraph(noteId, paragraphId, "", new HashMap<String, String>());
    }

    public ParagraphResult submitParagraph(String noteId, String paragraphId, String sessionId, Map<String, String> parameters) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("params", parameters);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)"/notebook/job/{noteId}/{paragraphId}").routeParam("noteId", noteId)).routeParam("paragraphId", paragraphId)).queryString("sessionId", (Object)sessionId)).body(bodyObject.toString()).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return this.queryParagraphResult(noteId, paragraphId);
    }

    public ParagraphResult submitParagraph(String noteId, String paragraphId, String sessionId) throws Exception {
        return this.submitParagraph(noteId, paragraphId, sessionId, new HashMap<String, String>());
    }

    public ParagraphResult submitParagraph(String noteId, String paragraphId, Map<String, String> parameters) throws Exception {
        return this.submitParagraph(noteId, paragraphId, "", parameters);
    }

    public ParagraphResult submitParagraph(String noteId, String paragraphId) throws Exception {
        return this.submitParagraph(noteId, paragraphId, "", new HashMap<String, String>());
    }

    public String nextSessionParagraph(String noteId, int maxParagraph) throws Exception {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)"/notebook/{noteId}/paragraph/next").routeParam("noteId", noteId)).queryString("maxParagraph", (Object)maxParagraph)).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        return jsonNode.getObject().getString("message");
    }

    public void cancelParagraph(String noteId, String paragraphId) throws Exception {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.delete((String)"/notebook/job/{noteId}/{paragraphId}").routeParam("noteId", noteId)).routeParam("paragraphId", paragraphId)).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
    }

    public ParagraphResult queryParagraphResult(String noteId, String paragraphId) throws Exception {
        HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)"/notebook/{noteId}/paragraph/{paragraphId}").routeParam("noteId", noteId)).routeParam("paragraphId", paragraphId)).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
        JSONObject paragraphJson = jsonNode.getObject().getJSONObject("body");
        return new ParagraphResult(paragraphJson);
    }

    public ParagraphResult waitUtilParagraphFinish(String noteId, String paragraphId) throws Exception {
        while (true) {
            ParagraphResult paragraphResult = this.queryParagraphResult(noteId, paragraphId);
            LOGGER.debug(paragraphResult.toString());
            if (paragraphResult.getStatus().isCompleted()) {
                return paragraphResult;
            }
            Thread.sleep(this.clientConfig.getQueryInterval());
        }
    }

    public ParagraphResult waitUtilParagraphFinish(String noteId, String paragraphId, long timeoutInMills) throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutInMills) {
            ParagraphResult paragraphResult = this.queryParagraphResult(noteId, paragraphId);
            if (paragraphResult.getStatus().isCompleted()) {
                return paragraphResult;
            }
            Thread.sleep(this.clientConfig.getQueryInterval());
        }
        throw new Exception("Paragraph is not finished in " + timeoutInMills / 1000L + " seconds");
    }

    public ParagraphResult waitUtilParagraphRunning(String noteId, String paragraphId) throws Exception {
        ParagraphResult paragraphResult;
        while (!(paragraphResult = this.queryParagraphResult(noteId, paragraphId)).getStatus().isRunning()) {
            Thread.sleep(this.clientConfig.getQueryInterval());
        }
        return paragraphResult;
    }

    public void stopInterpreter(String noteId, String interpreter) throws Exception {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put("noteId", noteId);
        HttpResponse response = ((HttpRequestWithBody)Unirest.put((String)"/interpreter/setting/restart/{interpreter}").routeParam("interpreter", interpreter)).body(bodyObject.toString()).asJson();
        this.checkResponse((HttpResponse<JsonNode>)response);
        JsonNode jsonNode = (JsonNode)response.getBody();
        this.checkJsonNodeStatus(jsonNode);
    }
}

