/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax;

import com.github.openjson.JSONObject;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.json.JSONFunction;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;
import org.apache.wicket.util.lang.Args;

public class AjaxDownloadBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_PARAMETER_NAME = "wicket-ajaxdownload";
    private static final ResourceReference JS = new JQueryPluginResourceReference(AjaxDownloadBehavior.class, "wicket-ajaxdownload.js");
    private final ResourceReference resourceReference;
    private final ResourceBehavior resourceBehavior;
    private PageParameters resourceParameters;
    private Location location = Location.Blob;

    public AjaxDownloadBehavior(IResource resource) {
        Args.notNull((Object)resource, (String)"resource");
        this.resourceBehavior = new ResourceBehavior(resource);
        this.resourceReference = null;
    }

    public AjaxDownloadBehavior(ResourceReference reference) {
        this(reference, null);
    }

    public AjaxDownloadBehavior(ResourceReference reference, PageParameters resourceParameters) {
        this.resourceBehavior = null;
        this.resourceReference = (ResourceReference)Args.notNull((Object)reference, (String)"reference");
        this.resourceParameters = resourceParameters;
    }

    protected void onBind() {
        super.onBind();
        if (this.resourceBehavior != null) {
            this.getComponent().add(new Behavior[]{this.resourceBehavior});
        }
    }

    protected void onUnbind() {
        super.onUnbind();
        if (this.resourceBehavior != null) {
            this.getComponent().remove(new Behavior[]{this.resourceBehavior});
        }
    }

    public void initiate(AjaxRequestTarget target) {
        CharSequence url;
        if (this.getComponent() == null) {
            throw new WicketRuntimeException("not bound to a component");
        }
        ((WebResponse)RequestCycle.get().getResponse()).clearCookie(AjaxDownloadBehavior.cookie(this.getName()));
        if (this.resourceBehavior == null) {
            if (this.resourceReference.canBeRegistered()) {
                this.getComponent().getApplication().getResourceReferenceRegistry().registerResourceReference(this.resourceReference);
            }
            PageParameters parameters = new PageParameters();
            if (this.resourceParameters != null) {
                parameters.mergeWith(this.resourceParameters);
            }
            parameters.set(RESOURCE_PARAMETER_NAME, (Object)this.getName());
            url = this.getComponent().getRequestCycle().urlFor((IRequestHandler)new ResourceReferenceRequestHandler(this.resourceReference, parameters));
        } else {
            url = this.resourceBehavior.getUrl();
        }
        JSONObject settings = new JSONObject();
        settings.put("attributes", (Object)new JSONFunction(this.renderAjaxAttributes(this.getComponent())));
        settings.put("name", (Object)this.getName());
        settings.put("downloadUrl", (Object)url);
        settings.put("method", (Object)this.getLocation().name().toLowerCase(Locale.ENGLISH));
        target.appendJavaScript((CharSequence)String.format("Wicket.AjaxDownload.initiate(%s);", settings));
        this.onBeforeDownload(target);
    }

    protected void onBeforeDownload(AjaxRequestTarget target) {
    }

    protected void onDownloadSuccess(AjaxRequestTarget target) {
    }

    protected void onDownloadFailed(AjaxRequestTarget target) {
    }

    protected void onDownloadCompleted(AjaxRequestTarget target) {
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
    }

    protected void respond(AjaxRequestTarget target) {
        String result = this.getComponent().getRequest().getRequestParameters().getParameterValue("result").toOptionalString();
        if ("success".equals(result)) {
            this.onDownloadSuccess(target);
        } else if ("failed".equals(result)) {
            this.onDownloadFailed(target);
        }
        this.onDownloadCompleted(target);
    }

    public Location getLocation() {
        return this.location;
    }

    public AjaxDownloadBehavior setLocation(Location location) {
        this.location = (Location)((Object)Args.notNull((Object)((Object)location), (String)"location"));
        return this;
    }

    private String getName() {
        return String.format("wicket-ajaxdownload-%s-%s", this.getComponent().getMarkupId(), this.getComponent().getBehaviorId((Behavior)this));
    }

    public static void markCompleted(IResource.Attributes attributes) {
        String cookieName = attributes.getParameters().get(RESOURCE_PARAMETER_NAME).toString();
        ((WebResponse)attributes.getResponse()).addCookie(AjaxDownloadBehavior.cookie(cookieName));
    }

    private static Cookie cookie(String name) {
        Cookie cookie = new Cookie(name, "complete");
        cookie.setPath("/");
        return cookie;
    }

    private class ResourceBehavior
    extends Behavior
    implements IRequestListener {
        private final IResource resource;

        private ResourceBehavior(IResource resource) {
            this.resource = (IResource)Args.notNull((Object)resource, (String)"resource");
        }

        public boolean rendersPage() {
            return false;
        }

        public void onRequest() {
            RequestCycle requestCycle = RequestCycle.get();
            Response response = requestCycle.getResponse();
            ((WebResponse)response).addCookie(AjaxDownloadBehavior.cookie(AjaxDownloadBehavior.this.getName()));
            IResource.Attributes a = new IResource.Attributes(requestCycle.getRequest(), response, null);
            this.resource.respond(a);
        }

        public CharSequence getUrl() {
            return AjaxDownloadBehavior.this.getComponent().urlForListener((Behavior)this, null);
        }
    }

    public static enum Location {
        Blob,
        IFrame,
        SameWindow,
        NewWindow;

    }
}

