/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.IRequestListener;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SubmitLink
extends AbstractSubmitLink
implements IRequestListener {
    private static final long serialVersionUID = 1L;

    public SubmitLink(String id) {
        super(id);
    }

    public SubmitLink(String id, Form<?> form) {
        super(id, form);
    }

    public SubmitLink(String id, IModel<?> model) {
        super(id, model);
    }

    public SubmitLink(String id, IModel<?> model, Form<?> form) {
        super(id, model, form);
    }

    public final void onLinkClicked() {
        this.onSubmit();
        this.onAfterSubmit();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isEnabledInHierarchy()) {
            if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                tag.put("href", "javascript:;");
            } else if (tag.getName().equalsIgnoreCase("button")) {
                tag.put("type", "button");
            }
            tag.put("onclick", this.getTriggerJavaScript());
        } else {
            this.disableLink(tag);
        }
    }

    protected boolean shouldInvokeJavaScriptFormOnsubmit() {
        return true;
    }

    protected CharSequence getTriggerJavaScript() {
        if (this.getForm() != null) {
            Form<?> root = this.getForm().getRootForm();
            StringBuilder script = new StringBuilder();
            if (this.shouldInvokeJavaScriptFormOnsubmit()) {
                script.append(String.format("var ff=document.getElementById('%s');", this.getForm().getMarkupId()));
                script.append("if (typeof ff.onsubmit === 'function' && ff.onsubmit() == false) return false;");
            }
            CharSequence url = this.urlForListener(new PageParameters());
            script.append(root.getJsForListenerUrl(url));
            script.append("return false;");
            return script;
        }
        return null;
    }

    @Override
    public void onRequest() {
        this.getForm().onFormSubmitted(this);
    }

    @Override
    public void onError() {
    }

    @Override
    public void onAfterSubmit() {
    }

    @Override
    public void onSubmit() {
    }
}

