/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpUpgradeHandler;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.Http11Processor;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeProcessorExternal;
import org.apache.coyote.http11.upgrade.UpgradeProcessorInternal;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Protocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractHttp11Protocol.class);
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private int connectionUploadTimeout = 300000;
    private boolean disableUploadTimeout = true;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String compressableMimeType = "text/html,text/xml,text/plain,text/css,text/javascript,application/javascript";
    private String[] compressableMimeTypes = null;
    private int compressionMinSize = 2048;
    private String restrictedUserAgents = null;
    private String server;
    private boolean serverRemoveAppProvidedValues = false;
    private int maxTrailerSize = 8192;
    private int maxExtensionSize = 8192;
    private int maxSwallowSize = 0x200000;
    private boolean secure;
    private Set<String> allowedTrailerHeaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<UpgradeProtocol> upgradeProtocols = new ArrayList<UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> httpUpgradeProtocols = new HashMap<String, UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> negotiatedProtocols = new HashMap<String, UpgradeProtocol>();
    private SSLHostConfig defaultSSLHostConfig = null;

    public AbstractHttp11Protocol(AbstractEndpoint<S> endpoint) {
        super(endpoint);
        this.setSoTimeout(60000);
        AbstractProtocol.ConnectionHandler cHandler = new AbstractProtocol.ConnectionHandler(this);
        this.setHandler(cHandler);
        this.getEndpoint().setHandler(cHandler);
    }

    @Override
    public void init() throws Exception {
        for (UpgradeProtocol upgradeProtocol : this.upgradeProtocols) {
            this.configureUpgradeProtocol(upgradeProtocol);
        }
        super.init();
    }

    @Override
    protected String getProtocolName() {
        return "Http";
    }

    @Override
    protected AbstractEndpoint<S> getEndpoint() {
        return super.getEndpoint();
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int i) {
        this.connectionUploadTimeout = i;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
    }

    public String getCompressableMimeType() {
        return this.compressableMimeType;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeType = valueS;
        this.compressableMimeTypes = null;
    }

    public String[] getCompressableMimeTypes() {
        String[] result = this.compressableMimeTypes;
        if (result != null) {
            return result;
        }
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.compressableMimeType, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() <= 0) continue;
            values.add(token);
        }
        result = values.toArray(new String[values.size()]);
        this.compressableMimeTypes = result;
        return result;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean getServerRemoveAppProvidedValues() {
        return this.serverRemoveAppProvidedValues;
    }

    public void setServerRemoveAppProvidedValues(boolean serverRemoveAppProvidedValues) {
        this.serverRemoveAppProvidedValues = serverRemoveAppProvidedValues;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int maxTrailerSize) {
        this.maxTrailerSize = maxTrailerSize;
    }

    public int getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    public void setMaxExtensionSize(int maxExtensionSize) {
        this.maxExtensionSize = maxExtensionSize;
    }

    public int getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(int maxSwallowSize) {
        this.maxSwallowSize = maxSwallowSize;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public void setAllowedTrailerHeaders(String commaSeparatedHeaders) {
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.addAll(this.allowedTrailerHeaders);
        if (commaSeparatedHeaders != null) {
            String[] headers;
            for (String header : headers = commaSeparatedHeaders.split(",")) {
                String trimmedHeader = header.trim().toLowerCase(Locale.ENGLISH);
                if (toRemove.contains(trimmedHeader)) {
                    toRemove.remove(trimmedHeader);
                    continue;
                }
                this.allowedTrailerHeaders.add(trimmedHeader);
            }
            this.allowedTrailerHeaders.removeAll(toRemove);
        }
    }

    public String getAllowedTrailerHeaders() {
        ArrayList<String> copy = new ArrayList<String>(this.allowedTrailerHeaders.size());
        copy.addAll(this.allowedTrailerHeaders);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String header : copy) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(header);
        }
        return result.toString();
    }

    public void addAllowedTrailerHeader(String header) {
        if (header != null) {
            this.allowedTrailerHeaders.add(header.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    public void removeAllowedTrailerHeader(String header) {
        if (header != null) {
            this.allowedTrailerHeaders.remove(header.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.upgradeProtocols.add(upgradeProtocol);
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return this.upgradeProtocols.toArray(new UpgradeProtocol[0]);
    }

    private void configureUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        String alpnName;
        boolean isSSLEnabled = this.getEndpoint().isSSLEnabled();
        String httpUpgradeName = upgradeProtocol.getHttpUpgradeName(isSSLEnabled);
        boolean httpUpgradeConfigured = false;
        if (httpUpgradeName != null && httpUpgradeName.length() > 0) {
            this.httpUpgradeProtocols.put(httpUpgradeName, upgradeProtocol);
            httpUpgradeConfigured = true;
            this.getLog().info(sm.getString("abstractHttp11Protocol.httpUpgradeConfigured", this.getName(), httpUpgradeName));
        }
        if ((alpnName = upgradeProtocol.getAlpnName()) != null && alpnName.length() > 0) {
            if (isSSLEnabled) {
                this.negotiatedProtocols.put(alpnName, upgradeProtocol);
                this.getEndpoint().addNegotiatedProtocol(alpnName);
                this.getLog().info(sm.getString("abstractHttp11Protocol.alpnConfigured", this.getName(), alpnName));
            } else if (!httpUpgradeConfigured) {
                this.getLog().error(sm.getString("abstractHttp11Protocol.alpnWithNoTls", upgradeProtocol.getClass().getName(), alpnName, this.getName()));
            }
        }
    }

    @Override
    public UpgradeProtocol getNegotiatedProtocol(String negotiatedName) {
        return this.negotiatedProtocols.get(negotiatedName);
    }

    @Override
    public UpgradeProtocol getUpgradeProtocol(String upgradedName) {
        return this.httpUpgradeProtocols.get(upgradedName);
    }

    public boolean isSSLEnabled() {
        return this.getEndpoint().isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.getEndpoint().setSSLEnabled(SSLEnabled);
    }

    public boolean getUseSendfile() {
        return this.getEndpoint().getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        this.getEndpoint().setUseSendfile(useSendfile);
    }

    public int getMaxKeepAliveRequests() {
        return this.getEndpoint().getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.getEndpoint().setMaxKeepAliveRequests(mkar);
    }

    public String getDefaultSSLHostConfigName() {
        return this.getEndpoint().getDefaultSSLHostConfigName();
    }

    public void setDefaultSSLHostConfigName(String defaultSSLHostConfigName) {
        this.getEndpoint().setDefaultSSLHostConfigName(defaultSSLHostConfigName);
        if (this.defaultSSLHostConfig != null) {
            this.defaultSSLHostConfig.setHostName(defaultSSLHostConfigName);
        }
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        this.getEndpoint().addSslHostConfig(sslHostConfig);
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return this.getEndpoint().findSslHostConfigs();
    }

    private void registerDefaultSSLHostConfig() {
        if (this.defaultSSLHostConfig == null) {
            this.defaultSSLHostConfig = new SSLHostConfig();
            this.defaultSSLHostConfig.setHostName(this.getDefaultSSLHostConfigName());
            this.getEndpoint().addSslHostConfig(this.defaultSSLHostConfig);
        }
    }

    public void setSslEnabledProtocols(String enabledProtocols) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setProtocols(enabledProtocols);
    }

    public void setSSLProtocol(String sslProtocol) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setProtocols(sslProtocol);
    }

    public void setKeystoreFile(String keystoreFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreFile(keystoreFile);
    }

    public void setSSLCertificateChainFile(String certificateChainFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateChainFile(certificateChainFile);
    }

    public void setSSLCertificateFile(String certificateFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateFile(certificateFile);
    }

    public void setSSLCertificateKeyFile(String certificateKeyFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyFile(certificateKeyFile);
    }

    public void setAlgorithm(String keyManagerAlgorithm) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setKeyManagerAlgorithm(keyManagerAlgorithm);
    }

    public void setClientAuth(String certificateVerification) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerification(certificateVerification);
    }

    public void setSSLVerifyClient(String certificateVerification) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerification(certificateVerification);
    }

    public void setTrustMaxCertLength(int certificateVerificationDepth) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerificationDepth(certificateVerificationDepth);
    }

    public void setSSLVerifyDepth(int certificateVerificationDepth) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerificationDepth(certificateVerificationDepth);
    }

    public void setUseServerCipherSuitesOrder(String honorCipherOrder) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setHonorCipherOrder(honorCipherOrder);
    }

    public void setSSLHonorCipherOrder(String honorCipherOrder) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setHonorCipherOrder(honorCipherOrder);
    }

    public void setCiphers(String ciphers) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCiphers(ciphers);
    }

    public void setSSLCipherSuite(String ciphers) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCiphers(ciphers);
    }

    public void setKeystorePass(String certificateKeystorePassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystorePassword(certificateKeystorePassword);
    }

    public void setKeyPass(String certificateKeyPassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyPassword(certificateKeyPassword);
    }

    public void setSSLPassword(String certificateKeyPassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyPassword(certificateKeyPassword);
    }

    public void setCrlFile(String certificateRevocationListFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListFile(certificateRevocationListFile);
    }

    public void setSSLCARevocationFile(String certificateRevocationListFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListFile(certificateRevocationListFile);
    }

    public void setSSLCARevocationPath(String certificateRevocationListPath) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListPath(certificateRevocationListPath);
    }

    public void setKeystoreType(String certificateKeystoreType) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreType(certificateKeystoreType);
    }

    public void setKeystoreProvider(String certificateKeystoreProvider) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreProvider(certificateKeystoreProvider);
    }

    public void setKeyAlias(String certificateKeyAlias) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyAlias(certificateKeyAlias);
    }

    public void setTruststoreAlgorithm(String truststoreAlgorithm) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreAlgorithm(truststoreAlgorithm);
    }

    public void setTruststoreFile(String truststoreFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreFile(truststoreFile);
    }

    public void setTruststorePass(String truststorePassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststorePassword(truststorePassword);
    }

    public void setTruststoreType(String truststoreType) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreType(truststoreType);
    }

    public void setTruststoreProvider(String truststoreProvider) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreProvider(truststoreProvider);
    }

    public void setSslProtocol(String sslProtocol) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSslProtocol(sslProtocol);
    }

    public void setSessionCacheSize(int sessionCacheSize) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSessionCacheSize(sessionCacheSize);
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSessionTimeout(sessionTimeout);
    }

    public void setSSLCACertificatePath(String caCertificatePath) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCaCertificatePath(caCertificatePath);
    }

    public void setSSLCACertificateFile(String caCertificateFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCaCertificateFile(caCertificateFile);
    }

    public void setSSLDisableCompression(boolean disableCompression) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setDisableCompression(disableCompression);
    }

    public void setSSLDisableSessionTickets(boolean disableSessionTickets) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setDisableSessionTickets(disableSessionTickets);
    }

    public void setTrustManagerClassName(String trustManagerClassName) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTrustManagerClassName(trustManagerClassName);
    }

    @Override
    protected Processor createProcessor() {
        Http11Processor processor = new Http11Processor(this.getMaxHttpHeaderSize(), this.getEndpoint(), this.getMaxTrailerSize(), this.allowedTrailerHeaders, this.getMaxExtensionSize(), this.getMaxSwallowSize(), this.httpUpgradeProtocols);
        processor.setAdapter(this.getAdapter());
        processor.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
        processor.setConnectionUploadTimeout(this.getConnectionUploadTimeout());
        processor.setDisableUploadTimeout(this.getDisableUploadTimeout());
        processor.setCompressionMinSize(this.getCompressionMinSize());
        processor.setCompression(this.getCompression());
        processor.setNoCompressionUserAgents(this.getNoCompressionUserAgents());
        processor.setCompressableMimeTypes(this.getCompressableMimeTypes());
        processor.setRestrictedUserAgents(this.getRestrictedUserAgents());
        processor.setMaxSavePostSize(this.getMaxSavePostSize());
        processor.setServer(this.getServer());
        processor.setServerRemoveAppProvidedValues(this.getServerRemoveAppProvidedValues());
        return processor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socket, UpgradeToken upgradeToken) {
        HttpUpgradeHandler httpUpgradeHandler = upgradeToken.getHttpUpgradeHandler();
        if (httpUpgradeHandler instanceof InternalHttpUpgradeHandler) {
            return new UpgradeProcessorInternal(socket, upgradeToken);
        }
        return new UpgradeProcessorExternal(socket, upgradeToken);
    }
}

