/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;

public class GzipOutputFilter
implements OutputFilter {
    protected static final Log log = LogFactory.getLog(GzipOutputFilter.class);
    protected OutputBuffer buffer;
    protected GZIPOutputStream compressionStream = null;
    protected final OutputStream fakeOutputStream = new FakeOutputStream();

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream, true);
        }
        this.compressionStream.write(chunk.getBytes(), chunk.getStart(), chunk.getLength());
        return chunk.getLength();
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    public void flush() {
        block4: {
            if (this.compressionStream != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Flushing the compression stream!");
                    }
                    this.compressionStream.flush();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Ignored exception while flushing gzip filter", e);
                }
            }
        }
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public long end() throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream, true);
        }
        this.compressionStream.finish();
        this.compressionStream.close();
        return ((OutputFilter)this.buffer).end();
    }

    @Override
    public void recycle() {
        this.compressionStream = null;
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected final ByteChunk outputChunk = new ByteChunk();
        protected final byte[] singleByteBuffer = new byte[1];

        protected FakeOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.singleByteBuffer[0] = (byte)(b & 0xFF);
            this.outputChunk.setBytes(this.singleByteBuffer, 0, 1);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputChunk.setBytes(b, off, len);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

