/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNio2OutputBuffer
extends AbstractOutputBuffer<Nio2Channel> {
    private static final Log log = LogFactory.getLog(InternalNio2OutputBuffer.class);
    private static final ByteBuffer[] EMPTY_BUF_ARRAY = new ByteBuffer[0];
    private SocketWrapper<Nio2Channel> socket;
    protected volatile boolean interest = false;
    protected volatile boolean flipped = false;
    protected CompletionHandler<Integer, ByteBuffer> completionHandler;
    protected CompletionHandler<Long, ByteBuffer[]> gatherCompletionHandler;
    protected Semaphore writePending = new Semaphore(1);
    protected AbstractEndpoint<Nio2Channel> endpoint = null;
    protected ArrayList<ByteBuffer> bufferedWrites = new ArrayList();
    protected IOException e = null;

    public InternalNio2OutputBuffer(Response response, int headerBufferSize) {
        super(response, headerBufferSize);
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
    }

    @Override
    public void init(SocketWrapper<Nio2Channel> socketWrapper, AbstractEndpoint<Nio2Channel> associatedEndpoint) throws IOException {
        this.socket = socketWrapper;
        this.endpoint = associatedEndpoint;
        this.completionHandler = new CompletionHandler<Integer, ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Integer nBytes, ByteBuffer attachment) {
                boolean notify = false;
                CompletionHandler<Integer, ByteBuffer> completionHandler = InternalNio2OutputBuffer.this.completionHandler;
                synchronized (completionHandler) {
                    if (nBytes < 0) {
                        this.failed((Throwable)new EOFException(AbstractOutputBuffer.sm.getString("iob.failedwrite")), attachment);
                    } else if (InternalNio2OutputBuffer.this.bufferedWrites.size() > 0) {
                        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
                        if (attachment.hasRemaining()) {
                            arrayList.add(attachment);
                        }
                        for (ByteBuffer buffer : InternalNio2OutputBuffer.this.bufferedWrites) {
                            buffer.flip();
                            arrayList.add(buffer);
                        }
                        InternalNio2OutputBuffer.this.bufferedWrites.clear();
                        ByteBuffer[] array = arrayList.toArray(EMPTY_BUF_ARRAY);
                        ((Nio2Channel)InternalNio2OutputBuffer.this.socket.getSocket()).write(array, 0, array.length, InternalNio2OutputBuffer.this.socket.getTimeout(), TimeUnit.MILLISECONDS, array, InternalNio2OutputBuffer.this.gatherCompletionHandler);
                    } else if (attachment.hasRemaining()) {
                        ((Nio2Channel)InternalNio2OutputBuffer.this.socket.getSocket()).write(attachment, InternalNio2OutputBuffer.this.socket.getTimeout(), TimeUnit.MILLISECONDS, attachment, InternalNio2OutputBuffer.this.completionHandler);
                    } else {
                        if (InternalNio2OutputBuffer.this.interest && !Nio2Endpoint.isInline()) {
                            InternalNio2OutputBuffer.this.interest = false;
                            notify = true;
                        }
                        InternalNio2OutputBuffer.this.writePending.release();
                    }
                }
                if (notify) {
                    InternalNio2OutputBuffer.this.endpoint.processSocket(InternalNio2OutputBuffer.this.socket, SocketStatus.OPEN_WRITE, false);
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                if (InternalNio2OutputBuffer.this.socket == null) {
                    log.warn(AbstractOutputBuffer.sm.getString("iob.nio2.nullSocket"), exc);
                    return;
                }
                InternalNio2OutputBuffer.this.socket.setError(true);
                InternalNio2OutputBuffer.this.e = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                InternalNio2OutputBuffer.this.response.getRequest().setAttribute("javax.servlet.error.exception", InternalNio2OutputBuffer.this.e);
                InternalNio2OutputBuffer.this.writePending.release();
                InternalNio2OutputBuffer.this.endpoint.processSocket(InternalNio2OutputBuffer.this.socket, SocketStatus.OPEN_WRITE, true);
            }
        };
        this.gatherCompletionHandler = new CompletionHandler<Long, ByteBuffer[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Long nBytes, ByteBuffer[] attachment) {
                boolean notify = false;
                CompletionHandler<Integer, ByteBuffer> completionHandler = InternalNio2OutputBuffer.this.completionHandler;
                synchronized (completionHandler) {
                    if (nBytes < 0L) {
                        this.failed((Throwable)new EOFException(AbstractOutputBuffer.sm.getString("iob.failedwrite")), attachment);
                    } else if (InternalNio2OutputBuffer.this.bufferedWrites.size() > 0 || InternalNio2OutputBuffer.arrayHasData(attachment)) {
                        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
                        for (ByteBuffer buffer : attachment) {
                            if (!buffer.hasRemaining()) continue;
                            arrayList.add(buffer);
                        }
                        for (ByteBuffer buffer : InternalNio2OutputBuffer.this.bufferedWrites) {
                            buffer.flip();
                            arrayList.add(buffer);
                        }
                        InternalNio2OutputBuffer.this.bufferedWrites.clear();
                        ByteBuffer[] array = arrayList.toArray(EMPTY_BUF_ARRAY);
                        ((Nio2Channel)InternalNio2OutputBuffer.this.socket.getSocket()).write(array, 0, array.length, InternalNio2OutputBuffer.this.socket.getTimeout(), TimeUnit.MILLISECONDS, array, InternalNio2OutputBuffer.this.gatherCompletionHandler);
                    } else {
                        if (InternalNio2OutputBuffer.this.interest && !Nio2Endpoint.isInline()) {
                            InternalNio2OutputBuffer.this.interest = false;
                            notify = true;
                        }
                        InternalNio2OutputBuffer.this.writePending.release();
                    }
                }
                if (notify) {
                    InternalNio2OutputBuffer.this.endpoint.processSocket(InternalNio2OutputBuffer.this.socket, SocketStatus.OPEN_WRITE, false);
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer[] attachment) {
                if (InternalNio2OutputBuffer.this.socket == null) {
                    log.debug(AbstractOutputBuffer.sm.getString("iob.nio2.nullSocket"), exc);
                    return;
                }
                InternalNio2OutputBuffer.this.socket.setError(true);
                InternalNio2OutputBuffer.this.e = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                InternalNio2OutputBuffer.this.response.getRequest().setAttribute("javax.servlet.error.exception", InternalNio2OutputBuffer.this.e);
                InternalNio2OutputBuffer.this.writePending.release();
                InternalNio2OutputBuffer.this.endpoint.processSocket(InternalNio2OutputBuffer.this.socket, SocketStatus.OPEN_WRITE, true);
            }
        };
    }

    @Override
    public void recycle() {
        super.recycle();
        this.socket = null;
        this.e = null;
        this.flipped = false;
        this.interest = false;
        if (this.writePending.availablePermits() != 1) {
            this.writePending.drainPermits();
            this.writePending.release();
        }
        this.bufferedWrites.clear();
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.flipped = false;
        this.interest = false;
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.addToBB(Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
            this.flushBuffer(true);
        }
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.addToBB(this.headerBuffer, 0, this.pos);
        }
    }

    private static boolean arrayHasData(ByteBuffer[] byteBuffers) {
        for (ByteBuffer byteBuffer : byteBuffers) {
            if (!byteBuffer.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBB(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.socket == null || this.socket.getSocket() == null) {
            return;
        }
        ByteBuffer writeByteBuffer = this.socket.getSocket().getBufHandler().getWriteBuffer();
        this.socket.access();
        if (this.isBlocking()) {
            while (length > 0) {
                int thisTime = this.transfer(buf, offset, length, writeByteBuffer);
                length -= thisTime;
                offset += thisTime;
                if (writeByteBuffer.remaining() != 0) continue;
                this.flushBuffer(true);
            }
        } else if (this.writePending.tryAcquire()) {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.completionHandler;
            synchronized (completionHandler) {
                int thisTime = this.transfer(buf, offset, length, writeByteBuffer);
                offset += thisTime;
                if ((length -= thisTime) > 0) {
                    this.addToBuffers(buf, offset, length);
                }
                this.flushBufferInternal(false, true);
            }
        } else {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.completionHandler;
            synchronized (completionHandler) {
                this.addToBuffers(buf, offset, length);
            }
        }
    }

    private void addToBuffers(byte[] buf, int offset, int length) {
        ByteBuffer buffer = ByteBuffer.allocate(Math.max(this.bufferedWriteSize, length));
        buffer.put(buf, offset, length);
        this.bufferedWrites.add(buffer);
    }

    private int transfer(byte[] from, int offset, int length, ByteBuffer to) {
        int max = Math.min(length, to.remaining());
        to.put(from, offset, max);
        return max;
    }

    @Override
    protected boolean flushBuffer(boolean block) throws IOException {
        if (this.e != null) {
            throw this.e;
        }
        return this.flushBufferInternal(block, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushBufferInternal(boolean block, boolean hasPermit) throws IOException {
        if (this.socket == null || this.socket.getSocket() == null) {
            return false;
        }
        ByteBuffer byteBuffer = this.socket.getSocket().getBufHandler().getWriteBuffer();
        CompletionHandler<Integer, ByteBuffer> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            if (block) {
                if (!this.isBlocking()) {
                    try {
                        if (this.writePending.tryAcquire(this.socket.getTimeout(), TimeUnit.MILLISECONDS)) {
                            this.writePending.release();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Future<Integer> future = null;
                try {
                    if (this.bufferedWrites.size() > 0) {
                        for (ByteBuffer buffer : this.bufferedWrites) {
                            buffer.flip();
                            while (buffer.hasRemaining()) {
                                future = this.socket.getSocket().write(buffer);
                                if (future.get(this.socket.getTimeout(), TimeUnit.MILLISECONDS) >= 0) continue;
                                throw new EOFException(sm.getString("iob.failedwrite"));
                            }
                        }
                        this.bufferedWrites.clear();
                    }
                    if (!this.flipped) {
                        byteBuffer.flip();
                        this.flipped = true;
                    }
                    while (byteBuffer.hasRemaining()) {
                        future = this.socket.getSocket().write(byteBuffer);
                        if (future.get(this.socket.getTimeout(), TimeUnit.MILLISECONDS) >= 0) continue;
                        throw new EOFException(sm.getString("iob.failedwrite"));
                    }
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(e);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                catch (TimeoutException e) {
                    future.cancel(true);
                    throw new SocketTimeoutException();
                }
                byteBuffer.clear();
                this.flipped = false;
                return false;
            }
            if (hasPermit || this.writePending.tryAcquire()) {
                this.socket.access();
                if (!this.flipped) {
                    byteBuffer.flip();
                    this.flipped = true;
                }
                Nio2Endpoint.startInline();
                if (this.bufferedWrites.size() > 0) {
                    ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
                    if (byteBuffer.hasRemaining()) {
                        arrayList.add(byteBuffer);
                    }
                    for (ByteBuffer buffer : this.bufferedWrites) {
                        buffer.flip();
                        arrayList.add(buffer);
                    }
                    this.bufferedWrites.clear();
                    ByteBuffer[] array = arrayList.toArray(EMPTY_BUF_ARRAY);
                    this.socket.getSocket().write(array, 0, array.length, this.socket.getTimeout(), TimeUnit.MILLISECONDS, array, this.gatherCompletionHandler);
                } else if (byteBuffer.hasRemaining()) {
                    this.socket.getSocket().write(byteBuffer, this.socket.getTimeout(), TimeUnit.MILLISECONDS, byteBuffer, this.completionHandler);
                } else {
                    this.writePending.release();
                }
                Nio2Endpoint.endInline();
                if (this.writePending.availablePermits() > 0 && byteBuffer.remaining() == 0) {
                    byteBuffer.clear();
                    this.flipped = false;
                }
            }
            return this.hasMoreDataToFlush() || this.hasBufferedData() || this.e != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDataToWrite() {
        CompletionHandler<Integer, ByteBuffer> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            return this.hasMoreDataToFlush() || this.hasBufferedData() || this.e != null;
        }
    }

    @Override
    protected boolean hasMoreDataToFlush() {
        return this.flipped && this.socket.getSocket().getBufHandler().getWriteBuffer().remaining() > 0 || !this.flipped && this.socket.getSocket().getBufHandler().getWriteBuffer().position() > 0;
    }

    @Override
    protected boolean hasBufferedData() {
        return this.bufferedWrites.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWriteInterest() {
        CompletionHandler<Integer, ByteBuffer> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            if (this.writePending.availablePermits() == 0) {
                this.interest = true;
            } else {
                this.endpoint.processSocket(this.socket, SocketStatus.OPEN_WRITE, true);
            }
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            try {
                int len = chunk.getLength();
                int start = chunk.getStart();
                byte[] b = chunk.getBuffer();
                InternalNio2OutputBuffer.this.addToBB(b, start, len);
                InternalNio2OutputBuffer.this.byteCount += (long)len;
                return len;
            }
            catch (IOException ioe) {
                InternalNio2OutputBuffer.this.response.action(ActionCode.CLOSE_NOW, ioe);
                throw ioe;
            }
        }

        @Override
        public long getBytesWritten() {
            return InternalNio2OutputBuffer.this.byteCount;
        }
    }
}

