/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ByteBufferHolder;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalAprOutputBuffer
extends AbstractOutputBuffer<Long> {
    private long socket;
    private SocketWrapper<Long> wrapper;
    private final ByteBuffer bbuf;
    private volatile boolean flipped = false;
    private AbstractEndpoint<Long> endpoint;

    public InternalAprOutputBuffer(Response response, int headerBufferSize) {
        super(response, headerBufferSize);
        this.bbuf = headerBufferSize < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((headerBufferSize / 1500 + 1) * 1500);
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
    }

    @Override
    public void init(SocketWrapper<Long> socketWrapper, AbstractEndpoint<Long> endpoint) throws IOException {
        this.wrapper = socketWrapper;
        this.socket = socketWrapper.getSocket();
        this.endpoint = endpoint;
        Socket.setsbb(this.socket, this.bbuf);
    }

    @Override
    public void recycle() {
        super.recycle();
        this.bbuf.clear();
        this.flipped = false;
        this.socket = 0L;
        this.wrapper = null;
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed && Socket.send(this.socket, Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length) < 0) {
            throw new IOException(sm.getString("iob.failedwrite.ack"));
        }
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.bbuf.put(this.headerBuffer, 0, this.pos);
        }
    }

    private synchronized void addToBB(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.flipped) {
            this.addToBuffers(buf, offset, length);
            return;
        }
        while (length > 0) {
            int thisTime = length;
            if (this.bbuf.position() == this.bbuf.capacity() && this.flushBuffer(this.isBlocking())) break;
            if (thisTime > this.bbuf.capacity() - this.bbuf.position()) {
                thisTime = this.bbuf.capacity() - this.bbuf.position();
            }
            this.bbuf.put(buf, offset, thisTime);
            length -= thisTime;
            offset += thisTime;
        }
        this.wrapper.access();
        if (!this.isBlocking() && length > 0) {
            this.addToBuffers(buf, offset, length);
        }
    }

    private void addToBuffers(byte[] buf, int offset, int length) {
        ByteBufferHolder holder = (ByteBufferHolder)this.bufferedWrites.peekLast();
        if (holder == null || holder.isFlipped() || holder.getBuf().remaining() < length) {
            ByteBuffer buffer = ByteBuffer.allocate(Math.max(this.bufferedWriteSize, length));
            holder = new ByteBufferHolder(buffer, false);
            this.bufferedWrites.add(holder);
        }
        holder.getBuf().put(buf, offset, length);
    }

    @Override
    protected synchronized boolean flushBuffer(boolean block) throws IOException {
        this.wrapper.access();
        if (this.hasMoreDataToFlush()) {
            this.writeToSocket(block);
        }
        if (this.bufferedWrites.size() > 0) {
            Iterator bufIter = this.bufferedWrites.iterator();
            while (!this.hasMoreDataToFlush() && bufIter.hasNext()) {
                ByteBufferHolder buffer = (ByteBufferHolder)bufIter.next();
                buffer.flip();
                while (!this.hasMoreDataToFlush() && buffer.getBuf().remaining() > 0) {
                    this.transfer(buffer.getBuf(), this.bbuf);
                    if (buffer.getBuf().remaining() == 0) {
                        bufIter.remove();
                    }
                    this.writeToSocket(block);
                }
            }
        }
        return this.hasMoreDataToFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeToSocket(boolean block) throws IOException {
        Lock readLock = this.wrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.wrapper.getBlockingStatusWriteLock();
        readLock.lock();
        try {
            if (this.wrapper.getBlockingStatus() == block) {
                this.writeToSocket();
                return;
            }
        }
        finally {
            readLock.unlock();
        }
        writeLock.lock();
        try {
            this.wrapper.setBlockingStatus(block);
            if (block) {
                Socket.timeoutSet(this.socket, this.endpoint.getSoTimeout() * 1000);
            } else {
                Socket.timeoutSet(this.socket, 0L);
            }
            readLock.lock();
            try {
                writeLock.unlock();
                this.writeToSocket();
            }
            finally {
                readLock.unlock();
            }
        }
        finally {
            if (writeLock.isHeldByCurrentThread()) {
                writeLock.unlock();
            }
        }
    }

    private synchronized void writeToSocket() throws IOException {
        int written;
        if (!this.flipped) {
            this.flipped = true;
            this.bbuf.flip();
        }
        do {
            if (Status.APR_STATUS_IS_EAGAIN(-(written = Socket.sendbb(this.socket, this.bbuf.position(), this.bbuf.remaining())))) {
                written = 0;
            } else if (written < 0) {
                throw new IOException("APR error: " + written);
            }
            this.bbuf.position(this.bbuf.position() + written);
        } while (written > 0 && this.bbuf.hasRemaining());
        if (this.bbuf.remaining() == 0) {
            this.bbuf.clear();
            this.flipped = false;
        }
    }

    private void transfer(ByteBuffer from, ByteBuffer to) {
        int max = Math.min(from.remaining(), to.remaining());
        int fromLimit = from.limit();
        from.limit(from.position() + max);
        to.put(from);
        from.limit(fromLimit);
    }

    @Override
    protected synchronized boolean hasMoreDataToFlush() {
        return this.flipped && this.bbuf.remaining() > 0 || !this.flipped && this.bbuf.position() > 0;
    }

    @Override
    protected void registerWriteInterest() {
        this.wrapper.registerforEvent(-1, false, true);
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            try {
                int len = chunk.getLength();
                int start = chunk.getStart();
                byte[] b = chunk.getBuffer();
                InternalAprOutputBuffer.this.addToBB(b, start, len);
                InternalAprOutputBuffer.this.byteCount += (long)chunk.getLength();
                return chunk.getLength();
            }
            catch (IOException ioe) {
                InternalAprOutputBuffer.this.response.action(ActionCode.CLOSE_NOW, ioe);
                throw ioe;
            }
        }

        @Override
        public long getBytesWritten() {
            return InternalAprOutputBuffer.this.byteCount;
        }
    }
}

