/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.coyote.http11.upgrade.NioProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11NioProtocol
extends AbstractHttp11JsseProtocol<NioChannel> {
    private static final Log log = LogFactory.getLog(Http11NioProtocol.class);
    private final Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11NioProtocol() {
        this.endpoint = new NioEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((NioEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public NioEndpoint getEndpoint() {
        return (NioEndpoint)this.endpoint;
    }

    public void setPollerThreadCount(int count) {
        ((NioEndpoint)this.endpoint).setPollerThreadCount(count);
    }

    public int getPollerThreadCount() {
        return ((NioEndpoint)this.endpoint).getPollerThreadCount();
    }

    public void setSelectorTimeout(long timeout) {
        ((NioEndpoint)this.endpoint).setSelectorTimeout(timeout);
    }

    public long getSelectorTimeout() {
        return ((NioEndpoint)this.endpoint).getSelectorTimeout();
    }

    public void setAcceptorThreadPriority(int threadPriority) {
        ((NioEndpoint)this.endpoint).setAcceptorThreadPriority(threadPriority);
    }

    public void setPollerThreadPriority(int threadPriority) {
        ((NioEndpoint)this.endpoint).setPollerThreadPriority(threadPriority);
    }

    public int getAcceptorThreadPriority() {
        return ((NioEndpoint)this.endpoint).getAcceptorThreadPriority();
    }

    public int getPollerThreadPriority() {
        return ((NioEndpoint)this.endpoint).getThreadPriority();
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        ((NioEndpoint)this.endpoint).setUseSendfile(useSendfile);
    }

    public void setOomParachute(int oomParachute) {
        ((NioEndpoint)this.endpoint).setOomParachute(oomParachute);
    }

    @Override
    protected String getNamePrefix() {
        return "http-nio";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<NioChannel, Http11NioProcessor>
    implements NioEndpoint.Handler {
        protected Http11NioProtocol proto;

        Http11ConnectionHandler(Http11NioProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol<NioChannel> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void release(SocketChannel socket) {
            if (log.isDebugEnabled()) {
                log.debug("Iterating through our connections to release a socket channel:" + socket);
            }
            boolean released = false;
            Iterator it = this.connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (((NioChannel)entry.getKey()).getIOChannel() != socket) continue;
                it.remove();
                Processor result = (Processor)entry.getValue();
                result.recycle(true);
                this.unregister(result);
                released = true;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug("Done iterating through our connections to release a socket channel:" + socket + " released:" + released);
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socket) {
            Processor processor = (Processor)this.connections.remove(socket.getSocket());
            if (processor != null) {
                processor.recycle(true);
                if (!processor.isUpgrade()) {
                    this.recycledProcessors.push(processor);
                }
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socket, Processor<NioChannel> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.push(processor);
            if (addToPoller) {
                socket.setTimeout(this.getProtocol().getKeepAliveTimeout());
                socket.getSocket().getPoller().add(socket.getSocket());
            }
        }

        @Override
        protected void initSsl(SocketWrapper<NioChannel> socket, Processor<NioChannel> processor) {
            if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null && socket.getSocket() instanceof SecureNioChannel) {
                SecureNioChannel ch = (SecureNioChannel)socket.getSocket();
                processor.setSslSupport(this.proto.sslImplementation.getSSLSupport(ch.getSslEngine().getSession()));
            } else {
                processor.setSslSupport(null);
            }
        }

        @Override
        protected void longPoll(SocketWrapper<NioChannel> socket, Processor<NioChannel> processor) {
            if (processor.isAsync()) {
                socket.setAsync(true);
            } else {
                socket.getSocket().getPoller().add(socket.getSocket());
            }
        }

        @Override
        public Http11NioProcessor createProcessor() {
            Http11NioProcessor processor = new Http11NioProcessor(this.proto.getMaxHttpHeaderSize(), this.proto.getRejectIllegalHeaderName(), (NioEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize(), this.proto.getAllowedTrailerHeadersAsSet(), this.proto.getMaxExtensionSize(), this.proto.getMaxSwallowSize(), this.proto.getRelaxedPathChars(), this.proto.getRelaxedQueryChars());
            this.proto.configureProcessor(processor);
            this.register(processor);
            return processor;
        }

        @Override
        protected Processor<NioChannel> createUpgradeProcessor(SocketWrapper<NioChannel> socket, ByteBuffer leftoverInput, UpgradeToken upgradeToken) throws IOException {
            return new NioProcessor(socket, leftoverInput, upgradeToken, this.proto.getEndpoint().getSelectorPool(), this.proto.getUpgradeAsyncWriteBufferSize());
        }
    }
}

