/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.catalina.webresources.AbstractArchiveResource;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JarWarResource
extends AbstractArchiveResource {
    private static final Log log = LogFactory.getLog(JarWarResource.class);
    private final String archivePath;

    public JarWarResource(AbstractArchiveResourceSet archiveResourceSet, String webAppPath, String baseUrl, JarEntry jarEntry, String archivePath) {
        super(archiveResourceSet, webAppPath, "jar:war:" + baseUrl + "*/" + archivePath, jarEntry, "jar:" + baseUrl + "!/" + archivePath);
        this.archivePath = archivePath;
    }

    @Override
    protected AbstractArchiveResource.JarInputStreamWrapper getJarInputStreamWrapper() {
        try {
            JarFile warFile = this.getArchiveResourceSet().openJarFile();
            JarEntry jarFileInWar = warFile.getJarEntry(this.archivePath);
            InputStream isInWar = warFile.getInputStream(jarFileInWar);
            JarInputStream jarIs = new JarInputStream(isInWar);
            JarEntry entry = jarIs.getNextJarEntry();
            while (entry != null && !entry.getName().equals(this.getResource().getName())) {
                entry = jarIs.getNextJarEntry();
            }
            if (entry == null) {
                try {
                    jarIs.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    warFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            return new AbstractArchiveResource.JarInputStreamWrapper(entry, jarIs);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jarResource.getInputStreamFail", this.getResource().getName(), this.getBaseUrl()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

