/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DistributedManager;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.FailedContext;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class HostConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(HostConfig.class);
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected Host host = null;
    protected ObjectName oname = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected boolean deployXML = false;
    protected boolean copyXML = false;
    protected boolean unpackWARs = false;
    protected final Map<String, DeployedApplication> deployed = new ConcurrentHashMap<String, DeployedApplication>();
    protected final ArrayList<String> serviced = new ArrayList();
    protected Digester digester = HostConfig.createDigester(this.contextClass);
    private final Object digesterLock = new Object();
    protected final Set<String> invalidWars = new HashSet<String>();

    public String getContextClass() {
        return this.contextClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        if (!oldContextClass.equals(contextClass)) {
            Object object = this.digesterLock;
            synchronized (object) {
                this.digester = HostConfig.createDigester(this.getContextClass());
            }
        }
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isCopyXML() {
        return this.copyXML;
    }

    public void setCopyXML(boolean copyXML) {
        this.copyXML = copyXML;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)event.getLifecycle();
            if (this.host instanceof StandardHost) {
                this.setCopyXML(((StandardHost)this.host).isCopyXML());
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
                this.setContextClass(((StandardHost)this.host).getContextClass());
            }
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("hostConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("periodic")) {
            this.check();
        } else if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    public synchronized void addServiced(String name) {
        this.serviced.add(name);
    }

    public synchronized boolean isServiced(String name) {
        return this.serviced.contains(name);
    }

    public synchronized void removeServiced(String name) {
        this.serviced.remove(name);
    }

    public long getDeploymentTime(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app == null) {
            return 0L;
        }
        return app.timestamp;
    }

    public boolean isDeployed(String name) {
        DeployedApplication app = this.deployed.get(name);
        return app != null;
    }

    protected static Digester createDigester(String contextClassName) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("Context", contextClassName, "className");
        digester.addSetProperties("Context");
        return digester;
    }

    protected File returnCanonicalPath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.host.getCatalinaBase(), path);
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public String getConfigBaseName() {
        return this.host.getConfigBaseFile().getAbsolutePath();
    }

    protected void deployApps() {
        File appBase = this.host.getAppBaseFile();
        File configBase = this.host.getConfigBaseFile();
        String[] filteredAppPaths = this.filterAppPaths(appBase.list());
        this.deployDescriptors(configBase, configBase.list());
        this.deployWARs(appBase, filteredAppPaths);
        this.deployDirectories(appBase, filteredAppPaths);
    }

    protected String[] filterAppPaths(String[] unfilteredAppPaths) {
        Pattern filter = this.host.getDeployIgnorePattern();
        if (filter == null) {
            return unfilteredAppPaths;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        Matcher matcher = null;
        for (String appPath : unfilteredAppPaths) {
            if (matcher == null) {
                matcher = filter.matcher(appPath);
            } else {
                matcher.reset(appPath);
            }
            if (matcher.matches()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("hostConfig.ignorePath", appPath));
                continue;
            }
            filteredList.add(appPath);
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    protected void deployApps(String name) {
        File appBase = this.host.getAppBaseFile();
        File configBase = this.host.getConfigBaseFile();
        ContextName cn = new ContextName(name, false);
        String baseName = cn.getBaseName();
        if (this.deploymentExists(cn.getName())) {
            return;
        }
        File xml = new File(configBase, baseName + ".xml");
        if (xml.exists()) {
            this.deployDescriptor(cn, xml);
            return;
        }
        File war = new File(appBase, baseName + ".war");
        if (war.exists()) {
            this.deployWAR(cn, war);
            return;
        }
        File dir = new File(appBase, baseName);
        if (dir.exists()) {
            this.deployDirectory(cn, dir);
        }
    }

    protected void deployDescriptors(File configBase, String[] files) {
        if (files == null) {
            return;
        }
        ExecutorService es = this.host.getStartStopExecutor();
        ArrayList results = new ArrayList();
        for (int i = 0; i < files.length; ++i) {
            ContextName cn;
            File file = new File(configBase, files[i]);
            if (!files[i].toLowerCase(Locale.ENGLISH).endsWith(".xml") || this.isServiced((cn = new ContextName(files[i], true)).getName()) || this.deploymentExists(cn.getName())) continue;
            results.add(es.submit(new DeployDescriptor(this, cn, file)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("hostConfig.deployDescriptor.threaded.error"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDescriptor(ContextName cn, File contextXml) {
        DeployedApplication deployedApp = new DeployedApplication(cn.getName(), true);
        long startTime = 0L;
        if (log.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            log.info((Object)sm.getString("hostConfig.deployDescriptor", contextXml.getAbsolutePath()));
        }
        Context context = null;
        boolean isExternalWar = false;
        boolean isExternal = false;
        File expandedDocBase = null;
        try (FileInputStream fis = new FileInputStream(contextXml);){
            Object object = this.digesterLock;
            synchronized (object) {
                try {
                    context = (Context)this.digester.parse(fis);
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("hostConfig.deployDescriptor.error", contextXml.getAbsolutePath()), (Throwable)e);
                }
                finally {
                    if (context == null) {
                        context = new FailedContext();
                    }
                    this.digester.reset();
                }
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.newInstance();
            context.addLifecycleListener(listener);
            context.setConfigFile(contextXml.toURI().toURL());
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            if (context.getDocBase() != null) {
                File docBase = new File(context.getDocBase());
                if (!docBase.isAbsolute()) {
                    docBase = new File(this.host.getAppBaseFile(), context.getDocBase());
                }
                if (!docBase.getCanonicalPath().startsWith(this.host.getAppBaseFile().getAbsolutePath() + File.separator)) {
                    isExternal = true;
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), contextXml.lastModified());
                    deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
                    if (docBase.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                        isExternalWar = true;
                    }
                } else {
                    log.warn((Object)sm.getString("hostConfig.deployDescriptor.localDocBaseSpecified", docBase));
                    context.setDocBase(null);
                }
            }
            this.host.addChild(context);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", contextXml.getAbsolutePath()), t);
        }
        finally {
            expandedDocBase = new File(this.host.getAppBaseFile(), cn.getBaseName());
            if (context.getDocBase() != null && !(expandedDocBase = new File(context.getDocBase())).isAbsolute()) {
                expandedDocBase = new File(this.host.getAppBaseFile(), context.getDocBase());
            }
            if (isExternalWar && this.unpackWARs) {
                deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), expandedDocBase.lastModified());
                deployedApp.redeployResources.put(contextXml.getAbsolutePath(), contextXml.lastModified());
                this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
            } else {
                if (!isExternal) {
                    File warDocBase = new File(expandedDocBase.getAbsolutePath() + ".war");
                    if (warDocBase.exists()) {
                        deployedApp.redeployResources.put(warDocBase.getAbsolutePath(), warDocBase.lastModified());
                    } else {
                        deployedApp.redeployResources.put(warDocBase.getAbsolutePath(), 0L);
                    }
                }
                if (expandedDocBase.exists()) {
                    deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), expandedDocBase.lastModified());
                    this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
                } else {
                    if (!isExternal && !this.unpackWARs) {
                        deployedApp.reloadResources.put(expandedDocBase.getAbsolutePath(), 0L);
                    }
                    this.addWatchedResources(deployedApp, null, context);
                }
                if (!isExternal) {
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), contextXml.lastModified());
                }
            }
            this.addGlobalRedeployResources(deployedApp);
        }
        if (this.host.findChild(context.getName()) != null) {
            this.deployed.put(context.getName(), deployedApp);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.deployDescriptor.finished", contextXml.getAbsolutePath(), System.currentTimeMillis() - startTime));
        }
    }

    protected void deployWARs(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        ExecutorService es = this.host.getStartStopExecutor();
        ArrayList results = new ArrayList();
        for (int i = 0; i < files.length; ++i) {
            ContextName cn;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF")) continue;
            File file = new File(appBase, files[i]);
            if (!files[i].toLowerCase(Locale.ENGLISH).endsWith(".war") || !file.isFile() || this.invalidWars.contains(files[i]) || this.isServiced((cn = new ContextName(files[i], true)).getName())) continue;
            if (this.deploymentExists(cn.getName())) {
                DeployedApplication app = this.deployed.get(cn.getName());
                if (this.unpackWARs || app == null) continue;
                File dir = new File(appBase, cn.getBaseName());
                if (dir.exists()) {
                    if (app.loggedDirWarning) continue;
                    log.warn((Object)sm.getString("hostConfig.deployWar.hiddenDir", dir.getAbsoluteFile(), file.getAbsoluteFile()));
                    app.loggedDirWarning = true;
                    continue;
                }
                app.loggedDirWarning = false;
                continue;
            }
            if (!this.validateContextPath(appBase, cn.getBaseName())) {
                log.error((Object)sm.getString("hostConfig.illegalWarName", files[i]));
                this.invalidWars.add(files[i]);
                continue;
            }
            results.add(es.submit(new DeployWar(this, cn, file)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("hostConfig.deployWar.threaded.error"), (Throwable)e);
            }
        }
    }

    private boolean validateContextPath(File appBase, String contextPath) {
        StringBuilder docBase;
        String canonicalDocBase = null;
        try {
            String canonicalAppBase = appBase.getCanonicalPath();
            docBase = new StringBuilder(canonicalAppBase);
            if (canonicalAppBase.endsWith(File.separator)) {
                docBase.append(contextPath.substring(1).replace('/', File.separatorChar));
            } else {
                docBase.append(contextPath.replace('/', File.separatorChar));
            }
            canonicalDocBase = new File(docBase.toString()).getCanonicalPath();
            if (canonicalDocBase.endsWith(File.separator)) {
                docBase.append(File.separator);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return canonicalDocBase.equals(docBase.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWAR(ContextName cn, File war) {
        Throwable throwable;
        InputStream istream;
        Throwable throwable2;
        JarFile jar;
        Context context;
        JarEntry entry;
        boolean xmlInWar;
        File xml;
        block140: {
            Object object;
            xml = new File(this.host.getAppBaseFile(), cn.getBaseName() + "/META-INF/context.xml");
            xmlInWar = false;
            entry = null;
            try {
                JarFile jar2 = new JarFile(war);
                object = null;
                try {
                    entry = jar2.getJarEntry("META-INF/context.xml");
                    if (entry != null) {
                        xmlInWar = true;
                    }
                }
                catch (Throwable x2) {
                    object = x2;
                    throw x2;
                }
                finally {
                    if (jar2 != null) {
                        if (object != null) {
                            try {
                                jar2.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)object).addSuppressed(x2);
                            }
                        } else {
                            jar2.close();
                        }
                    }
                }
            }
            catch (IOException e) {
            }
            finally {
                entry = null;
            }
            context = null;
            try {
                if (this.deployXML && xml.exists() && !this.copyXML) {
                    object = this.digesterLock;
                    synchronized (object) {
                        try {
                            context = (Context)this.digester.parse(xml);
                        }
                        catch (Exception e) {
                            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", war.getAbsolutePath()), (Throwable)e);
                        }
                        finally {
                            if (context == null) {
                                context = new FailedContext();
                            }
                            this.digester.reset();
                        }
                    }
                    context.setConfigFile(xml.toURI().toURL());
                    break block140;
                }
                if (this.deployXML && xmlInWar) {
                    object = this.digesterLock;
                    synchronized (object) {
                        try {
                            jar = new JarFile(war);
                            throwable2 = null;
                            try {
                                entry = jar.getJarEntry("META-INF/context.xml");
                                istream = jar.getInputStream(entry);
                                throwable = null;
                                try {
                                    context = (Context)this.digester.parse(istream);
                                }
                                catch (Throwable x2) {
                                    throwable = x2;
                                    throw x2;
                                }
                                finally {
                                    if (istream != null) {
                                        if (throwable != null) {
                                            try {
                                                istream.close();
                                            }
                                            catch (Throwable x2) {
                                                throwable.addSuppressed(x2);
                                            }
                                        } else {
                                            istream.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable x2) {
                                throwable2 = x2;
                                throw x2;
                            }
                            finally {
                                if (jar != null) {
                                    if (throwable2 != null) {
                                        try {
                                            jar.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable2.addSuppressed(x2);
                                        }
                                    } else {
                                        jar.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", war.getAbsolutePath()), (Throwable)e);
                        }
                        finally {
                            if (context == null) {
                                context = new FailedContext();
                            }
                            context.setConfigFile(new URL("jar:" + war.toURI().toString() + "!/" + "META-INF/context.xml"));
                            entry = null;
                            this.digester.reset();
                        }
                        break block140;
                    }
                }
                if (!this.deployXML && xmlInWar) {
                    log.error((Object)sm.getString("hostConfig.deployDescriptor.blocked", cn.getPath(), "META-INF/context.xml", new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml")));
                } else {
                    context = (Context)Class.forName(this.contextClass).newInstance();
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error((Object)sm.getString("hostConfig.deployWar.error", war.getAbsolutePath()), t);
            }
            finally {
                if (context == null) {
                    context = new FailedContext();
                }
            }
        }
        boolean copyThisXml = false;
        if (this.deployXML) {
            if (this.host instanceof StandardHost) {
                copyThisXml = ((StandardHost)this.host).isCopyXML();
            }
            if (!copyThisXml && context instanceof StandardContext) {
                copyThisXml = ((StandardContext)context).getCopyXML();
            }
            if (xmlInWar && copyThisXml) {
                xml = new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml");
                entry = null;
                try {
                    jar = new JarFile(war);
                    throwable2 = null;
                    try {
                        entry = jar.getJarEntry("META-INF/context.xml");
                        istream = jar.getInputStream(entry);
                        throwable = null;
                        try (FileOutputStream fos = new FileOutputStream(xml);
                             BufferedOutputStream ostream = new BufferedOutputStream(fos, 1024);){
                            int n;
                            byte[] buffer = new byte[1024];
                            while ((n = istream.read(buffer)) >= 0) {
                                ostream.write(buffer, 0, n);
                            }
                            ostream.flush();
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (istream != null) {
                                if (throwable != null) {
                                    try {
                                        istream.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    istream.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (jar != null) {
                            if (throwable2 != null) {
                                try {
                                    jar.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                            } else {
                                jar.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        DeployedApplication deployedApp = new DeployedApplication(cn.getName(), xml.exists() && this.deployXML && copyThisXml);
        long startTime = 0L;
        if (log.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            log.info((Object)sm.getString("hostConfig.deployWar", war.getAbsolutePath()));
        }
        try {
            deployedApp.redeployResources.put(war.getAbsolutePath(), war.lastModified());
            if (this.deployXML && xml.exists() && copyThisXml) {
                deployedApp.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
            } else if (!copyThisXml) {
                deployedApp.redeployResources.put(new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml").getAbsolutePath(), 0L);
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.newInstance();
            context.addLifecycleListener(listener);
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            context.setDocBase(cn.getBaseName() + ".war");
            this.host.addChild(context);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("hostConfig.deployWar.error", war.getAbsolutePath()), t);
        }
        finally {
            if (this.unpackWARs && context != null && context.getDocBase() != null) {
                File docBase = new File(this.host.getAppBaseFile(), cn.getBaseName());
                deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
                this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
                if (this.deployXML && !copyThisXml && (xmlInWar || xml.exists())) {
                    deployedApp.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
                }
            } else {
                this.addWatchedResources(deployedApp, null, context);
            }
            this.addGlobalRedeployResources(deployedApp);
        }
        this.deployed.put(cn.getName(), deployedApp);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.deployWar.finished", war.getAbsolutePath(), System.currentTimeMillis() - startTime));
        }
    }

    protected void deployDirectories(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        ExecutorService es = this.host.getStartStopExecutor();
        ArrayList results = new ArrayList();
        for (int i = 0; i < files.length; ++i) {
            ContextName cn;
            File file;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || !(file = new File(appBase, files[i])).isDirectory() || this.isServiced((cn = new ContextName(files[i], false)).getName()) || this.deploymentExists(cn.getName())) continue;
            results.add(es.submit(new DeployDirectory(this, cn, file)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("hostConfig.deployDir.threaded.error"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDirectory(ContextName cn, File dir) {
        DeployedApplication deployedApp2;
        long startTime = 0L;
        if (log.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            log.info((Object)sm.getString("hostConfig.deployDir", dir.getAbsolutePath()));
        }
        Context context = null;
        File xml = new File(dir, "META-INF/context.xml");
        File xmlCopy = new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml");
        boolean copyThisXml = this.copyXML;
        try {
            if (this.deployXML && xml.exists()) {
                Object object = this.digesterLock;
                synchronized (object) {
                    try {
                        context = (Context)this.digester.parse(xml);
                    }
                    catch (Exception e) {
                        log.error((Object)sm.getString("hostConfig.deployDescriptor.error", xml), (Throwable)e);
                        context = new FailedContext();
                    }
                    finally {
                        if (context == null) {
                            context = new FailedContext();
                        }
                        this.digester.reset();
                    }
                }
                if (!copyThisXml && context instanceof StandardContext) {
                    copyThisXml = ((StandardContext)context).getCopyXML();
                }
                if (copyThisXml) {
                    try (FileInputStream is = new FileInputStream(xml);
                         FileOutputStream os = new FileOutputStream(xmlCopy);){
                        IOTools.flow(is, os);
                    }
                    context.setConfigFile(xmlCopy.toURI().toURL());
                } else {
                    context.setConfigFile(xml.toURI().toURL());
                }
            } else if (!this.deployXML && xml.exists()) {
                log.error((Object)sm.getString("hostConfig.deployDescriptor.blocked", cn.getPath(), xml, xmlCopy));
                context = new FailedContext();
            } else {
                context = (Context)Class.forName(this.contextClass).newInstance();
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.newInstance();
            context.addLifecycleListener(listener);
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            context.setDocBase(cn.getBaseName());
            this.host.addChild(context);
            deployedApp2 = new DeployedApplication(cn.getName(), xml.exists() && this.deployXML && copyThisXml);
        }
        catch (Throwable t) {
            try {
                ExceptionUtils.handleThrowable(t);
                log.error((Object)sm.getString("hostConfig.deployDir.error", dir.getAbsolutePath()), t);
                deployedApp2 = new DeployedApplication(cn.getName(), xml.exists() && this.deployXML && copyThisXml);
            }
            catch (Throwable throwable) {
                DeployedApplication deployedApp2 = new DeployedApplication(cn.getName(), xml.exists() && this.deployXML && copyThisXml);
                deployedApp2.redeployResources.put(dir.getAbsolutePath() + ".war", 0L);
                deployedApp2.redeployResources.put(dir.getAbsolutePath(), dir.lastModified());
                if (this.deployXML && xml.exists()) {
                    if (copyThisXml) {
                        deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), xmlCopy.lastModified());
                    } else {
                        deployedApp2.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
                        deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), 0L);
                    }
                } else {
                    deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), 0L);
                    if (!xml.exists()) {
                        deployedApp2.redeployResources.put(xml.getAbsolutePath(), 0L);
                    }
                }
                this.addWatchedResources(deployedApp2, dir.getAbsolutePath(), context);
                this.addGlobalRedeployResources(deployedApp2);
                throw throwable;
            }
            deployedApp2.redeployResources.put(dir.getAbsolutePath() + ".war", 0L);
            deployedApp2.redeployResources.put(dir.getAbsolutePath(), dir.lastModified());
            if (this.deployXML && xml.exists()) {
                if (copyThisXml) {
                    deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), xmlCopy.lastModified());
                } else {
                    deployedApp2.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
                    deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), 0L);
                }
            } else {
                deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), 0L);
                if (!xml.exists()) {
                    deployedApp2.redeployResources.put(xml.getAbsolutePath(), 0L);
                }
            }
            this.addWatchedResources(deployedApp2, dir.getAbsolutePath(), context);
            this.addGlobalRedeployResources(deployedApp2);
        }
        deployedApp2.redeployResources.put(dir.getAbsolutePath() + ".war", 0L);
        deployedApp2.redeployResources.put(dir.getAbsolutePath(), dir.lastModified());
        if (this.deployXML && xml.exists()) {
            if (copyThisXml) {
                deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), xmlCopy.lastModified());
            } else {
                deployedApp2.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
                deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), 0L);
            }
        } else {
            deployedApp2.redeployResources.put(xmlCopy.getAbsolutePath(), 0L);
            if (!xml.exists()) {
                deployedApp2.redeployResources.put(xml.getAbsolutePath(), 0L);
            }
        }
        this.addWatchedResources(deployedApp2, dir.getAbsolutePath(), context);
        this.addGlobalRedeployResources(deployedApp2);
        this.deployed.put(cn.getName(), deployedApp2);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.deployDir.finished", dir.getAbsolutePath(), System.currentTimeMillis() - startTime));
        }
    }

    protected boolean deploymentExists(String contextName) {
        return this.deployed.containsKey(contextName) || this.host.findChild(contextName) != null;
    }

    protected void addWatchedResources(DeployedApplication app, String docBase, Context context) {
        File docBaseFile = null;
        if (docBase != null && !(docBaseFile = new File(docBase)).isAbsolute()) {
            docBaseFile = new File(this.host.getAppBaseFile(), docBase);
        }
        String[] watchedResources = context.findWatchedResources();
        for (int i = 0; i < watchedResources.length; ++i) {
            File resource = new File(watchedResources[i]);
            if (!resource.isAbsolute()) {
                if (docBase != null) {
                    resource = new File(docBaseFile, watchedResources[i]);
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Ignoring non-existent WatchedResource '" + resource.getAbsolutePath() + "'"));
                    continue;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Watching WatchedResource '" + resource.getAbsolutePath() + "'"));
            }
            app.reloadResources.put(resource.getAbsolutePath(), resource.lastModified());
        }
    }

    protected void addGlobalRedeployResources(DeployedApplication app) {
        File globalContextXml;
        File hostContextXml = new File(this.getConfigBaseName(), "context.xml.default");
        if (hostContextXml.isFile()) {
            app.redeployResources.put(hostContextXml.getAbsolutePath(), hostContextXml.lastModified());
        }
        if ((globalContextXml = this.returnCanonicalPath("conf/context.xml")).isFile()) {
            app.redeployResources.put(globalContextXml.getAbsolutePath(), globalContextXml.lastModified());
        }
    }

    protected synchronized void checkResources(DeployedApplication app) {
        long lastModified;
        File resource;
        int i;
        String[] resources = app.redeployResources.keySet().toArray(new String[0]);
        for (i = 0; i < resources.length; ++i) {
            resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + app.name + "] redeploy resource " + resource));
            }
            lastModified = app.redeployResources.get(resources[i]);
            if (resource.exists() || lastModified == 0L) {
                if (resource.lastModified() <= lastModified) continue;
                if (resource.isDirectory()) {
                    app.redeployResources.put(resources[i], resource.lastModified());
                    continue;
                }
                if (app.hasDescriptor && resource.getName().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                    Context context = (Context)this.host.findChild(app.name);
                    String docBase = context.getDocBase();
                    if (!(docBase = docBase.toLowerCase(Locale.ENGLISH)).endsWith(".war")) {
                        File docBaseFile = new File(docBase);
                        if (!docBaseFile.isAbsolute()) {
                            docBaseFile = new File(this.host.getAppBaseFile(), docBase);
                        }
                        ExpandWar.delete(docBaseFile);
                        context.setDocBase(resource.getAbsolutePath());
                    }
                    this.reload(app);
                    app.redeployResources.put(resources[i], resource.lastModified());
                    app.timestamp = System.currentTimeMillis();
                    if (this.unpackWARs) {
                        this.addWatchedResources(app, context.getDocBase(), context);
                    } else {
                        this.addWatchedResources(app, null, context);
                    }
                    return;
                }
                this.undeploy(app);
                this.deleteRedeployResources(app, resources, i, false);
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            if (resource.exists() || lastModified == 0L) continue;
            this.undeploy(app);
            this.deleteRedeployResources(app, resources, i, true);
            return;
        }
        resources = app.reloadResources.keySet().toArray(new String[0]);
        for (i = 0; i < resources.length; ++i) {
            resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + app.name + "] reload resource " + resource));
            }
            lastModified = app.reloadResources.get(resources[i]);
            if ((resource.exists() || lastModified == 0L) && resource.lastModified() == lastModified) continue;
            this.reload(app);
            app.reloadResources.put(resources[i], resource.lastModified());
            app.timestamp = System.currentTimeMillis();
            return;
        }
    }

    private void reload(DeployedApplication app) {
        Context context;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.reload", app.name));
        }
        if ((context = (Context)this.host.findChild(app.name)).getState().isAvailable()) {
            context.reload();
        } else {
            try {
                context.start();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("hostConfig.context.restart", app.name), (Throwable)e);
            }
        }
    }

    private void undeploy(DeployedApplication app) {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.undeploy", app.name));
        }
        Container context = this.host.findChild(app.name);
        try {
            this.host.removeChild(context);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.warn((Object)sm.getString("hostConfig.context.remove", app.name), t);
        }
        this.deployed.remove(app.name);
    }

    private void deleteRedeployResources(DeployedApplication app, String[] resources, int i, boolean deleteReloadResources) {
        for (int j = i + 1; j < resources.length; ++j) {
            try {
                File current = new File(resources[j]);
                current = current.getCanonicalFile();
                if ("context.xml.default".equals(current.getName()) || !this.isDeletableResource(current)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete " + current));
                }
                ExpandWar.delete(current);
                continue;
            }
            catch (IOException e) {
                log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
            }
        }
        if (deleteReloadResources) {
            String[] resources2 = app.reloadResources.keySet().toArray(new String[0]);
            for (int j = 0; j < resources2.length; ++j) {
                try {
                    File current = new File(resources2[j]);
                    current = current.getCanonicalFile();
                    if ("context.xml.default".equals(current.getName()) || !this.isDeletableResource(current)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete " + current));
                    }
                    ExpandWar.delete(current);
                    continue;
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
                }
            }
        }
    }

    private boolean isDeletableResource(File resource) {
        return resource.getAbsolutePath().startsWith(this.host.getAppBaseFile().getAbsolutePath() + File.separator) || resource.getAbsolutePath().startsWith(this.host.getConfigBaseFile().getAbsolutePath()) && resource.getAbsolutePath().endsWith(".xml");
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.start"));
        }
        try {
            ObjectName hostON = this.host.getObjectName();
            this.oname = new ObjectName(hostON.getDomain() + ":type=Deployer,host=" + this.host.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, this.getClass().getName());
        }
        catch (Exception e) {
            log.error((Object)sm.getString("hostConfig.jmx.register", this.oname), (Throwable)e);
        }
        if (this.host.getCreateDirs()) {
            File[] dirs = new File[]{this.host.getAppBaseFile(), this.host.getConfigBaseFile()};
            for (int i = 0; i < dirs.length; ++i) {
                if (dirs[i].mkdirs() || dirs[i].isDirectory()) continue;
                log.error((Object)sm.getString("hostConfig.createDirs", dirs[i]));
            }
        }
        if (!this.host.getAppBaseFile().isDirectory()) {
            log.error((Object)sm.getString("hostConfig.appBase", this.host.getName(), this.host.getAppBaseFile().getPath()));
            this.host.setDeployOnStartup(false);
            this.host.setAutoDeploy(false);
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.stop"));
        }
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("hostConfig.jmx.unregister", this.oname), (Throwable)e);
            }
        }
        this.oname = null;
    }

    protected void check() {
        if (this.host.getAutoDeploy()) {
            DeployedApplication[] apps = this.deployed.values().toArray(new DeployedApplication[0]);
            for (int i = 0; i < apps.length; ++i) {
                if (this.isServiced(apps[i].name)) continue;
                this.checkResources(apps[i]);
            }
            if (this.host.getUndeployOldVersions()) {
                this.checkUndeploy();
            }
            this.deployApps();
        }
    }

    public void check(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app != null) {
            this.checkResources(app);
        }
        this.deployApps(name);
    }

    public synchronized void checkUndeploy() {
        TreeSet<String> sortedAppNames = new TreeSet<String>();
        sortedAppNames.addAll(this.deployed.keySet());
        if (sortedAppNames.size() < 2) {
            return;
        }
        Iterator iter = sortedAppNames.iterator();
        ContextName previous = new ContextName((String)iter.next(), false);
        do {
            ContextName current;
            if ((current = new ContextName((String)iter.next(), false)).getPath().equals(previous.getPath())) {
                int sessionCount;
                Manager manager;
                Context previousContext = (Context)this.host.findChild(previous.getName());
                Context currentContext = (Context)this.host.findChild(previous.getName());
                if (previousContext != null && currentContext != null && currentContext.getState().isAvailable() && !this.isServiced(previous.getName()) && (manager = previousContext.getManager()) != null && (sessionCount = manager instanceof DistributedManager ? ((DistributedManager)((Object)manager)).getActiveSessionsFull() : manager.getActiveSessions()) == 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)sm.getString("hostConfig.undeployVersion", previous.getName()));
                    }
                    DeployedApplication app = this.deployed.get(previous.getName());
                    String[] resources = app.redeployResources.keySet().toArray(new String[0]);
                    this.undeploy(app);
                    this.deleteRedeployResources(app, resources, -1, true);
                }
            }
            previous = current;
        } while (iter.hasNext());
    }

    public void manageApp(Context context) {
        File docBase;
        String contextName = context.getName();
        if (this.deployed.containsKey(contextName)) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(contextName, false);
        boolean isWar = false;
        if (context.getDocBase() != null) {
            docBase = new File(context.getDocBase());
            if (!docBase.isAbsolute()) {
                docBase = new File(this.host.getAppBaseFile(), context.getDocBase());
            }
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
            if (docBase.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                isWar = true;
            }
        }
        this.host.addChild(context);
        if (isWar && this.unpackWARs) {
            docBase = new File(this.host.getAppBaseFile(), context.getBaseName());
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
            this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
        } else {
            this.addWatchedResources(deployedApp, null, context);
        }
        this.deployed.put(contextName, deployedApp);
    }

    public void unmanageApp(String contextName) {
        if (this.isServiced(contextName)) {
            this.deployed.remove(contextName);
            this.host.removeChild(this.host.findChild(contextName));
        }
    }

    private static class DeployDirectory
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File dir;

        public DeployDirectory(HostConfig config, ContextName cn, File dir) {
            this.config = config;
            this.cn = cn;
            this.dir = dir;
        }

        @Override
        public void run() {
            this.config.deployDirectory(this.cn, this.dir);
        }
    }

    private static class DeployWar
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File war;

        public DeployWar(HostConfig config, ContextName cn, File war) {
            this.config = config;
            this.cn = cn;
            this.war = war;
        }

        @Override
        public void run() {
            this.config.deployWAR(this.cn, this.war);
        }
    }

    private static class DeployDescriptor
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File descriptor;

        public DeployDescriptor(HostConfig config, ContextName cn, File descriptor) {
            this.config = config;
            this.cn = cn;
            this.descriptor = descriptor;
        }

        @Override
        public void run() {
            this.config.deployDescriptor(this.cn, this.descriptor);
        }
    }

    protected static class DeployedApplication {
        public final String name;
        public final boolean hasDescriptor;
        public final LinkedHashMap<String, Long> redeployResources = new LinkedHashMap();
        public final HashMap<String, Long> reloadResources = new HashMap();
        public long timestamp = System.currentTimeMillis();
        public boolean loggedDirWarning = false;

        public DeployedApplication(String name, boolean hasDescriptor) {
            this.name = name;
            this.hasDescriptor = hasDescriptor;
        }
    }
}

