/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Constants;
import org.apache.tomcat.util.net.SendfileKeepAliveState;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class AprEndpoint
extends AbstractEndpoint<Long> {
    private static final Log log = LogFactory.getLog(AprEndpoint.class);
    protected static final Set<String> SSL_PROTO_ALL = new HashSet<String>();
    protected long rootPool = 0L;
    protected long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    protected ConcurrentLinkedQueue<SocketWrapper<Long>> waitingRequests = new ConcurrentLinkedQueue();
    private final Map<Long, AprSocketWrapper> connections = new ConcurrentHashMap<Long, AprSocketWrapper>();
    protected boolean deferAccept = true;
    protected int sendfileSize = 1024;
    protected Handler handler = null;
    protected int pollTime = 2000;
    protected boolean useSendfile = false;
    private boolean useSendFileSet = false;
    protected boolean useComet = true;
    protected int sendfileThreadCount = 0;
    protected Poller poller = null;
    protected AsyncTimeout asyncTimeout = null;
    protected Sendfile sendfile = null;
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!kRSA";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateKeyFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;
    protected boolean SSLInsecureRenegotiation = false;
    protected boolean SSLHonorCipherOrder = false;
    protected boolean SSLDisableCompression = false;

    @Override
    public void removeWaitingRequest(SocketWrapper<Long> socketWrapper) {
        this.waitingRequests.remove(socketWrapper);
    }

    public AprEndpoint() {
        this.setMaxConnections(8192);
    }

    public void setDeferAccept(boolean deferAccept) {
        this.deferAccept = deferAccept;
    }

    @Override
    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int pollTime) {
        if (pollTime > 0) {
            this.pollTime = pollTime;
        }
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendFileSet = true;
        this.useSendfile = useSendfile;
    }

    @Override
    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseComet(boolean useComet) {
        this.useComet = useComet;
    }

    @Override
    public boolean getUseComet() {
        return this.useComet;
    }

    @Override
    public boolean getUseCometTimeout() {
        return false;
    }

    @Override
    public boolean getUsePolling() {
        return true;
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        this.sendfileThreadCount = sendfileThreadCount;
    }

    public int getSendfileThreadCount() {
        return this.sendfileThreadCount;
    }

    public Poller getPoller() {
        return this.poller;
    }

    public AsyncTimeout getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public Sendfile getSendfile() {
        return this.sendfile;
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.SSLProtocol = SSLProtocol;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String SSLPassword) {
        this.SSLPassword = SSLPassword;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.SSLCipherSuite = SSLCipherSuite;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.SSLCertificateFile = SSLCertificateFile;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.SSLCertificateKeyFile = SSLCertificateKeyFile;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.SSLCertificateChainFile = SSLCertificateChainFile;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.SSLCACertificatePath = SSLCACertificatePath;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.SSLCACertificateFile = SSLCACertificateFile;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.SSLCARevocationPath = SSLCARevocationPath;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.SSLCARevocationFile = SSLCARevocationFile;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.SSLVerifyClient = SSLVerifyClient;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.SSLVerifyDepth = SSLVerifyDepth;
    }

    public void setSSLInsecureRenegotiation(boolean SSLInsecureRenegotiation) {
        this.SSLInsecureRenegotiation = SSLInsecureRenegotiation;
    }

    public boolean getSSLInsecureRenegotiation() {
        return this.SSLInsecureRenegotiation;
    }

    public void setSSLHonorCipherOrder(boolean SSLHonorCipherOrder) {
        this.SSLHonorCipherOrder = SSLHonorCipherOrder;
    }

    public boolean getSSLHonorCipherOrder() {
        return this.SSLHonorCipherOrder;
    }

    public void setSSLDisableCompression(boolean SSLDisableCompression) {
        this.SSLDisableCompression = SSLDisableCompression;
    }

    public boolean getSSLDisableCompression() {
        return this.SSLDisableCompression;
    }

    @Override
    public int getLocalPort() {
        long s = this.serverSock;
        if (s == 0L) {
            return -1;
        }
        try {
            long sa = Address.get(0, s);
            Sockaddr addr = Address.getInfo(sa);
            return addr.port;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        if (maxConnections == -1) {
            log.warn((Object)sm.getString("endpoint.apr.maxConnections.unlimited", this.getMaxConnections()));
            return;
        }
        if (this.running) {
            log.warn((Object)sm.getString("endpoint.apr.maxConnections.running", this.getMaxConnections()));
            return;
        }
        super.setMaxConnections(maxConnections);
    }

    public int getKeepAliveCount() {
        if (this.poller == null) {
            return 0;
        }
        return this.poller.getConnectionCount();
    }

    public int getSendfileCount() {
        if (this.sendfile == null) {
            return 0;
        }
        return this.sendfile.getSendfileCount();
    }

    @Override
    public void bind() throws Exception {
        try {
            this.rootPool = Pool.create(0L);
        }
        catch (UnsatisfiedLinkError e) {
            throw new Exception(sm.getString("endpoint.init.notavail"));
        }
        this.serverSockPool = Pool.create(this.rootPool);
        String addressStr = null;
        if (this.getAddress() != null) {
            addressStr = this.getAddress().getHostAddress();
        }
        int family = 1;
        if (Library.APR_HAVE_IPV6) {
            if (addressStr == null) {
                if (!(OS.IS_BSD || OS.IS_WIN32 || OS.IS_WIN64)) {
                    family = 0;
                }
            } else if (addressStr.indexOf(58) >= 0) {
                family = 0;
            }
        }
        long inetAddress = Address.info(addressStr, family, this.getPort(), 0, this.rootPool);
        this.serverSock = Socket.create(Address.getInfo((long)inetAddress).family, 0, 6, this.rootPool);
        if (OS.IS_UNIX) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        Socket.optSet(this.serverSock, 2, 1);
        int ret = Socket.bind(this.serverSock, inetAddress);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", "" + ret, Error.strerror(ret)));
        }
        ret = Socket.listen(this.serverSock, this.getBacklog());
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", "" + ret, Error.strerror(ret)));
        }
        if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        if (!this.useSendFileSet) {
            this.useSendfile = Library.APR_HAS_SENDFILE;
        } else if (this.useSendfile && !Library.APR_HAS_SENDFILE) {
            this.useSendfile = false;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.deferAccept && Socket.optSet(this.serverSock, 32768, 1) == 70023) {
            this.deferAccept = false;
        }
        if (this.isSSLEnabled()) {
            if (this.SSLCertificateFile == null) {
                throw new Exception(sm.getString("endpoint.apr.noSslCertFile"));
            }
            int value = 0;
            if (this.SSLProtocol == null || this.SSLProtocol.length() == 0) {
                value = 28;
            } else {
                HashSet<String> protocols = new HashSet<String>();
                for (String protocol : this.SSLProtocol.split("(?=[-+])")) {
                    String trimmed = protocol.trim();
                    if (trimmed.length() <= 1) continue;
                    if (trimmed.charAt(0) == '-') {
                        if ((trimmed = trimmed.substring(1).trim()).equalsIgnoreCase("all")) {
                            protocols.removeAll(SSL_PROTO_ALL);
                            continue;
                        }
                        protocols.remove(trimmed);
                        continue;
                    }
                    if (trimmed.charAt(0) == '+') {
                        trimmed = trimmed.substring(1).trim();
                    }
                    if (trimmed.equalsIgnoreCase("all")) {
                        protocols.addAll(SSL_PROTO_ALL);
                        continue;
                    }
                    protocols.add(trimmed);
                }
                for (String protocol : protocols) {
                    if ("SSLv2".equalsIgnoreCase(protocol)) {
                        value |= 1;
                        continue;
                    }
                    if ("SSLv3".equalsIgnoreCase(protocol)) {
                        value |= 2;
                        continue;
                    }
                    if ("TLSv1".equalsIgnoreCase(protocol)) {
                        value |= 4;
                        continue;
                    }
                    if ("TLSv1.1".equalsIgnoreCase(protocol)) {
                        value |= 8;
                        continue;
                    }
                    if ("TLSv1.2".equalsIgnoreCase(protocol)) {
                        value |= 0x10;
                        continue;
                    }
                    throw new Exception(sm.getString("endpoint.apr.invalidSslProtocol", this.SSLProtocol));
                }
            }
            try {
                this.sslContext = SSLContext.make(this.rootPool, value, 1);
            }
            catch (Exception e) {
                throw new Exception(sm.getString("endpoint.apr.failSslContextMake"), e);
            }
            if (this.SSLInsecureRenegotiation) {
                boolean legacyRenegSupported = false;
                try {
                    legacyRenegSupported = SSL.hasOp(262144);
                    if (legacyRenegSupported) {
                        SSLContext.setOptions(this.sslContext, 262144);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
                if (!legacyRenegSupported) {
                    log.warn((Object)sm.getString("endpoint.warn.noInsecureReneg", SSL.versionString()));
                }
            }
            if (this.SSLHonorCipherOrder) {
                boolean orderCiphersSupported = false;
                try {
                    orderCiphersSupported = SSL.hasOp(0x400000);
                    if (orderCiphersSupported) {
                        SSLContext.setOptions(this.sslContext, 0x400000);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
                if (!orderCiphersSupported) {
                    log.warn((Object)sm.getString("endpoint.warn.noHonorCipherOrder", SSL.versionString()));
                }
            }
            if (this.SSLDisableCompression) {
                boolean disableCompressionSupported = false;
                try {
                    disableCompressionSupported = SSL.hasOp(131072);
                    if (disableCompressionSupported) {
                        SSLContext.setOptions(this.sslContext, 131072);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
                if (!disableCompressionSupported) {
                    log.warn((Object)sm.getString("endpoint.warn.noDisableCompression", SSL.versionString()));
                }
            }
            SSLContext.setCipherSuite(this.sslContext, this.SSLCipherSuite);
            SSLContext.setCertificate(this.sslContext, this.SSLCertificateFile, this.SSLCertificateKeyFile, this.SSLPassword, 0);
            SSLContext.setCertificateChainFile(this.sslContext, this.SSLCertificateChainFile, false);
            SSLContext.setCACertificate(this.sslContext, this.SSLCACertificateFile, this.SSLCACertificatePath);
            SSLContext.setCARevocation(this.sslContext, this.SSLCARevocationFile, this.SSLCARevocationPath);
            value = 0;
            if ("optional".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 1;
            } else if ("require".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 2;
            } else if ("optionalNoCA".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 3;
            }
            SSLContext.setVerify(this.sslContext, value, this.SSLVerifyDepth);
            if (this.useSendfile) {
                this.useSendfile = false;
                if (this.useSendFileSet) {
                    log.warn((Object)sm.getString("endpoint.apr.noSendfileWithSSL"));
                }
            }
        }
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.poller = new Poller();
            this.poller.init();
            Thread pollerThread = new Thread((Runnable)this.poller, this.getName() + "-Poller");
            pollerThread.setPriority(this.threadPriority);
            pollerThread.setDaemon(true);
            pollerThread.start();
            if (this.useSendfile) {
                this.sendfile = new Sendfile();
                this.sendfile.init();
                Thread sendfileThread = new Thread((Runnable)this.sendfile, this.getName() + "-Sendfile");
                sendfileThread.setPriority(this.threadPriority);
                sendfileThread.setDaemon(true);
                sendfileThread.start();
            }
            this.startAcceptorThreads();
            this.asyncTimeout = new AsyncTimeout();
            Thread timeoutThread = new Thread((Runnable)this.asyncTimeout, this.getName() + "-AsyncTimeout");
            timeoutThread.setPriority(this.threadPriority);
            timeoutThread.setDaemon(true);
            timeoutThread.start();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.poller.stop();
            this.asyncTimeout.stop();
            this.unlockAccept();
            for (AbstractEndpoint.Acceptor acceptor : this.acceptors) {
                long waitLeft;
                for (waitLeft = 10000L; waitLeft > 0L && acceptor.getState() != AbstractEndpoint.Acceptor.AcceptorState.ENDED && this.serverSock != 0L; waitLeft -= 50L) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (waitLeft != 0L) continue;
                log.warn((Object)sm.getString("endpoint.warn.unlockAcceptorFailed", acceptor.getThreadName()));
                if (this.serverSock == 0L) continue;
                Socket.shutdown(this.serverSock, 0);
                this.serverSock = 0L;
            }
            try {
                this.poller.destroy();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.poller = null;
            this.connections.clear();
            if (this.useSendfile) {
                try {
                    this.sendfile.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sendfile = null;
            }
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSockPool != 0L) {
            Pool.destroy(this.serverSockPool);
            this.serverSockPool = 0L;
        }
        if (this.serverSock != 0L) {
            Socket.close(this.serverSock);
            this.serverSock = 0L;
        }
        this.sslContext = 0L;
        if (this.rootPool != 0L) {
            Pool.destroy(this.rootPool);
            this.rootPool = 0L;
        }
        this.handler.recycle();
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(long socket) {
        int step = 1;
        try {
            if (this.socketProperties.getSoLingerOn() && this.socketProperties.getSoLingerTime() >= 0) {
                Socket.optSet(socket, 1, this.socketProperties.getSoLingerTime());
            }
            if (this.socketProperties.getTcpNoDelay()) {
                Socket.optSet(socket, 512, this.socketProperties.getTcpNoDelay() ? 1 : 0);
            }
            Socket.timeoutSet(socket, this.socketProperties.getSoTimeout() * 1000);
            step = 2;
            if (this.sslContext != 0L) {
                SSLSocket.attach(this.sslContext, socket);
                if (SSLSocket.handshake(socket) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError()));
                    }
                    return false;
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            if (log.isDebugEnabled()) {
                if (step == 2) {
                    log.debug((Object)sm.getString("endpoint.err.handshake"), t);
                } else {
                    log.debug((Object)sm.getString("endpoint.err.unexpected"), t);
                }
            }
            return false;
        }
        return true;
    }

    protected long allocatePoller(int size, long pool, int timeout) {
        try {
            return Poll.create(size, pool, 0, timeout * 1000);
        }
        catch (Error e) {
            if (Status.APR_STATUS_IS_EINVAL(e.getError())) {
                log.info((Object)sm.getString("endpoint.poll.limitedpollsize", "" + size));
                return 0L;
            }
            log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
            return -1L;
        }
    }

    protected boolean processSocketWithOptions(long socket) {
        try {
            if (this.running) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.socket", socket));
                }
                AprSocketWrapper wrapper = new AprSocketWrapper(socket);
                wrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
                wrapper.setSecure(this.isSSLEnabled());
                this.connections.put(socket, wrapper);
                this.getExecutor().execute(new SocketWithOptionsProcessor(wrapper));
            }
        }
        catch (RejectedExecutionException x) {
            log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)x);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    public boolean processSocket(long socket, SocketStatus status) {
        try {
            Executor executor = this.getExecutor();
            if (executor == null) {
                log.warn((Object)sm.getString("endpoint.warn.noExector", socket, null));
            } else {
                SocketWrapper wrapper = this.connections.get(socket);
                if (wrapper != null) {
                    executor.execute(new SocketProcessor(wrapper, status));
                }
            }
        }
        catch (RejectedExecutionException x) {
            log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)x);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSocketAsync(SocketWrapper<Long> socket, SocketStatus status) {
        try {
            SocketWrapper<Long> socketWrapper = socket;
            synchronized (socketWrapper) {
                if (this.waitingRequests.remove(socket)) {
                    SocketProcessor proc = new SocketProcessor(socket, status);
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    try {
                        if (Constants.IS_SECURITY_ENABLED) {
                            PrivilegedSetTccl pa = new PrivilegedSetTccl(this.getClass().getClassLoader());
                            AccessController.doPrivileged(pa);
                        } else {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        }
                        Executor executor = this.getExecutor();
                        if (executor == null) {
                            log.warn((Object)sm.getString("endpoint.warn.noExector", new Object[]{socket, status}));
                            return;
                        }
                        executor.execute(proc);
                    }
                    finally {
                        if (Constants.IS_SECURITY_ENABLED) {
                            PrivilegedSetTccl pa = new PrivilegedSetTccl(loader);
                            AccessController.doPrivileged(pa);
                        } else {
                            Thread.currentThread().setContextClassLoader(loader);
                        }
                    }
                }
            }
        }
        catch (RejectedExecutionException x) {
            log.warn((Object)("Socket processing request was rejected for: " + socket), (Throwable)x);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
        }
    }

    private void closeSocket(long socket) {
        this.connections.remove(socket);
        Poller poller = this.poller;
        if (poller != null && !poller.close(socket)) {
            this.destroySocket(socket);
        }
    }

    private void destroySocket(long socket) {
        this.connections.remove(socket);
        if (log.isDebugEnabled()) {
            String msg = sm.getString("endpoint.debug.destroySocket", socket);
            if (log.isTraceEnabled()) {
                log.trace((Object)msg, (Throwable)new Exception());
            } else {
                log.debug((Object)msg);
            }
        }
        if (socket != 0L) {
            Socket.destroy(socket);
            this.countDownConnection();
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    static {
        SSL_PROTO_ALL.add("TLSv1");
        SSL_PROTO_ALL.add("TLSv1.1");
        SSL_PROTO_ALL.add("TLSv1.2");
    }

    private static class AprSocketWrapper
    extends SocketWrapper<Long> {
        private int pollerFlags = 0;

        public AprSocketWrapper(Long socket) {
            super(socket);
        }
    }

    protected class SocketProcessor
    implements Runnable {
        private final SocketWrapper<Long> socket;
        private final SocketStatus status;

        public SocketProcessor(SocketWrapper<Long> socket, SocketStatus status) {
            this.socket = socket;
            if (status == null) {
                throw new NullPointerException();
            }
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.socket.isUpgraded() && SocketStatus.OPEN_WRITE == this.status) {
                Object object = this.socket.getWriteThreadLock();
                synchronized (object) {
                    this.doRun();
                }
            }
            SocketWrapper<Long> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                this.doRun();
            }
        }

        private void doRun() {
            if (this.socket.getSocket() == null) {
                return;
            }
            AbstractEndpoint.Handler.SocketState state = AprEndpoint.this.handler.process(this.socket, this.status);
            if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                AprEndpoint.this.closeSocket(this.socket.getSocket());
                this.socket.socket = null;
            } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                this.socket.access();
                if (this.socket.async) {
                    AprEndpoint.this.waitingRequests.add(this.socket);
                }
            } else if (state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                this.socket.access();
                SocketProcessor proc = new SocketProcessor(this.socket, SocketStatus.OPEN_READ);
                AprEndpoint.this.getExecutor().execute(proc);
            }
        }
    }

    protected class SocketWithOptionsProcessor
    implements Runnable {
        protected SocketWrapper<Long> socket = null;

        public SocketWithOptionsProcessor(SocketWrapper<Long> socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketWrapper<Long> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                if (!AprEndpoint.this.deferAccept) {
                    if (AprEndpoint.this.setSocketOptions(this.socket.getSocket())) {
                        AprEndpoint.this.getPoller().add(this.socket.getSocket(), AprEndpoint.this.getSoTimeout(), true, false);
                    } else {
                        AprEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                    }
                } else {
                    if (!AprEndpoint.this.setSocketOptions(this.socket.getSocket())) {
                        AprEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                        return;
                    }
                    AbstractEndpoint.Handler.SocketState state = AprEndpoint.this.handler.process(this.socket, SocketStatus.OPEN_READ);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        AprEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                    } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.socket.access();
                        if (this.socket.async) {
                            AprEndpoint.this.waitingRequests.add(this.socket);
                        }
                    }
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> var1, SocketStatus var2);
    }

    public class Sendfile
    implements Runnable {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap<Long, SendfileData> sendfileData;
        protected int sendfileCount;
        protected ArrayList<SendfileData> addS;
        private volatile boolean sendfileRunning = true;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.sendfileSize;
            if (size <= 0) {
                size = OS.IS_WIN32 || OS.IS_WIN64 ? 1024 : 16384;
            }
            this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.getSoTimeout());
            if (this.sendfilePollset == 0L && size > 1024) {
                size = 1024;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.getSoTimeout());
            }
            if (this.sendfilePollset == 0L) {
                size = 62;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.getSoTimeout());
            }
            this.desc = new long[size * 2];
            this.sendfileData = new HashMap(size);
            this.addS = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            this.sendfileRunning = false;
            try {
                Sendfile sendfile = this;
                synchronized (sendfile) {
                    this.notify();
                    this.wait(AprEndpoint.this.pollTime / 1000);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (int i = this.addS.size() - 1; i >= 0; --i) {
                SendfileData data = this.addS.get(i);
                AprEndpoint.this.closeSocket(data.socket);
            }
            int rv = Poll.pollset(this.sendfilePollset, this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.sendfileData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SendfileState add(SendfileData data) {
            block8: {
                try {
                    data.fdpool = Socket.pool(data.socket);
                    data.fd = File.open(data.fileName, 4129, 0, data.fdpool);
                    data.pos = data.start;
                    Socket.timeoutSet(data.socket, 0L);
                    do {
                        long nw;
                        if ((nw = Socket.sendfilen(data.socket, data.fd, data.pos, data.end - data.pos, 0)) < 0L) {
                            if (-nw != 120002L) {
                                Pool.destroy(data.fdpool);
                                data.socket = 0L;
                                return SendfileState.ERROR;
                            }
                            break block8;
                        }
                        data.pos += nw;
                    } while (data.pos < data.end);
                    Pool.destroy(data.fdpool);
                    Socket.timeoutSet(data.socket, AprEndpoint.this.getSoTimeout() * 1000);
                    return SendfileState.DONE;
                }
                catch (Exception e) {
                    log.warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.error"), (Throwable)e);
                    return SendfileState.ERROR;
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(data);
                this.notify();
            }
            return SendfileState.PENDING;
        }

        protected void remove(SendfileData data) {
            int rv = Poll.remove(this.sendfilePollset, data.socket);
            if (rv == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(data.socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long maintainTime = 0L;
            while (this.sendfileRunning) {
                Sendfile e3;
                while (this.sendfileRunning && AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                while (this.sendfileRunning && this.sendfileCount < 1 && this.addS.size() < 1) {
                    maintainTime = 0L;
                    try {
                        e3 = this;
                        synchronized (e3) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e3) {
                    }
                }
                if (!this.sendfileRunning) break;
                try {
                    int errn;
                    Object state;
                    int n;
                    if (this.addS.size() > 0) {
                        e3 = this;
                        synchronized (e3) {
                            for (int i = this.addS.size() - 1; i >= 0; --i) {
                                SendfileData data = this.addS.get(i);
                                int rv = Poll.add(this.sendfilePollset, data.socket, 4);
                                if (rv == 0) {
                                    this.sendfileData.put(data.socket, data);
                                    ++this.sendfileCount;
                                    continue;
                                }
                                AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.addfail", rv, Error.strerror(rv)));
                                AprEndpoint.this.closeSocket(data.socket);
                            }
                            this.addS.clear();
                        }
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    int rv = Poll.poll(this.sendfilePollset, AprEndpoint.this.pollTime, this.desc, false);
                    if (rv > 0) {
                        block27: for (n = 0; n < rv; ++n) {
                            state = this.sendfileData.get(this.desc[n * 2 + 1]);
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove((SendfileData)state);
                                AprEndpoint.this.closeSocket(((SendfileData)state).socket);
                                continue;
                            }
                            long nw = Socket.sendfilen(((SendfileData)state).socket, ((SendfileData)state).fd, ((SendfileData)state).pos, ((SendfileData)state).end - ((SendfileData)state).pos, 0);
                            if (nw < 0L) {
                                this.remove((SendfileData)state);
                                AprEndpoint.this.closeSocket(((SendfileData)state).socket);
                                continue;
                            }
                            ((SendfileData)state).pos += nw;
                            if (((SendfileData)state).pos < ((SendfileData)state).end) continue;
                            this.remove((SendfileData)state);
                            switch (((SendfileData)state).keepAliveState) {
                                case NONE: {
                                    AprEndpoint.this.closeSocket(((SendfileData)state).socket);
                                    continue block27;
                                }
                                case PIPELINED: {
                                    Pool.destroy(((SendfileData)state).fdpool);
                                    Socket.timeoutSet(((SendfileData)state).socket, AprEndpoint.this.getSoTimeout() * 1000);
                                    if (AprEndpoint.this.processSocket(((SendfileData)state).socket, SocketStatus.OPEN_READ)) continue block27;
                                    AprEndpoint.this.closeSocket(((SendfileData)state).socket);
                                    continue block27;
                                }
                                case OPEN: {
                                    Pool.destroy(((SendfileData)state).fdpool);
                                    Socket.timeoutSet(((SendfileData)state).socket, AprEndpoint.this.getSoTimeout() * 1000);
                                    AprEndpoint.this.getPoller().add(((SendfileData)state).socket, AprEndpoint.this.getKeepAliveTimeout(), true, false);
                                }
                            }
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollError", errn, Error.strerror(errn)));
                        state = this;
                        synchronized (state) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.getSoTimeout() <= 0 || maintainTime <= 1000000L || !this.sendfileRunning) continue;
                    rv = Poll.maintain(this.sendfilePollset, this.desc, false);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    for (n = 0; n < rv; ++n) {
                        state = this.sendfileData.get(this.desc[n]);
                        this.remove((SendfileData)state);
                        AprEndpoint.this.closeSocket(((SendfileData)state).socket);
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), t);
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.notifyAll();
            }
        }
    }

    public static class SendfileData {
        public String fileName;
        public long fd;
        public long fdpool;
        public long start;
        public long end;
        public long socket;
        public long pos;
        public SendfileKeepAliveState keepAliveState = SendfileKeepAliveState.NONE;
    }

    public class Poller
    implements Runnable {
        protected long[] pollers = null;
        protected int actualPollerSize = 0;
        protected int[] pollerSpace = null;
        protected int pollerCount;
        protected int pollerTime;
        private int nextPollerTime;
        protected long pool = 0L;
        protected long[] desc;
        protected SocketList addList = null;
        private SocketList closeList = null;
        protected SocketTimeouts timeouts = null;
        protected long lastMaintain = System.currentTimeMillis();
        private AtomicInteger connectionCount = new AtomicInteger(0);
        private volatile boolean pollerRunning = true;

        public int getConnectionCount() {
            return this.connectionCount.get();
        }

        protected void init() {
            int i;
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int defaultPollerSize = AprEndpoint.this.getMaxConnections();
            this.actualPollerSize = (OS.IS_WIN32 || OS.IS_WIN64) && defaultPollerSize > 1024 ? 1024 : defaultPollerSize;
            this.timeouts = new SocketTimeouts(defaultPollerSize);
            long pollset = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
            if (pollset == 0L && this.actualPollerSize > 1024) {
                this.actualPollerSize = 1024;
                pollset = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
            }
            if (pollset == 0L) {
                this.actualPollerSize = 62;
                pollset = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
            }
            this.pollerCount = defaultPollerSize / this.actualPollerSize;
            this.nextPollerTime = this.pollerTime = AprEndpoint.this.pollTime / this.pollerCount;
            this.pollers = new long[this.pollerCount];
            this.pollers[0] = pollset;
            for (i = 1; i < this.pollerCount; ++i) {
                this.pollers[i] = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
            }
            this.pollerSpace = new int[this.pollerCount];
            for (i = 0; i < this.pollerCount; ++i) {
                this.pollerSpace[i] = this.actualPollerSize;
            }
            this.desc = new long[this.actualPollerSize * 2];
            this.connectionCount.set(0);
            this.addList = new SocketList(defaultPollerSize);
            this.closeList = new SocketList(defaultPollerSize);
        }

        protected synchronized void stop() {
            this.pollerRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            try {
                Poller poller = this;
                synchronized (poller) {
                    this.notify();
                    this.wait(AprEndpoint.this.pollTime / 1000);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            SocketInfo info = this.addList.get();
            while (info != null) {
                boolean comet = ((AprSocketWrapper)AprEndpoint.this.connections.get(info.socket)).isComet();
                if (!comet || !AprEndpoint.this.processSocket(info.socket, SocketStatus.STOP)) {
                    AprEndpoint.this.destroySocket(info.socket);
                }
                info = this.addList.get();
            }
            this.addList.clear();
            for (int i = 0; i < this.pollerCount; ++i) {
                int rv = Poll.pollset(this.pollers[i], this.desc);
                if (rv <= 0) continue;
                for (int n = 0; n < rv; ++n) {
                    boolean comet = ((AprSocketWrapper)AprEndpoint.this.connections.get(this.desc[n * 2 + 1])).isComet();
                    if (comet && AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.STOP)) continue;
                    AprEndpoint.this.destroySocket(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.connectionCount.set(0);
        }

        public void add(long socket, int timeout, boolean read, boolean write) {
            this.add(socket, timeout, (read ? 1 : 0) | (write ? 4 : 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(long socket, int timeout, int flags) {
            boolean comet;
            if (log.isDebugEnabled()) {
                String msg = AbstractEndpoint.sm.getString("endpoint.debug.pollerAdd", socket, timeout, flags);
                if (log.isTraceEnabled()) {
                    log.trace((Object)msg, (Throwable)new Exception());
                } else {
                    log.debug((Object)msg);
                }
            }
            if (timeout <= 0) {
                timeout = Integer.MAX_VALUE;
            }
            boolean ok = false;
            Poller poller = this;
            synchronized (poller) {
                if (this.pollerRunning && this.addList.add(socket, timeout, flags)) {
                    ok = true;
                    this.notify();
                }
            }
            if (!(ok || (comet = ((AprSocketWrapper)AprEndpoint.this.connections.get(socket)).isComet()) && AprEndpoint.this.processSocket(socket, SocketStatus.ERROR))) {
                AprEndpoint.this.closeSocket(socket);
            }
        }

        protected boolean addToPoller(long socket, int events) {
            int rv = -1;
            for (int i = 0; i < this.pollers.length; ++i) {
                if (this.pollerSpace[i] <= 0 || (rv = Poll.add(this.pollers[i], socket, events)) != 0) continue;
                int n = i;
                this.pollerSpace[n] = this.pollerSpace[n] - 1;
                this.connectionCount.incrementAndGet();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean close(long socket) {
            if (!this.pollerRunning) {
                return false;
            }
            Poller poller = this;
            synchronized (poller) {
                if (!this.pollerRunning) {
                    return false;
                }
                this.closeList.add(socket, 0, 0);
                this.notify();
                return true;
            }
        }

        private boolean removeFromPoller(long socket) {
            if (log.isDebugEnabled()) {
                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerRemove", socket));
            }
            int rv = -1;
            for (int i = 0; i < this.pollers.length; ++i) {
                if (this.pollerSpace[i] >= this.actualPollerSize || (rv = Poll.remove(this.pollers[i], socket)) == 70015) continue;
                int n = i;
                this.pollerSpace[n] = this.pollerSpace[n] + 1;
                this.connectionCount.decrementAndGet();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerRemoved", socket));
                break;
            }
            this.timeouts.remove(socket);
            return rv == 0;
        }

        protected void maintain() {
            long date = System.currentTimeMillis();
            if (date - this.lastMaintain < 5000L) {
                return;
            }
            this.lastMaintain = date;
            long socket = this.timeouts.check(date);
            while (socket != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.socketTimeout", socket));
                }
                this.removeFromPoller(socket);
                boolean comet = ((AprSocketWrapper)AprEndpoint.this.connections.get(socket)).isComet();
                if (!comet || !AprEndpoint.this.processSocket(socket, SocketStatus.TIMEOUT)) {
                    AprEndpoint.this.destroySocket(socket);
                }
                socket = this.timeouts.check(date);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Poller");
            long[] res = new long[this.actualPollerSize * 2];
            for (int i = 0; i < this.pollers.length; ++i) {
                int count = Poll.pollset(this.pollers[i], res);
                buf.append(" [ ");
                for (int j = 0; j < count; ++j) {
                    buf.append(this.desc[2 * j + 1]).append(" ");
                }
                buf.append("]");
            }
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketList localAddList = new SocketList(AprEndpoint.this.getMaxConnections());
            SocketList localCloseList = new SocketList(AprEndpoint.this.getMaxConnections());
            while (this.pollerRunning) {
                while (this.pollerRunning && AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                while (this.pollerRunning && this.connectionCount.get() < 1 && this.addList.size() < 1 && this.closeList.size() < 1) {
                    try {
                        if (AprEndpoint.this.getSoTimeout() > 0 && this.pollerRunning) {
                            this.maintain();
                        }
                        Poller e = this;
                        synchronized (e) {
                            if (this.addList.size() < 1 && this.closeList.size() < 1) {
                                this.wait(10000L);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.timeout.err"));
                    }
                }
                if (!this.pollerRunning) break;
                try {
                    SocketInfo info;
                    Poller t = this;
                    synchronized (t) {
                        if (this.closeList.size() > 0) {
                            this.closeList.duplicate(localCloseList);
                            this.closeList.clear();
                        } else {
                            localCloseList.clear();
                        }
                    }
                    t = this;
                    synchronized (t) {
                        if (this.addList.size() > 0) {
                            this.addList.duplicate(localAddList);
                            this.addList.clear();
                        } else {
                            localAddList.clear();
                        }
                    }
                    if (localCloseList.size() > 0) {
                        info = localCloseList.get();
                        while (info != null) {
                            localAddList.remove(info.socket);
                            this.removeFromPoller(info.socket);
                            AprEndpoint.this.destroySocket(info.socket);
                            info = localCloseList.get();
                        }
                    }
                    if (localAddList.size() > 0) {
                        info = localAddList.get();
                        while (info != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerAddDo", info.socket));
                            }
                            this.timeouts.remove(info.socket);
                            AprSocketWrapper wrapper = (AprSocketWrapper)AprEndpoint.this.connections.get(info.socket);
                            if (wrapper == null) continue;
                            if (info.read() || info.write()) {
                                boolean comet = wrapper.isComet();
                                if (comet || wrapper.pollerFlags != 0) {
                                    this.removeFromPoller(info.socket);
                                }
                                wrapper.pollerFlags = wrapper.pollerFlags | (info.read() ? 1 : 0) | (info.write() ? 4 : 0);
                                if (!this.addToPoller(info.socket, wrapper.pollerFlags)) {
                                    if (!comet || !AprEndpoint.this.processSocket(info.socket, SocketStatus.ERROR)) {
                                        AprEndpoint.this.closeSocket(info.socket);
                                    }
                                } else {
                                    this.timeouts.add(info.socket, System.currentTimeMillis() + (long)info.timeout);
                                }
                            } else {
                                AprEndpoint.this.closeSocket(info.socket);
                                AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollAddInvalid", info));
                            }
                            info = localAddList.get();
                        }
                    }
                    for (int i = 0; i < this.pollers.length; ++i) {
                        int errn;
                        boolean reset = false;
                        int rv = 0;
                        if (this.pollerSpace[i] < this.actualPollerSize) {
                            rv = Poll.poll(this.pollers[i], this.nextPollerTime, this.desc, true);
                            this.nextPollerTime = this.pollerTime;
                        } else {
                            this.nextPollerTime += this.pollerTime;
                        }
                        if (rv > 0) {
                            int n = i;
                            this.pollerSpace[n] = this.pollerSpace[n] + rv;
                            this.connectionCount.addAndGet(-rv);
                            for (int n2 = 0; n2 < rv; ++n2) {
                                long timeout = this.timeouts.remove(this.desc[n2 * 2 + 1]);
                                AprSocketWrapper wrapper = (AprSocketWrapper)AprEndpoint.this.connections.get(this.desc[n2 * 2 + 1]);
                                if (AprEndpoint.this.getLog().isDebugEnabled()) {
                                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerProcess", this.desc[n2 * 2 + 1], this.desc[n2 * 2]));
                                }
                                wrapper.pollerFlags = wrapper.pollerFlags & ~((int)this.desc[n2 * 2]);
                                if (wrapper.isComet()) {
                                    if ((this.desc[n2 * 2] & 0x20L) == 32L || (this.desc[n2 * 2] & 0x10L) == 16L || (this.desc[n2 * 2] & 0x40L) == 64L) {
                                        if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.ERROR)) continue;
                                        AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                        continue;
                                    }
                                    if ((this.desc[n2 * 2] & 1L) == 1L) {
                                        if (wrapper.pollerFlags != 0) {
                                            this.add(this.desc[n2 * 2 + 1], 1, wrapper.pollerFlags);
                                        }
                                        if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_READ)) continue;
                                        AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                        continue;
                                    }
                                    if ((this.desc[n2 * 2] & 4L) == 4L) {
                                        if (wrapper.pollerFlags != 0) {
                                            this.add(this.desc[n2 * 2 + 1], 1, wrapper.pollerFlags);
                                        }
                                        if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_WRITE)) continue;
                                        AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                        continue;
                                    }
                                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollUnknownEvent", this.desc[n2 * 2]));
                                    if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.ERROR)) continue;
                                    AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                if ((this.desc[n2 * 2] & 0x20L) == 32L || (this.desc[n2 * 2] & 0x10L) == 16L || (this.desc[n2 * 2] & 0x40L) == 64L) {
                                    if (wrapper.isUpgraded()) {
                                        if ((this.desc[n2 * 2] & 1L) == 1L) {
                                            if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_READ)) continue;
                                            AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                            continue;
                                        }
                                        if ((this.desc[n2 * 2] & 4L) == 4L) {
                                            if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_WRITE)) continue;
                                            AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                            continue;
                                        }
                                        if ((wrapper.pollerFlags & 1) == 1) {
                                            if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_READ)) continue;
                                            AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                            continue;
                                        }
                                        if ((wrapper.pollerFlags & 4) == 4) {
                                            if (AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_WRITE)) continue;
                                            AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                            continue;
                                        }
                                        AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                        continue;
                                    }
                                    AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                if ((this.desc[n2 * 2] & 1L) == 1L || (this.desc[n2 * 2] & 4L) == 4L) {
                                    boolean error = false;
                                    if ((this.desc[n2 * 2] & 1L) == 1L && !AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_READ)) {
                                        error = true;
                                        AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    }
                                    if (!error && (this.desc[n2 * 2] & 4L) == 4L && !AprEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketStatus.OPEN_WRITE)) {
                                        error = true;
                                        AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    }
                                    if (error || wrapper.pollerFlags == 0) continue;
                                    if (timeout > 0L) {
                                        timeout -= System.currentTimeMillis();
                                    }
                                    if (timeout <= 0L) {
                                        timeout = 1L;
                                    }
                                    if (timeout > Integer.MAX_VALUE) {
                                        timeout = Integer.MAX_VALUE;
                                    }
                                    this.add(this.desc[n2 * 2 + 1], (int)timeout, wrapper.pollerFlags);
                                    continue;
                                }
                                AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollUnknownEvent", this.desc[n2 * 2]));
                                AprEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                            }
                        } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                            if (errn > 120000) {
                                errn -= 120000;
                            }
                            AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollError", errn, Error.strerror(errn)));
                            reset = true;
                        }
                        if (!reset || !this.pollerRunning) continue;
                        int count = Poll.pollset(this.pollers[i], this.desc);
                        long newPoller = AprEndpoint.this.allocatePoller(this.actualPollerSize, this.pool, -1);
                        this.pollerSpace[i] = this.actualPollerSize;
                        this.connectionCount.addAndGet(-count);
                        Poll.destroy(this.pollers[i]);
                        this.pollers[i] = newPoller;
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), t);
                }
                try {
                    if (AprEndpoint.this.getSoTimeout() <= 0 || !this.pollerRunning) continue;
                    this.maintain();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.timeout.err"), t);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }
    }

    public static class SocketList {
        protected int size = 0;
        protected int pos = 0;
        protected long[] sockets;
        protected int[] timeouts;
        protected int[] flags;
        protected SocketInfo info = new SocketInfo();

        public SocketList(int size) {
            this.sockets = new long[size];
            this.timeouts = new int[size];
            this.flags = new int[size];
        }

        public int size() {
            return this.size;
        }

        public SocketInfo get() {
            if (this.pos == this.size) {
                return null;
            }
            this.info.socket = this.sockets[this.pos];
            this.info.timeout = this.timeouts[this.pos];
            this.info.flags = this.flags[this.pos];
            ++this.pos;
            return this.info;
        }

        public void clear() {
            this.size = 0;
            this.pos = 0;
        }

        public boolean add(long socket, int timeout, int flag) {
            if (this.size == this.sockets.length) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != socket) continue;
                this.flags[i] = SocketInfo.merge(this.flags[i], flag);
                return true;
            }
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            this.flags[this.size] = flag;
            ++this.size;
            return true;
        }

        public boolean remove(long socket) {
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != socket) continue;
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                this.flags[this.size] = this.flags[this.size - 1];
                --this.size;
                return true;
            }
            return false;
        }

        public void duplicate(SocketList copy) {
            copy.size = this.size;
            copy.pos = this.pos;
            System.arraycopy(this.sockets, 0, copy.sockets, 0, this.size);
            System.arraycopy(this.timeouts, 0, copy.timeouts, 0, this.size);
            System.arraycopy(this.flags, 0, copy.flags, 0, this.size);
        }
    }

    public static class SocketTimeouts {
        protected int size = 0;
        protected long[] sockets;
        protected long[] timeouts;
        protected int pos = 0;

        public SocketTimeouts(int size) {
            this.sockets = new long[size];
            this.timeouts = new long[size];
        }

        public void add(long socket, long timeout) {
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            ++this.size;
        }

        public long remove(long socket) {
            long result = 0L;
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != socket) continue;
                result = this.timeouts[i];
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                --this.size;
                break;
            }
            return result;
        }

        public long check(long date) {
            while (this.pos < this.size) {
                if (date >= this.timeouts[this.pos]) {
                    long result = this.sockets[this.pos];
                    this.sockets[this.pos] = this.sockets[this.size - 1];
                    this.timeouts[this.pos] = this.timeouts[this.size - 1];
                    --this.size;
                    return result;
                }
                ++this.pos;
            }
            this.pos = 0;
            return 0L;
        }
    }

    public static class SocketInfo {
        public long socket;
        public int timeout;
        public int flags;

        public boolean read() {
            return (this.flags & 1) == 1;
        }

        public boolean write() {
            return (this.flags & 4) == 4;
        }

        public static int merge(int flag1, int flag2) {
            return flag1 & 1 | flag2 & 1 | (flag1 & 4 | flag2 & 4);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Socket: [");
            sb.append(this.socket);
            sb.append("], timeout: [");
            sb.append(this.timeout);
            sb.append("], flags: [");
            sb.append(this.flags);
            return sb.toString();
        }
    }

    protected class AsyncTimeout
    implements Runnable {
        private volatile boolean asyncTimeoutRunning = true;

        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (this.asyncTimeoutRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                for (SocketWrapper<Long> socket : AprEndpoint.this.waitingRequests) {
                    if (!socket.async) continue;
                    long access = socket.getLastAccess();
                    if (socket.getTimeout() <= 0L || now - access <= socket.getTimeout()) continue;
                    socket.setTimeout(-1L);
                    AprEndpoint.this.processSocketAsync(socket, SocketStatus.TIMEOUT);
                }
                while (AprEndpoint.this.paused && this.asyncTimeoutRunning) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        protected void stop() {
            this.asyncTimeoutRunning = false;
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        private final Log log = LogFactory.getLog(Acceptor.class);

        protected Acceptor() {
        }

        @Override
        public void run() {
            int errorDelay = 0;
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!AprEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    AprEndpoint.this.countUpOrAwaitConnection();
                    long socket = 0L;
                    try {
                        socket = Socket.accept(AprEndpoint.this.serverSock);
                        if (this.log.isDebugEnabled()) {
                            long sa = Address.get(1, socket);
                            Sockaddr addr = Address.getInfo(sa);
                            this.log.debug((Object)AbstractEndpoint.sm.getString("endpoint.apr.remoteport", socket, addr.port));
                        }
                    }
                    catch (Exception e) {
                        AprEndpoint.this.countDownConnection();
                        errorDelay = AprEndpoint.this.handleExceptionWithDelay(errorDelay);
                        throw e;
                    }
                    errorDelay = 0;
                    if (AprEndpoint.this.running && !AprEndpoint.this.paused) {
                        if (AprEndpoint.this.processSocketWithOptions(socket)) continue;
                        AprEndpoint.this.closeSocket(socket);
                        continue;
                    }
                    AprEndpoint.this.destroySocket(socket);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (!AprEndpoint.this.running) continue;
                    String msg = AbstractEndpoint.sm.getString("endpoint.accept.fail");
                    if (t instanceof Error) {
                        Error e = (Error)t;
                        if (e.getError() == 233) {
                            this.log.warn((Object)msg, t);
                            continue;
                        }
                        this.log.error((Object)msg, t);
                        continue;
                    }
                    this.log.error((Object)msg, t);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

