/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.authenticator.SingleSignOnListener;
import org.apache.catalina.authenticator.SingleSignOnSessionKey;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.res.StringManager;

public class SingleSignOn
extends ValveBase {
    protected static final boolean LAST_ACCESS_AT_START;
    private static final StringManager sm;
    private Engine engine;
    protected Map<String, SingleSignOnEntry> cache = new ConcurrentHashMap<String, SingleSignOnEntry>();
    protected static final String info = "org.apache.catalina.authenticator.SingleSignOn";
    private boolean requireReauthentication = false;
    private String cookieDomain;

    public SingleSignOn() {
        super(true);
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain != null && cookieDomain.trim().length() == 0 ? null : cookieDomain;
    }

    public boolean getRequireReauthentication() {
        return this.requireReauthentication;
    }

    public void setRequireReauthentication(boolean required) {
        this.requireReauthentication = required;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.invoke", request.getRequestURI()));
        }
        if (request.getUserPrincipal() != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.hasPrincipal", request.getUserPrincipal().getName()));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.cookieCheck"));
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!Constants.SINGLE_SIGN_ON_COOKIE.equals(cookies[i].getName())) continue;
                cookie = cookies[i];
                break;
            }
        }
        if (cookie == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.cookieNotFound"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.principalCheck", cookie.getValue()));
        }
        if ((entry = this.cache.get(cookie.getValue())) != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.principalFound", entry.getPrincipal() != null ? entry.getPrincipal().getName() : "", entry.getAuthType()));
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (!this.getRequireReauthentication()) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(entry.getPrincipal());
            }
        } else {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.principalNotFound", cookie.getValue()));
            }
            cookie.setValue("REMOVE");
            cookie.setMaxAge(0);
            cookie.setPath("/");
            String domain = this.getCookieDomain();
            if (domain != null) {
                cookie.setDomain(domain);
            }
            cookie.setSecure(request.isSecure());
            if (request.getServletContext().getSessionCookieConfig().isHttpOnly() || request.getContext().getUseHttpOnly()) {
                cookie.setHttpOnly(true);
            }
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    public void sessionDestroyed(String ssoId, Session session) {
        if (!this.getState().isAvailable()) {
            return;
        }
        if (session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getThisAccessedTimeInternal() >= (long)(session.getMaxInactiveInterval() * 1000) || !((Context)session.getManager().getContainer()).getState().isAvailable()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.sessionTimeout", ssoId, session));
            }
            this.removeSession(ssoId, session);
        } else {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.sessionLogout", ssoId, session));
            }
            this.deregister(ssoId);
        }
    }

    protected boolean associate(String ssoId, Session session) {
        SingleSignOnEntry sso = this.cache.get(ssoId);
        if (sso == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.associateFail", ssoId, session));
            }
            return false;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.associate", ssoId, session));
        }
        sso.addSession(this, ssoId, session);
        return true;
    }

    protected void deregister(String ssoId) {
        SingleSignOnEntry sso = this.cache.remove(ssoId);
        if (sso == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.deregisterFail", ssoId));
            }
            return;
        }
        Set<SingleSignOnSessionKey> ssoKeys = sso.findSessions();
        if (ssoKeys.size() == 0 && this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.deregisterNone", ssoId));
        }
        for (SingleSignOnSessionKey ssoKey : ssoKeys) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.deregister", ssoKey, ssoId));
            }
            this.expire(ssoKey);
        }
    }

    private void expire(SingleSignOnSessionKey key) {
        if (this.engine == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.engineNull", key));
            return;
        }
        Container host = this.engine.findChild(key.getHostName());
        if (host == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.hostNotFound", key));
            return;
        }
        Context context = (Context)host.findChild(key.getContextName());
        if (context == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.contextNotFound", key));
            return;
        }
        Manager manager = context.getManager();
        if (manager == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.managerNotFound", key));
            return;
        }
        Session session = null;
        try {
            session = manager.findSession(key.getSessionId());
        }
        catch (IOException e) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.managerError", key), (Throwable)e);
            return;
        }
        if (session == null) {
            this.containerLog.warn((Object)sm.getString("singleSignOn.sessionExpire.sessionNotFound", key));
            return;
        }
        session.expire();
    }

    protected boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.cache.get(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.register", ssoId, principal != null ? principal.getName() : "", authType));
        }
        this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
    }

    protected boolean update(String ssoId, Principal principal, String authType, String username, String password) {
        SingleSignOnEntry sso = this.cache.get(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("singleSignOn.debug.update", ssoId, authType));
            }
            sso.updateCredentials(principal, authType, username, password);
            return true;
        }
        return false;
    }

    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)sm.getString("singleSignOn.debug.removeSession", session, ssoId));
        }
        if ((entry = this.cache.get(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        if (entry.findSessions().size() == 0) {
            this.deregister(ssoId);
        }
    }

    protected SessionListener getSessionListener(String ssoId) {
        return new SingleSignOnListener(ssoId);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Container c;
        for (c = this.getContainer(); c != null && !(c instanceof Engine); c = c.getParent()) {
        }
        if (c instanceof Engine) {
            this.engine = (Engine)c;
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.engine = null;
    }

    static {
        String lastAccessAtStart = System.getProperty("org.apache.catalina.session.StandardSession.LAST_ACCESS_AT_START");
        LAST_ACCESS_AT_START = lastAccessAtStart == null ? Globals.STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(lastAccessAtStart);
        sm = StringManager.getManager("org.apache.catalina.authenticator");
    }
}

