/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import jakarta.servlet.http.CookieNameValidator;
import jakarta.servlet.http.RFC2109Validator;
import jakarta.servlet.http.RFC6265Validator;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class Cookie
implements Cloneable,
Serializable {
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    private static final ResourceBundle LSTRINGS;
    private static final CookieNameValidator validation;
    private static final long serialVersionUID = 2L;
    private final String name;
    private String value;
    private int version = 0;
    private volatile Map<String, String> attributes;
    private static final String COMMENT = "Comment";
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String PATH = "Path";
    private static final String SECURE = "Secure";
    private static final String HTTP_ONLY = "HttpOnly";

    public Cookie(String name, String value) {
        validation.validate(name);
        this.name = name;
        this.value = value;
    }

    public void setComment(String purpose) {
        this.setAttributeInternal(COMMENT, purpose);
    }

    public String getComment() {
        return this.getAttribute(COMMENT);
    }

    public void setDomain(String pattern) {
        if (pattern == null) {
            this.setAttributeInternal(DOMAIN, null);
        } else {
            this.setAttributeInternal(DOMAIN, pattern.toLowerCase(Locale.ENGLISH));
        }
    }

    public String getDomain() {
        return this.getAttribute(DOMAIN);
    }

    public void setMaxAge(int expiry) {
        this.setAttributeInternal(MAX_AGE, Integer.toString(expiry));
    }

    public int getMaxAge() {
        String maxAge = this.getAttribute(MAX_AGE);
        if (maxAge == null) {
            return -1;
        }
        return Integer.parseInt(maxAge);
    }

    public void setPath(String uri) {
        this.setAttributeInternal(PATH, uri);
    }

    public String getPath() {
        return this.getAttribute(PATH);
    }

    public void setSecure(boolean flag) {
        this.setAttributeInternal(SECURE, Boolean.toString(flag));
    }

    public boolean getSecure() {
        return Boolean.parseBoolean(this.getAttribute(SECURE));
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHttpOnly(boolean httpOnly) {
        this.setAttributeInternal(HTTP_ONLY, Boolean.toString(httpOnly));
    }

    public boolean isHttpOnly() {
        return Boolean.parseBoolean(this.getAttribute(HTTP_ONLY));
    }

    public void setAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException(LSTRINGS.getString("cookie.attribute.invalidName.null"));
        }
        if (!validation.isToken(name)) {
            String msg = LSTRINGS.getString("cookie.attribute.invalidName.notToken");
            throw new IllegalArgumentException(MessageFormat.format(msg, name));
        }
        if (name.equalsIgnoreCase(MAX_AGE)) {
            if (value == null) {
                this.setAttributeInternal(MAX_AGE, null);
            } else {
                this.setMaxAge(Integer.parseInt(value));
            }
        } else {
            this.setAttributeInternal(name, value);
        }
    }

    private void setAttributeInternal(String name, String value) {
        if (this.attributes == null) {
            if (value == null) {
                return;
            }
            this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    static {
        String propFwdSlashIsSeparator;
        String propStrictNaming;
        boolean strictServletCompliance;
        LSTRINGS = ResourceBundle.getBundle(LSTRING_FILE);
        if (System.getSecurityManager() == null) {
            strictServletCompliance = Boolean.getBoolean("org.apache.catalina.STRICT_SERVLET_COMPLIANCE");
            propStrictNaming = System.getProperty("org.apache.tomcat.util.http.ServerCookie.STRICT_NAMING");
            propFwdSlashIsSeparator = System.getProperty("org.apache.tomcat.util.http.ServerCookie.FWD_SLASH_IS_SEPARATOR");
        } else {
            strictServletCompliance = AccessController.doPrivileged(() -> Boolean.valueOf(System.getProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE")));
            propStrictNaming = AccessController.doPrivileged(() -> System.getProperty("org.apache.tomcat.util.http.ServerCookie.STRICT_NAMING"));
            propFwdSlashIsSeparator = AccessController.doPrivileged(() -> System.getProperty("org.apache.tomcat.util.http.ServerCookie.FWD_SLASH_IS_SEPARATOR"));
        }
        boolean strictNaming = propStrictNaming == null ? strictServletCompliance : Boolean.parseBoolean(propStrictNaming);
        boolean allowSlash = propFwdSlashIsSeparator == null ? !strictServletCompliance : !Boolean.parseBoolean(propFwdSlashIsSeparator);
        validation = strictNaming ? new RFC2109Validator(allowSlash) : new RFC6265Validator();
    }
}

