/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.util;

import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import org.apache.tephra.util.HBaseVersion;
import org.apache.twill.internal.utils.Instances;

public abstract class HBaseVersionSpecificFactory<T>
implements Provider<T> {
    public T get() {
        T instance;
        try {
            switch (HBaseVersion.get()) {
                case HBASE_94: {
                    throw new ProvisionException("HBase 0.94 is no longer supported.  Please upgrade to HBase 0.96 or newer.");
                }
                case HBASE_96: {
                    instance = this.createInstance(this.getHBase96Classname());
                    break;
                }
                case HBASE_98: {
                    instance = this.createInstance(this.getHBase98Classname());
                    break;
                }
                case HBASE_10: {
                    instance = this.createInstance(this.getHBase10Classname());
                    break;
                }
                case HBASE_10_CDH: {
                    instance = this.createInstance(this.getHBase10CDHClassname());
                    break;
                }
                case HBASE_11: 
                case HBASE_12: {
                    instance = this.createInstance(this.getHBase11Classname());
                    break;
                }
                case HBASE_13: {
                    instance = this.createInstance(this.getHBase13Classname());
                    break;
                }
                case HBASE_14: {
                    instance = this.createInstance(this.getHBase14Classname());
                    break;
                }
                case HBASE_20: {
                    instance = this.createInstance(this.getHBase20Classname());
                    break;
                }
                default: {
                    throw new ProvisionException("Unknown HBase version: " + HBaseVersion.getVersionString());
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ProvisionException(cnfe.getMessage(), (Throwable)cnfe);
        }
        return instance;
    }

    protected T createInstance(String className) throws ClassNotFoundException {
        Class<?> clz = Class.forName(className);
        return (T)Instances.newInstance(clz);
    }

    protected abstract String getHBase96Classname();

    protected abstract String getHBase98Classname();

    protected abstract String getHBase10Classname();

    protected abstract String getHBase10CDHClassname();

    protected abstract String getHBase11Classname();

    protected abstract String getHBase13Classname();

    protected abstract String getHBase14Classname();

    protected abstract String getHBase20Classname();
}

