/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.io.WritableUtils;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TransactionCodec;
import org.apache.tephra.TxConstants;

public abstract class AbstractTransactionAwareTable
implements TransactionAware {
    protected final TransactionCodec txCodec;
    protected final Map<Long, Set<ActionChange>> changeSets;
    protected final TxConstants.ConflictDetection conflictLevel;
    protected final boolean pre014ChangeSetKey;
    protected Transaction tx;
    protected boolean allowNonTransactional;
    protected static final byte[] SEPARATOR_BYTE_ARRAY = new byte[]{0};

    public AbstractTransactionAwareTable(TxConstants.ConflictDetection conflictLevel, boolean allowNonTransactional, boolean pre014ChangeSetKey) {
        this.conflictLevel = conflictLevel;
        this.allowNonTransactional = allowNonTransactional;
        this.txCodec = new TransactionCodec();
        this.changeSets = Maps.newHashMap();
        this.pre014ChangeSetKey = pre014ChangeSetKey;
    }

    public boolean getAllowNonTransactional() {
        return this.allowNonTransactional;
    }

    public void setAllowNonTransactional(boolean allowNonTransactional) {
        this.allowNonTransactional = allowNonTransactional;
    }

    public void startTx(Transaction tx) {
        this.tx = tx;
    }

    public void updateTx(Transaction tx) {
        this.tx = tx;
    }

    public Collection<byte[]> getTxChanges() {
        if (this.conflictLevel == TxConstants.ConflictDetection.NONE) {
            return Collections.emptyList();
        }
        TreeSet<byte[]> txChanges = new TreeSet<byte[]>(UnsignedBytes.lexicographicalComparator());
        for (Set<ActionChange> changeSet : this.changeSets.values()) {
            for (ActionChange change : changeSet) {
                byte[] row = change.getRow();
                byte[] fam = change.getFamily();
                byte[] qual = change.getQualifier();
                txChanges.add(this.getChangeKey(row, fam, qual));
                if (!this.pre014ChangeSetKey) continue;
                txChanges.add(this.getChangeKeyWithoutSeparators(row, fam, qual));
            }
        }
        return txChanges;
    }

    protected byte[] getVIntBytes(long vint) {
        long i = vint;
        int size = WritableUtils.getVIntSize((long)i);
        byte[] result = new byte[size];
        int offset = 0;
        if (i >= -112L && i <= 127L) {
            result[offset] = (byte)i;
            return result;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((i & mask) >> shiftbits);
        }
        return result;
    }

    public byte[] getChangeKey(byte[] row, byte[] family, byte[] qualifier) {
        return this.getChangeKeyWithSeparators(row, family, qualifier);
    }

    private byte[] getChangeKeyWithSeparators(byte[] row, byte[] family, byte[] qualifier) {
        byte[] key;
        byte[] tableKey = this.getTableKey();
        switch (this.conflictLevel) {
            case ROW: {
                key = Bytes.concat((byte[][])new byte[][]{tableKey, SEPARATOR_BYTE_ARRAY, row});
                break;
            }
            case COLUMN: {
                key = Bytes.concat((byte[][])new byte[][]{tableKey, SEPARATOR_BYTE_ARRAY, this.getVIntBytes(family.length), family, this.getVIntBytes(qualifier.length), qualifier, row});
                break;
            }
            case NONE: {
                throw new IllegalStateException("NONE conflict detection does not support change keys");
            }
            default: {
                throw new IllegalStateException("Unknown conflict detection level: " + (Object)((Object)this.conflictLevel));
            }
        }
        return key;
    }

    private byte[] getChangeKeyWithoutSeparators(byte[] row, byte[] family, byte[] qualifier) {
        byte[] key;
        byte[] tableKey = this.getTableKey();
        switch (this.conflictLevel) {
            case ROW: {
                key = Bytes.concat((byte[][])new byte[][]{tableKey, row});
                break;
            }
            case COLUMN: {
                key = Bytes.concat((byte[][])new byte[][]{tableKey, row, family, qualifier});
                break;
            }
            case NONE: {
                throw new IllegalStateException("NONE conflict detection does not support change keys");
            }
            default: {
                throw new IllegalStateException("Unknown conflict detection level: " + (Object)((Object)this.conflictLevel));
            }
        }
        return key;
    }

    public boolean commitTx() throws Exception {
        return this.doCommit();
    }

    protected abstract boolean doCommit() throws IOException;

    public void postTxCommit() {
        this.tx = null;
        this.changeSets.clear();
    }

    public String getTransactionAwareName() {
        return new String(this.getTableKey(), Charsets.UTF_8);
    }

    protected abstract byte[] getTableKey();

    public boolean rollbackTx() throws Exception {
        return this.doRollback();
    }

    protected abstract boolean doRollback() throws Exception;

    protected void addToChangeSet(byte[] row, byte[] family, byte[] qualifier) {
        long currentWritePointer = this.tx.getWritePointer();
        HashSet changeSet = this.changeSets.get(currentWritePointer);
        if (changeSet == null) {
            changeSet = Sets.newHashSet();
            this.changeSets.put(currentWritePointer, changeSet);
        }
        switch (this.conflictLevel) {
            case ROW: 
            case NONE: {
                changeSet.add(new ActionChange(row, family));
                break;
            }
            case COLUMN: {
                changeSet.add(new ActionChange(row, family, qualifier));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown conflict detection level: " + (Object)((Object)this.conflictLevel));
            }
        }
    }

    protected class ActionChange {
        private final byte[] row;
        private final byte[] family;
        private final byte[] qualifier;

        public ActionChange(byte[] row, byte[] family) {
            this(row, family, null);
        }

        public ActionChange(byte[] row, byte[] family, byte[] qualifier) {
            this.row = row;
            this.family = family;
            this.qualifier = qualifier;
        }

        public byte[] getRow() {
            return this.row;
        }

        public byte[] getFamily() {
            return this.family;
        }

        public byte[] getQualifier() {
            return this.qualifier;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ActionChange other = (ActionChange)o;
            return Arrays.equals(this.row, other.row) && Arrays.equals(this.family, other.family) && Arrays.equals(this.qualifier, other.qualifier);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.row);
            result = 31 * result + (this.family != null ? Arrays.hashCode(this.family) : 0);
            result = 31 * result + (this.qualifier != null ? Arrays.hashCode(this.qualifier) : 0);
            return result;
        }
    }
}

