/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.util.Set;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.types.StructType;
import scala.Function2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E4AAB\u0004\u0001-!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00159\u0007\u0001\"\u0011i\u0005A1uN]3bG\"\u0014\u0015\r^2i'&t7N\u0003\u0002\t\u0013\u000591o\\;sG\u0016\u001c(B\u0001\u0006\f\u0003%\u0019HO]3b[&twM\u0003\u0002\r\u001b\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\u000b\u0003/E\u001a2\u0001\u0001\r!!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003mC:<'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011aa\u00142kK\u000e$\bCA\u0011#\u001b\u0005I\u0011BA\u0012\n\u0005\u0011\u0019\u0016N\\6\u0002\u0017\t\fGo\u00195Xe&$XM\u001d\t\u0006M%Z#(P\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\tIa)\u001e8di&|gN\r\t\u0004Y5zS\"A\u0007\n\u00059j!a\u0002#bi\u0006\u001cX\r\u001e\t\u0003aEb\u0001\u0001B\u00033\u0001\t\u00071GA\u0001U#\t!t\u0007\u0005\u0002'k%\u0011ag\n\u0002\b\u001d>$\b.\u001b8h!\t1\u0003(\u0003\u0002:O\t\u0019\u0011I\\=\u0011\u0005\u0019Z\u0014B\u0001\u001f(\u0005\u0011auN\\4\u0011\u0005\u0019r\u0014BA (\u0005\u0011)f.\u001b;\u0002\u000f\u0015t7m\u001c3feB\u0019!iR\u0018\u000e\u0003\rS!\u0001R#\u0002\u0011\u0015t7m\u001c3feNT!AR\u0007\u0002\u0011\r\fG/\u00197zgRL!\u0001S\"\u0003#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0004\u00176s\u0005c\u0001'\u0001_5\tq\u0001C\u0003%\u0007\u0001\u0007Q\u0005C\u0003A\u0007\u0001\u0007\u0011)\u0001\u0005bI\u0012\u0014\u0015\r^2i)\ri\u0014k\u0015\u0005\u0006%\u0012\u0001\rAO\u0001\bE\u0006$8\r[%e\u0011\u0015!F\u00011\u0001V\u0003\u0011!\u0017\r^1\u0011\u0005Y#gBA,c\u001d\tA\u0016M\u0004\u0002ZA:\u0011!l\u0018\b\u00037zk\u0011\u0001\u0018\u0006\u0003;V\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002d\u001b\u00059\u0001/Y2lC\u001e,\u0017BA3g\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002d\u001b\u0005AAo\\*ue&tw\rF\u0001j!\tQgN\u0004\u0002lYB\u00111lJ\u0005\u0003[\u001e\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Qn\n")
public class ForeachBatchSink<T>
implements Sink {
    private final Function2<Dataset<T>, Object, BoxedUnit> batchWriter;
    private final ExpressionEncoder<T> encoder;

    @Override
    public String name() {
        return Sink.name$(this);
    }

    @Override
    public StructType schema() {
        return Sink.schema$(this);
    }

    @Override
    public Set<TableCapability> capabilities() {
        return Sink.capabilities$(this);
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        RDD<InternalRow> rdd = data.queryExecution().toRdd();
        ExpressionEncoder<T> enc = this.encoder;
        Dataset<T> ds = data.sparkSession().internalCreateDataFrame(rdd, data.schema(), data.sparkSession().internalCreateDataFrame$default$3()).as(enc);
        this.batchWriter.apply(ds, (Object)BoxesRunTime.boxToLong((long)batchId));
    }

    public String toString() {
        return "ForeachBatchSink";
    }

    public ForeachBatchSink(Function2<Dataset<T>, Object, BoxedUnit> batchWriter, ExpressionEncoder<T> encoder) {
        this.batchWriter = batchWriter;
        this.encoder = encoder;
        Sink.$init$(this);
    }
}

