/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.stat;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.TryCast;
import org.apache.spark.sql.catalyst.expressions.TryCast$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.StddevSamp;
import org.apache.spark.sql.catalyst.expressions.aggregate.StddevSamp$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.stat.StatFunctions;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class StatFunctions$
implements Logging {
    public static final StatFunctions$ MODULE$ = new StatFunctions$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> multipleApproxQuantiles(Dataset<Row> df, scala.collection.immutable.Seq<String> cols, scala.collection.immutable.Seq<Object> probabilities, double relativeError) {
        Predef$.MODULE$.require(relativeError >= 0.0, (Function0 & Serializable)() -> new StringBuilder(44).append("Relative Error must be non-negative but got ").append(relativeError).toString());
        scala.collection.immutable.Seq columns = (scala.collection.immutable.Seq)cols.map((Function1 & Serializable)colName -> {
            NamedExpression field = df.resolve((String)colName);
            Predef$.MODULE$.require(((Expression)field).dataType() instanceof NumericType, (Function0 & Serializable)() -> new StringBuilder(18).append(new StringBuilder(48).append("Quantile calculation for column ").append((String)colName).append(" with data type ").append(((Expression)field).dataType()).toString()).append(" is not supported.").toString());
            return Column$.MODULE$.apply((Expression)new Cast(Column$.MODULE$.apply((String)colName).expr(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
        });
        QuantileSummaries[] emptySummaries = (QuantileSummaries[])Array$.MODULE$.fill(cols.size(), (Function0 & Serializable)() -> new QuantileSummaries(QuantileSummaries$.MODULE$.defaultCompressThreshold(), relativeError, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4(), QuantileSummaries$.MODULE$.$lessinit$greater$default$5()), ClassTag$.MODULE$.apply(QuantileSummaries.class));
        RDD<Row> qual$1 = df.select((scala.collection.immutable.Seq<Column>)columns).rdd();
        QuantileSummaries[] x$1 = emptySummaries;
        Function2 & Serializable x$2 = (Function2 & Serializable)(summaries, row) -> StatFunctions$.apply$1(summaries, row);
        Function2 & Serializable x$3 = (Function2 & Serializable)(sum1, sum2) -> StatFunctions$.merge$1(sum1, sum2);
        int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
        QuantileSummaries[] summaries2 = (QuantileSummaries[])qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(QuantileSummaries.class)));
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])summaries2), (Function1 & Serializable)summary -> {
            scala.collection.immutable.Seq seq;
            Option option = summary.query(probabilities);
            if (option instanceof Some) {
                scala.collection.immutable.Seq q;
                Some some = (Some)option;
                seq = q = (scala.collection.immutable.Seq)some.value();
            } else if (None$.MODULE$.equals(option)) {
                seq = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return seq;
        }, ClassTag$.MODULE$.apply(scala.collection.immutable.Seq.class)));
    }

    public double pearsonCorrelation(Dataset<Row> df, scala.collection.immutable.Seq<String> cols) {
        StatFunctions.CovarianceCounter counts = this.collectStatisticalData(df, cols, "correlation");
        return counts.Ck() / package$.MODULE$.sqrt(counts.MkX() * counts.MkY());
    }

    private StatFunctions.CovarianceCounter collectStatisticalData(Dataset<Row> df, scala.collection.immutable.Seq<String> cols, String functionName) {
        Predef$.MODULE$.require(cols.length() == 2, (Function0 & Serializable)() -> new StringBuilder(20).append(new StringBuilder(36).append("Currently ").append(functionName).append(" calculation is supported ").toString()).append("between two columns.").toString());
        ((IterableOnceOps)cols.map((Function1 & Serializable)name -> new Tuple2(name, (Object)df.resolve((String)name)))).foreach((Function1 & Serializable)x0$1 -> {
            StatFunctions$.$anonfun$collectStatisticalData$3(functionName, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq columns = (scala.collection.immutable.Seq)cols.map((Function1 & Serializable)n -> Column$.MODULE$.apply((Expression)new Cast(Column$.MODULE$.apply((String)n).expr(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())));
        RDD<InternalRow> qual$1 = df.select((scala.collection.immutable.Seq<Column>)columns).queryExecution().toRdd();
        StatFunctions.CovarianceCounter x$1 = new StatFunctions.CovarianceCounter();
        Function2 & Serializable x$2 = (Function2 & Serializable)(counter, row) -> counter.add(row.getDouble(0), row.getDouble(1));
        Function2 & Serializable x$3 = (Function2 & Serializable)(baseCounter, other) -> baseCounter.merge((StatFunctions.CovarianceCounter)other);
        int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
        return (StatFunctions.CovarianceCounter)qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(StatFunctions.CovarianceCounter.class));
    }

    public double calculateCov(Dataset<Row> df, scala.collection.immutable.Seq<String> cols) {
        StatFunctions.CovarianceCounter counts = this.collectStatisticalData(df, cols, "covariance");
        return counts.cov();
    }

    public Dataset<Row> crossTabulate(Dataset<Row> df, String col1, String col2) {
        Map distinctCol2;
        int columnSize;
        String tableName = new StringBuilder(1).append(col1).append("_").append(col2).toString();
        Row[] counts = (Row[])df.groupBy(col1, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{col2})).agg(functions$.MODULE$.count("*"), (scala.collection.immutable.Seq<Column>)Nil$.MODULE$).take((int)1000000.0);
        if (counts.length == (int)1000000.0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The maximum limit of 1e6 pairs have been collected, which may not be all of the pairs. Please try reducing the amount of distinct items in your columns.");
        }
        Predef$.MODULE$.require((double)(columnSize = (distinctCol2 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])counts), (Function1 & Serializable)e -> StatFunctions$.cleanElement$1(e.get(1)), ClassTag$.MODULE$.apply(String.class))))), (Ordering)Ordering.String$.MODULE$)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).size()) < 10000.0, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("The number of distinct values for ").append(col2).append(", can't ").toString()).append(new StringBuilder(22).append("exceed 1e4. Currently ").append(columnSize).toString()).toString());
        scala.collection.immutable.Seq table = ((IterableOnceOps)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])counts), (Function1 & Serializable)x$1 -> x$1.get(0)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object col1Item = tuple2._1();
            Row[] rows = (Row[])tuple2._2();
            GenericInternalRow countsRow = new GenericInternalRow(columnSize + 1);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])rows), (Function1 & Serializable)row -> {
                StatFunctions$.$anonfun$crossTabulate$6(distinctCol2, countsRow, row);
                return BoxedUnit.UNIT;
            });
            countsRow.update(0, (Object)UTF8String.fromString((String)StatFunctions$.cleanElement$1(col1Item)));
            GenericInternalRow genericInternalRow = countsRow;
            return genericInternalRow;
        })).toSeq();
        scala.collection.immutable.Seq headerNames = (scala.collection.immutable.Seq)((IterableOps)distinctCol2.toSeq().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)r -> new StructField(StatFunctions$.cleanColumnName$1(r._1().toString()), (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
        StructField structField = new StructField(tableName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)headerNames.$plus$colon((Object)structField));
        return Dataset$.MODULE$.ofRows(df.sparkSession(), (LogicalPlan)new LocalRelation(schema.toAttributes(), table, LocalRelation$.MODULE$.apply$default$3())).na().fill(0.0);
    }

    public Dataset<Row> summary(Dataset<?> ds, scala.collection.immutable.Seq<String> statistics) {
        LazyRef aggResult$lzy = new LazyRef();
        scala.collection.immutable.Seq defaultStatistics = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"count", "mean", "stddev", "min", "25%", "50%", "75%", "max"}));
        scala.collection.immutable.Seq selectedStatistics = statistics.nonEmpty() ? statistics : defaultStatistics;
        scala.collection.immutable.Seq percentiles = (scala.collection.immutable.Seq)((IterableOps)selectedStatistics.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)a.endsWith("%")))).map((Function1 & Serializable)p -> BoxesRunTime.boxToDouble((double)StatFunctions$.$anonfun$summary$2(p)));
        Predef$.MODULE$.require(percentiles.forall((Function1)(JFunction1.mcZD.sp & Serializable)p -> p >= 0.0 && p <= 1.0), (Function0 & Serializable)() -> "Percentiles must be in the range [0, 1]");
        IntRef percentileIndex = IntRef.create((int)0);
        scala.collection.immutable.Seq statisticFns = (scala.collection.immutable.Seq)selectedStatistics.map((Function1 & Serializable)stats -> {
            Function1 & Serializable intersect;
            block10: {
                Function1 & Serializable intersect2;
                block11: {
                    block9: {
                        if (!stats.endsWith("%")) break block9;
                        int index = percentileIndex$1.elem++;
                        intersect = (Function1 & Serializable)child -> new GetArrayItem((Expression)new ApproximatePercentile(StatFunctions$.castAsDoubleIfNecessary$1(child), (Expression)new Literal((Object)new GenericArrayData((Seq)percentiles), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false))).toAggregateExpression(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)index)), GetArrayItem$.MODULE$.apply$default$3());
                        break block10;
                    }
                    String string = stats.toLowerCase(Locale.ROOT);
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1197226255: {
                            if (!"approx_count_distinct".equals(string)) break;
                            intersect2 = (Function1 & Serializable)child -> new HyperLogLogPlusPlus(child, HyperLogLogPlusPlus$.MODULE$.apply$default$2(), HyperLogLogPlusPlus$.MODULE$.apply$default$3(), HyperLogLogPlusPlus$.MODULE$.apply$default$4()).toAggregateExpression();
                            break block11;
                        }
                        case -892408046: {
                            if (!"stddev".equals(string)) break;
                            intersect2 = (Function1 & Serializable)child -> new StddevSamp(StatFunctions$.castAsDoubleIfNecessary$1(child), StddevSamp$.MODULE$.apply$default$2()).toAggregateExpression();
                            break block11;
                        }
                        case 107876: {
                            if (!"max".equals(string)) break;
                            intersect2 = (Function1 & Serializable)child -> new Max(child).toAggregateExpression();
                            break block11;
                        }
                        case 108114: {
                            if (!"min".equals(string)) break;
                            intersect2 = (Function1 & Serializable)child -> new Min(child).toAggregateExpression();
                            break block11;
                        }
                        case 3347397: {
                            if (!"mean".equals(string)) break;
                            intersect2 = (Function1 & Serializable)child -> new Average(StatFunctions$.castAsDoubleIfNecessary$1(child), Average$.MODULE$.apply$default$2()).toAggregateExpression();
                            break block11;
                        }
                        case 94851343: {
                            if (!"count".equals(string)) break;
                            intersect2 = (Function1 & Serializable)child -> Count$.MODULE$.apply(child).toAggregateExpression();
                            break block11;
                        }
                        case 166449196: {
                            if (!"count_distinct".equals(string)) break;
                            intersect2 = (Function1 & Serializable)child -> {
                                Count qual$1 = Count$.MODULE$.apply(child);
                                boolean x$1 = true;
                                Option x$2 = qual$1.toAggregateExpression$default$2();
                                return qual$1.toAggregateExpression(true, x$2);
                            };
                            break block11;
                        }
                    }
                    throw QueryExecutionErrors$.MODULE$.statisticNotRecognizedError(stats);
                }
                intersect = intersect2;
            }
            return intersect;
        });
        scala.collection.immutable.Seq selectedCols = (scala.collection.immutable.Seq)ds.logicalPlan().output().filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)StatFunctions$.$anonfun$summary$14(a)));
        scala.collection.immutable.Seq aggExprs = (scala.collection.immutable.Seq)statisticFns.flatMap((Function1 & Serializable)func -> (scala.collection.immutable.Seq)selectedCols.map((Function1 & Serializable)c -> Column$.MODULE$.apply((Expression)new Cast((Expression)func.apply(c), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())).as(c.name())));
        InternalRow[] result = (InternalRow[])Array$.MODULE$.fill(selectedStatistics.length(), (Function0 & Serializable)() -> new GenericInternalRow(selectedCols.length() + 1), ClassTag$.MODULE$.apply(InternalRow.class));
        IntRef rowIndex = IntRef.create((int)0);
        while (rowIndex.elem < result.length) {
            String statsName = (String)selectedStatistics.apply(rowIndex.elem);
            result[rowIndex.elem].update(0, (Object)UTF8String.fromString((String)statsName));
            selectedCols.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)colIndex -> {
                UTF8String statsValue = StatFunctions$.aggResult$1(aggResult$lzy, ds, aggExprs).getUTF8String(rowIndex$1.elem * selectedCols.length() + colIndex);
                result[rowIndex$1.elem].update(colIndex + 1, (Object)statsValue);
            });
            ++rowIndex.elem;
        }
        String x$3 = "summary";
        StringType$ x$4 = StringType$.MODULE$;
        boolean x$5 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$6 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$7 = AttributeReference$.MODULE$.apply$default$5("summary", (DataType)x$4, x$5, x$6);
        scala.collection.immutable.Seq x$8 = AttributeReference$.MODULE$.apply$default$6("summary", (DataType)x$4, x$5, x$6);
        AttributeReference attributeReference = new AttributeReference("summary", (DataType)x$4, x$5, x$6, x$7, x$8);
        scala.collection.immutable.Seq output = (scala.collection.immutable.Seq)((SeqOps)selectedCols.map((Function1 & Serializable)c -> {
            String x$9 = c.name();
            StringType$ x$10 = StringType$.MODULE$;
            boolean x$11 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$12 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$13 = AttributeReference$.MODULE$.apply$default$5(x$9, (DataType)x$10, x$11, x$12);
            scala.collection.immutable.Seq x$14 = AttributeReference$.MODULE$.apply$default$6(x$9, (DataType)x$10, x$11, x$12);
            return new AttributeReference(x$9, (DataType)x$10, x$11, x$12, x$13, x$14);
        })).$plus$colon((Object)attributeReference);
        return Dataset$.MODULE$.ofRows(ds.sparkSession(), (LogicalPlan)new LocalRelation(output, (scala.collection.immutable.Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)result), LocalRelation$.MODULE$.apply$default$3()));
    }

    private static final QuantileSummaries[] apply$1(QuantileSummaries[] summaries, Row row) {
        for (int i = 0; i < summaries.length; ++i) {
            double v;
            if (row.isNullAt(i) || Double.isNaN(v = row.getDouble(i))) continue;
            summaries[i] = summaries[i].insert(v);
        }
        return summaries;
    }

    private static final QuantileSummaries[] merge$1(QuantileSummaries[] sum1, QuantileSummaries[] sum2) {
        return (QuantileSummaries[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])sum1), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])sum2))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            QuantileSummaries s1 = (QuantileSummaries)tuple2._1();
            QuantileSummaries s2 = (QuantileSummaries)tuple2._2();
            QuantileSummaries quantileSummaries = s1.compress().merge(s2.compress());
            return quantileSummaries;
        }, ClassTag$.MODULE$.apply(QuantileSummaries.class));
    }

    public static final /* synthetic */ void $anonfun$collectStatisticalData$3(String functionName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        NamedExpression data = (NamedExpression)tuple2._2();
        Predef$.MODULE$.require(((Expression)data).dataType() instanceof NumericType, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(23).append("Currently ").append(functionName$1).append(" calculation ").toString()).append(new StringBuilder(41).append("for columns with dataType ").append(((Expression)data).dataType().catalogString()).append(" not supported.").toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final String cleanElement$1(Object element) {
        return element == null ? "null" : element.toString();
    }

    public static final /* synthetic */ void $anonfun$crossTabulate$6(Map distinctCol2$1, GenericInternalRow countsRow$1, Row row) {
        int columnIndex = BoxesRunTime.unboxToInt((Object)distinctCol2$1.apply((Object)StatFunctions$.cleanElement$1(row.get(1))));
        countsRow$1.setLong(columnIndex + 1, row.getLong(2));
    }

    private static final String cleanColumnName$1(String name) {
        return name.replace("`", "");
    }

    public static final /* synthetic */ double $anonfun$summary$2(String p) {
        double d;
        try {
            d = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(p), "%"))) / 100.0;
        }
        catch (NumberFormatException e) {
            throw QueryExecutionErrors$.MODULE$.cannotParseStatisticAsPercentileError(p, e);
        }
        return d;
    }

    private static final Expression castAsDoubleIfNecessary$1(Expression e) {
        DataType dataType = e.dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        return !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null) ? new TryCast(e, (DataType)DoubleType$.MODULE$, TryCast$.MODULE$.apply$default$3()) : e;
    }

    public static final /* synthetic */ boolean $anonfun$summary$14(Attribute a) {
        return a.dataType() instanceof NumericType || a.dataType() instanceof StringType;
    }

    private static final /* synthetic */ InternalRow aggResult$lzycompute$1(LazyRef aggResult$lzy$1, Dataset ds$1, scala.collection.immutable.Seq aggExprs$1) {
        InternalRow internalRow;
        LazyRef lazyRef = aggResult$lzy$1;
        synchronized (lazyRef) {
            internalRow = aggResult$lzy$1.initialized() ? (InternalRow)aggResult$lzy$1.value() : (InternalRow)aggResult$lzy$1.initialize(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ds$1.select((scala.collection.immutable.Seq<Column>)aggExprs$1).queryExecution().toRdd().map((Function1 & Serializable)x$3 -> x$3.copy(), ClassTag$.MODULE$.apply(InternalRow.class)).collect())));
        }
        return internalRow;
    }

    private static final InternalRow aggResult$1(LazyRef aggResult$lzy$1, Dataset ds$1, scala.collection.immutable.Seq aggExprs$1) {
        return aggResult$lzy$1.initialized() ? (InternalRow)aggResult$lzy$1.value() : StatFunctions$.aggResult$lzycompute$1(aggResult$lzy$1, ds$1, aggExprs$1);
    }

    private StatFunctions$() {
    }
}

