/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.guava.cache;

import java.util.concurrent.Executor;
import org.spark-project.guava.annotations.Beta;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.cache.RemovalListener;
import org.spark-project.guava.cache.RemovalNotification;

@Beta
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

