/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.server.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneForOneStreamManager
extends StreamManager {
    private final Logger logger = LoggerFactory.getLogger(OneForOneStreamManager.class);
    private final AtomicLong nextStreamId = new AtomicLong((long)new Random().nextInt(Integer.MAX_VALUE) * 1000L);
    private final Map<Long, StreamState> streams = new ConcurrentHashMap<Long, StreamState>();

    @Override
    public ManagedBuffer getChunk(long streamId, int chunkIndex) {
        StreamState state = this.streams.get(streamId);
        if (chunkIndex != state.curChunk) {
            throw new IllegalStateException(String.format("Received out-of-order chunk index %s (expected %s)", chunkIndex, state.curChunk));
        }
        if (!state.buffers.hasNext()) {
            throw new IllegalStateException(String.format("Requested chunk index beyond end %s", chunkIndex));
        }
        ++state.curChunk;
        ManagedBuffer nextChunk = state.buffers.next();
        if (!state.buffers.hasNext()) {
            this.logger.trace("Removing stream id {}", (Object)streamId);
            this.streams.remove(streamId);
        }
        return nextChunk;
    }

    @Override
    public void connectionTerminated(long streamId) {
        StreamState state = this.streams.remove(streamId);
        if (state != null && state.buffers != null) {
            while (state.buffers.hasNext()) {
                state.buffers.next().release();
            }
        }
    }

    public long registerStream(Iterator<ManagedBuffer> buffers) {
        long myStreamId = this.nextStreamId.getAndIncrement();
        this.streams.put(myStreamId, new StreamState(buffers));
        return myStreamId;
    }

    private static class StreamState {
        final Iterator<ManagedBuffer> buffers;
        int curChunk = 0;

        StreamState(Iterator<ManagedBuffer> buffers) {
            this.buffers = buffers;
        }
    }
}

