/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;
import org.spark-project.guava.base.Objects;

public final class RpcRequest
implements RequestMessage {
    public final long requestId;
    public final byte[] message;

    public RpcRequest(long requestId, byte[] message) {
        this.requestId = requestId;
        this.message = message;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RpcRequest;
    }

    @Override
    public int encodedLength() {
        return 8 + Encoders.ByteArrays.encodedLength(this.message);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        Encoders.ByteArrays.encode(buf, this.message);
    }

    public static RpcRequest decode(ByteBuf buf) {
        long requestId = buf.readLong();
        byte[] message = Encoders.ByteArrays.decode(buf);
        return new RpcRequest(requestId, message);
    }

    public boolean equals(Object other) {
        if (other instanceof RpcRequest) {
            RpcRequest o = (RpcRequest)other;
            return this.requestId == o.requestId && Arrays.equals(this.message, o.message);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("requestId", this.requestId).add("message", this.message).toString();
    }
}

