/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.apache.hadoop.service.Service;

public class ServiceTerminatingCallable<V>
implements Callable<V> {
    private final Service owner;
    private Exception exception;
    private final Callable<V> callable;

    public ServiceTerminatingCallable(Service owner, Callable<V> callable) {
        Preconditions.checkArgument((callable != null ? 1 : 0) != 0, (Object)"null callable");
        this.owner = owner;
        this.callable = callable;
    }

    public Service getOwner() {
        return this.owner;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public V call() throws Exception {
        try {
            V v = this.callable.call();
            return v;
        }
        catch (Exception e) {
            this.exception = e;
            throw e;
        }
        finally {
            if (this.owner != null) {
                this.owner.stop();
            }
        }
    }
}

