/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.management;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;

public class MeterAndCounter {
    public static final String COUNTER = ".counter";
    public static final String METER = ".meter";
    final Meter meter;
    final Counter counter;
    final String name;

    public MeterAndCounter(MetricRegistry metrics, String name) {
        this.name = name;
        this.counter = metrics.counter(String.valueOf(name) + COUNTER);
        this.meter = metrics.meter(String.valueOf(name) + METER);
    }

    public MeterAndCounter(MetricRegistry metrics, Class clazz, String name) {
        this.name = name;
        this.counter = metrics.counter(MetricRegistry.name((Class)clazz, (String[])new String[]{String.valueOf(name) + COUNTER}));
        this.meter = metrics.meter(MetricRegistry.name((Class)clazz, (String[])new String[]{String.valueOf(name) + METER}));
    }

    public void mark() {
        this.counter.inc();
        this.meter.mark();
    }

    public void inc() {
        this.mark();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterAndCounter that = (MeterAndCounter)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public long getCount() {
        return this.counter.getCount();
    }
}

