/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.CheckedContainer;

public final class Utilities
extends Static {
    private Utilities() {
    }

    public static boolean equalsIgnoreMetadata(Object object, Object object2) {
        return Utilities.deepEquals(object, object2, ComparisonMode.IGNORE_METADATA);
    }

    public static boolean equalsApproximately(Object object, Object object2) {
        return Utilities.deepEquals(object, object2, ComparisonMode.APPROXIMATE);
    }

    public static boolean deepEquals(Object object, Object object2, ComparisonMode comparisonMode) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            assert (Utilities.isNotDebug(comparisonMode)) : (object != null ? object.getClass() : (object2 != null ? object2.getClass() : Object.class)).getSimpleName() + " #" + (object == null ? (char)'1' : '2') + " is null";
            return false;
        }
        if (object instanceof LenientComparable) {
            return ((LenientComparable)object).equals(object2, comparisonMode);
        }
        if (object2 instanceof LenientComparable) {
            return ((LenientComparable)object2).equals(object, comparisonMode);
        }
        if (object instanceof Map.Entry) {
            if (object2 instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return Utilities.deepEquals(entry.getKey(), entry2.getKey(), comparisonMode) && Utilities.deepEquals(entry.getValue(), entry2.getValue(), comparisonMode);
            }
            assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Map.Entry.class, object2);
            return false;
        }
        if (object instanceof Map) {
            if (object2 instanceof Map) {
                return Utilities.equals(((Map)object).entrySet(), ((Map)object2).entrySet(), comparisonMode);
            }
            assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Map.class, object2);
            return false;
        }
        if (object instanceof Collection) {
            if (object2 instanceof Collection) {
                return Utilities.equals((Collection)object, (Collection)object2, comparisonMode);
            }
            assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Collection.class, object2);
            return false;
        }
        if (object instanceof Object[]) {
            if (!(object2 instanceof Object[])) {
                assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Object[].class, object2);
                return false;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray instanceof LenientComparable[]) {
                return Utilities.equals((LenientComparable[])objectArray, objectArray2, comparisonMode);
            }
            if (objectArray2 instanceof LenientComparable[]) {
                return Utilities.equals((LenientComparable[])objectArray2, objectArray, comparisonMode);
            }
            int n = objectArray.length;
            if (objectArray2.length != n) {
                assert (Utilities.isNotDebug(comparisonMode)) : "Length " + n + " != " + objectArray2.length;
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Utilities.deepEquals(objectArray[i], objectArray2[i], comparisonMode)) continue;
                assert (Utilities.isNotDebug(comparisonMode)) : "object[" + i + "] not equal";
                return false;
            }
            return true;
        }
        return Objects.deepEquals(object, object2);
    }

    private static boolean equals(LenientComparable[] lenientComparableArray, Object[] objectArray, ComparisonMode comparisonMode) {
        int n = lenientComparableArray.length;
        if (objectArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            LenientComparable lenientComparable = lenientComparableArray[i];
            Object object = objectArray[i];
            if (lenientComparable == object || lenientComparable != null && lenientComparable.equals(object, comparisonMode)) continue;
            assert (Utilities.isNotDebug(comparisonMode)) : "object[" + i + "] not equal";
            return false;
        }
        return true;
    }

    private static boolean equals(Iterable<?> iterable, Iterable<?> iterable2, ComparisonMode comparisonMode) {
        Iterator<?> iterator = iterable.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedElement("Iterable", iterable, iterable2, "sizes");
                return false;
            }
            Object obj2 = iterator.next();
            if (Utilities.deepEquals(obj2, obj = iterator2.next(), comparisonMode)) continue;
            if (!(iterable instanceof Set) || !(iterable2 instanceof Set)) {
                assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedElement("Iterable", iterable, iterable2, "elements");
                return false;
            }
            LinkedList linkedList = new LinkedList();
            linkedList.add(obj2);
            while (iterator.hasNext()) {
                linkedList.add(iterator.next());
            }
            while (true) {
                Iterator iterator3 = linkedList.iterator();
                do {
                    if (iterator3.hasNext()) continue;
                    assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedElement("Set", iterable, iterable2, "elements");
                    return false;
                } while (!Utilities.deepEquals(iterator3.next(), obj, comparisonMode));
                iterator3.remove();
                if (!iterator2.hasNext()) break;
                obj = iterator2.next();
            }
            return linkedList.isEmpty();
        }
        return !iterator2.hasNext();
    }

    private static boolean isNotDebug(ComparisonMode comparisonMode) {
        return comparisonMode != ComparisonMode.DEBUG;
    }

    private static String mismatchedType(Class<?> clazz, Object object) {
        return "Expected " + clazz + " but got " + object.getClass();
    }

    private static String mismatchedElement(String string, Iterable<?> iterable, Iterable<?> iterable2, String string2) {
        Class clazz = null;
        if (iterable instanceof CheckedContainer) {
            clazz = ((CheckedContainer)((Object)iterable)).getElementType();
        }
        if (clazz == null && iterable2 instanceof CheckedContainer) {
            clazz = ((CheckedContainer)((Object)iterable2)).getElementType();
        }
        return string + '<' + (clazz != null ? clazz.getSimpleName() : "?") + ">: " + string2 + " not equal.";
    }

    public static int deepHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return object.hashCode();
    }

    public static String deepToString(Object object) {
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        return String.valueOf(object);
    }
}

