/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.IdentityConverter;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;

abstract class DateConverter<T>
extends SystemConverter<Date, T> {
    private static final long serialVersionUID = 945435736679371963L;
    SystemConverter<T, Date> inverse;

    DateConverter(Class<T> clazz) {
        super(Date.class, clazz);
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.SURJECTIVE, FunctionProperty.ORDER_PRESERVING, FunctionProperty.INVERTIBLE);
    }

    @Override
    public final ObjectConverter<T, Date> inverse() {
        return this.inverse;
    }

    public static final class Timestamp
    extends DateConverter<java.sql.Timestamp> {
        private static final long serialVersionUID = 7629460512978844462L;

        public Timestamp() {
            super(java.sql.Timestamp.class);
            this.inverse = new IdentityConverter<java.sql.Timestamp, Date>(this.targetClass, Date.class, this);
        }

        @Override
        public java.sql.Timestamp apply(Date date) {
            if (date == null || date instanceof java.sql.Timestamp) {
                return (java.sql.Timestamp)date;
            }
            return new java.sql.Timestamp(date.getTime());
        }
    }

    public static final class SQL
    extends DateConverter<java.sql.Date> {
        private static final long serialVersionUID = -7444502675467008640L;

        public SQL() {
            super(java.sql.Date.class);
            this.inverse = new IdentityConverter<java.sql.Date, Date>(this.targetClass, Date.class, this);
        }

        @Override
        public java.sql.Date apply(Date date) {
            if (date == null || date instanceof java.sql.Date) {
                return (java.sql.Date)date;
            }
            return new java.sql.Date(date.getTime());
        }
    }

    public static final class Long
    extends DateConverter<java.lang.Long> {
        private static final long serialVersionUID = 5145114630594761657L;

        public Long() {
            super(java.lang.Long.class);
            this.inverse = new Inverse(this);
        }

        @Override
        public Set<FunctionProperty> properties() {
            return Long.bijective();
        }

        @Override
        public java.lang.Long apply(Date date) {
            return date != null ? java.lang.Long.valueOf(date.getTime()) : null;
        }
    }

    private static final class Inverse
    extends SystemConverter<java.lang.Long, Date> {
        private static final long serialVersionUID = 5022624034871426299L;
        private final SystemConverter<Date, java.lang.Long> inverse;

        Inverse(SystemConverter<Date, java.lang.Long> systemConverter) {
            super(java.lang.Long.class, Date.class);
            this.inverse = systemConverter;
        }

        @Override
        public ObjectConverter<Date, java.lang.Long> inverse() {
            return this.inverse;
        }

        @Override
        public ObjectConverter<java.lang.Long, Date> unique() {
            return this.inverse.inverse();
        }

        @Override
        public Set<FunctionProperty> properties() {
            return this.inverse.properties();
        }

        @Override
        public Date apply(java.lang.Long l) {
            return l != null ? new Date(l) : null;
        }
    }
}

