/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.IdentityConverter;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;

final class ConventionalUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 6963634855104019466L;
    private final AbstractUnit<Q> target;
    final UnitConverter toTarget;

    ConventionalUnit(AbstractUnit<Q> abstractUnit, UnitConverter unitConverter, String string, byte by, short s) {
        super(string, by, s);
        this.target = abstractUnit;
        this.toTarget = unitConverter;
    }

    static <Q extends Quantity<Q>> AbstractUnit<Q> create(AbstractUnit<Q> abstractUnit, UnitConverter unitConverter) {
        char c;
        double d;
        Object object;
        Object object2;
        if (unitConverter.isIdentity()) {
            return abstractUnit;
        }
        ConventionalUnit<Q>[] conventionalUnitArray = abstractUnit.related();
        if (conventionalUnitArray != null && unitConverter instanceof LinearConverter) {
            object2 = (LinearConverter)unitConverter;
            object = conventionalUnitArray;
            int n = ((ConventionalUnit<Q>[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object3 = object[i];
                if (!((LinearConverter)object2).equivalent((LinearConverter)((ConventionalUnit)object3).toTarget)) continue;
                return object3;
            }
        }
        object2 = null;
        if (abstractUnit.isPrefixable() && (object = abstractUnit.getSymbol()) != null && !((String)object).isEmpty() && !Double.isNaN(d = AbstractConverter.scale(unitConverter)) && (c = Prefixes.symbol(d, ConventionalUnit.power((String)object))) != '\u0000') {
            object2 = Prefixes.concat(c, (String)object);
        }
        object = new ConventionalUnit<Q>(abstractUnit, unitConverter, (String)object2, 0, 0);
        if (object2 != null) {
            object = ((ConventionalUnit)object).unique((String)object2);
        }
        return object;
    }

    final ConventionalUnit<Q> unique(String string) {
        Object object = UnitRegistry.putIfAbsent(string, this);
        if (object instanceof ConventionalUnit) {
            boolean bl;
            ConventionalUnit conventionalUnit = (ConventionalUnit)object;
            if (this.target.equals(conventionalUnit.target) && (bl = this.toTarget instanceof LinearConverter && conventionalUnit.toTarget instanceof LinearConverter ? ((LinearConverter)this.toTarget).equivalent((LinearConverter)conventionalUnit.toTarget) : this.toTarget.equals(conventionalUnit.toTarget))) {
                return conventionalUnit;
            }
        }
        return this;
    }

    private static String pow(String string, int n, boolean bl) {
        if (string != null) {
            int n2;
            int n3;
            int n4 = string.length();
            int n5 = 1;
            for (n2 = 0; n2 < n4; n2 += Character.charCount(n3)) {
                n3 = string.codePointAt(n2);
                if (ConventionalUnit.isSymbolChar(n3)) continue;
                if (!Characters.isSuperScript(n3) || n2 + Character.charCount(n3) < n4) {
                    return null;
                }
                n5 = Characters.toNormalScript(n3) - 48;
            }
            if (n5 >= 0 && n5 <= 9) {
                if (bl) {
                    n3 = n5 % n == 0 ? 1 : 0;
                    n5 /= n;
                } else {
                    int n6 = n3 = (n5 *= n) >= 0 && n5 <= 9 ? 1 : 0;
                }
                if (n3 != 0) {
                    return string.substring(0, n2) + Characters.toSuperScript((char)(n5 + 48));
                }
            }
        }
        return null;
    }

    static int power(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        do {
            if (n3 >= n2) {
                return 1;
            }
            n = string.codePointAt(n3);
            n3 += Character.charCount(n);
        } while (ConventionalUnit.isSymbolChar(n));
        int n4 = Characters.toNormalScript(n) - 48;
        if (n4 >= 0 && n4 <= 9) {
            if (n3 < n2) {
                n = string.codePointAt(n3);
                if (ConventionalUnit.isSymbolChar(n)) {
                    return 0;
                }
                if ((n = Characters.toNormalScript(n)) >= 48 && n <= 57) {
                    return 0;
                }
            }
            return n4;
        }
        return 1;
    }

    public Dimension getDimension() {
        return this.target.getDimension();
    }

    @Override
    public SystemUnit<Q> getSystemUnit() {
        return this.target.getSystemUnit();
    }

    @Override
    public Map<SystemUnit<?>, Integer> getBaseUnits() {
        return this.target.getBaseUnits();
    }

    @Override
    final Map<SystemUnit<?>, Fraction> getBaseSystemUnits() {
        return this.target.getBaseSystemUnits();
    }

    public <T extends Quantity<T>> Unit<T> asType(Class<T> clazz) throws ClassCastException {
        Unit unit = this.target.asType(clazz);
        if (this.target.equals(unit)) {
            return this;
        }
        return unit.transform(this.toTarget);
    }

    public UnitConverter getConverterTo(Unit<Q> unit) throws UnconvertibleException {
        if (unit == this) {
            return IdentityConverter.INSTANCE;
        }
        ArgumentChecks.ensureNonNull("that", unit);
        UnitConverter unitConverter = this.toTarget;
        if (this.target != unit) {
            Unit unit2 = unit.getSystemUnit();
            if (this.target != unit2 && !this.target.isCompatible(unit2)) {
                throw new UnconvertibleException(this.incompatible(unit));
            }
            unitConverter = this.target.getConverterTo(unit2).concatenate(unitConverter);
            unitConverter = unit2.getConverterTo(unit).concatenate(unitConverter);
        }
        return unitConverter;
    }

    public UnitConverter getConverterToAny(Unit<?> unit) throws IncommensurableException {
        if (unit == this) {
            return IdentityConverter.INSTANCE;
        }
        ArgumentChecks.ensureNonNull("that", unit);
        UnitConverter unitConverter = this.toTarget;
        if (this.target != unit) {
            Unit unit2 = unit.getSystemUnit();
            if (this.target != unit2 && !this.target.isCompatible(unit2)) {
                throw new IncommensurableException(this.incompatible(unit));
            }
            unitConverter = this.target.getConverterToAny(unit2).concatenate(unitConverter);
            unitConverter = unit2.getConverterToAny(unit).concatenate(unitConverter);
        }
        return unitConverter;
    }

    final ConventionalUnit<Q> forSymbol(String string) {
        if (string.equals(this.getSymbol())) {
            return this;
        }
        return new ConventionalUnit<Q>(this.target, this.toTarget, string, this.scope, this.epsg);
    }

    public Unit<Q> alternate(String string) {
        throw new UnsupportedOperationException(Errors.format((short)106, this));
    }

    private void ensureRatioScale() {
        if (!this.toTarget.isLinear()) {
            throw new IllegalStateException(Errors.format((short)104, this));
        }
    }

    public Unit<?> multiply(Unit<?> unit) {
        if (unit == this) {
            return this.pow(2);
        }
        this.ensureRatioScale();
        return this.inferSymbol(this.target.multiply(unit).transform(this.toTarget), '\u22c5', unit);
    }

    public Unit<?> divide(Unit<?> unit) {
        this.ensureRatioScale();
        return this.inferSymbol(this.target.divide(unit).transform(this.toTarget), '\u2215', unit);
    }

    public Unit<?> pow(int n) {
        this.ensureRatioScale();
        return this.inferSymbol(this.applyConversion(this.target.pow(n), n, false), '\u207f', null);
    }

    public Unit<?> root(int n) {
        this.ensureRatioScale();
        return this.applyConversion(this.target.root(n), n, true);
    }

    private Unit<?> applyConversion(Unit<?> unit, int n, boolean bl) {
        String string;
        if (unit == this.target) {
            return this;
        }
        LinearConverter linearConverter = LinearConverter.pow(this.toTarget, n, bl);
        if (unit instanceof SystemUnit && (string = ConventionalUnit.pow(this.getSymbol(), n, bl)) != null) {
            return new ConventionalUnit<Q>((SystemUnit)unit, linearConverter, string, 0, 0).unique(string);
        }
        return unit.transform((UnitConverter)linearConverter);
    }

    public Unit<Q> transform(UnitConverter unitConverter) {
        ArgumentChecks.ensureNonNull("operation", unitConverter);
        AbstractUnit abstractUnit = this;
        if (!this.isPrefixable()) {
            abstractUnit = this.target;
            unitConverter = this.toTarget.concatenate(unitConverter);
        }
        return ConventionalUnit.create(abstractUnit, unitConverter);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            ConventionalUnit conventionalUnit = (ConventionalUnit)object;
            return Utilities.deepEquals(this.target, conventionalUnit.target, comparisonMode) && Utilities.deepEquals(this.toTarget, conventionalUnit.toTarget, comparisonMode);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * (this.target.hashCode() + 31 * this.toTarget.hashCode());
    }
}

