/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractName;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@XmlTransient
public class DefaultScopedName
extends AbstractName
implements ScopedName {
    private static final long serialVersionUID = 1363103337249930577L;
    private final UnmodifiableArrayList<? extends LocalName> parsedNames;
    private transient GenericName tail;
    private transient GenericName path;

    static AbstractName create(UnmodifiableArrayList<? extends DefaultLocalName> unmodifiableArrayList) {
        ArgumentChecks.ensureNonNull("names", unmodifiableArrayList);
        switch (unmodifiableArrayList.size()) {
            default: {
                return new DefaultScopedName(unmodifiableArrayList);
            }
            case 1: {
                return unmodifiableArrayList.get(0);
            }
            case 0: 
        }
        throw new IllegalArgumentException(Errors.format((short)20, "names"));
    }

    private DefaultScopedName(UnmodifiableArrayList<? extends LocalName> unmodifiableArrayList) {
        this.parsedNames = unmodifiableArrayList;
    }

    protected DefaultScopedName(NameSpace nameSpace, List<? extends CharSequence> list) {
        ArgumentChecks.ensureNonNull("names", list);
        int n = list.size();
        ArgumentChecks.ensureSizeBetween("names", 2, Integer.MAX_VALUE, n);
        DefaultNameSpace defaultNameSpace = DefaultNameSpace.castOrCopy(nameSpace);
        boolean bl = defaultNameSpace.isGlobal();
        int n2 = 0;
        LocalName[] localNameArray = new LocalName[n];
        Iterator<? extends CharSequence> iterator = list.iterator();
        CharSequence charSequence = iterator.next();
        do {
            ArgumentChecks.ensureNonNullElement("names", n2, charSequence);
            localNameArray[n2++] = new DefaultLocalName(defaultNameSpace, charSequence);
            defaultNameSpace = defaultNameSpace.child(charSequence);
            charSequence = iterator.next();
        } while (iterator.hasNext());
        DefaultLocalName defaultLocalName = defaultNameSpace.local(charSequence, null);
        if (bl) {
            defaultLocalName.fullyQualified = this.fullyQualified = this;
        }
        localNameArray[n2++] = defaultLocalName;
        if (n2 != n) {
            throw new ConcurrentModificationException(Errors.format((short)108, "names"));
        }
        this.parsedNames = UnmodifiableArrayList.wrap(localNameArray);
    }

    protected DefaultScopedName(GenericName genericName, GenericName genericName2) {
        ArgumentChecks.ensureNonNull("path", genericName);
        ArgumentChecks.ensureNonNull("tail", genericName2);
        List list = genericName.getParsedNames();
        List list2 = genericName2.getParsedNames();
        int n = list.size();
        LocalName[] localNameArray = new LocalName[n + list2.size()];
        localNameArray = list.toArray(localNameArray);
        Iterator iterator = list2.iterator();
        LocalName localName = (LocalName)iterator.next();
        LocalName localName2 = localNameArray[n - 1];
        NameSpace nameSpace = localName2.scope();
        NameSpace nameSpace2 = localName.scope();
        if (nameSpace2 instanceof DefaultNameSpace && ((DefaultNameSpace)nameSpace2).parent() == nameSpace) {
            if (genericName instanceof LocalName) {
                this.tail = genericName2;
            }
            while (true) {
                localNameArray[n++] = localName;
                if (iterator.hasNext()) {
                    localName = (LocalName)iterator.next();
                    continue;
                }
                break;
            }
        } else {
            DefaultNameSpace defaultNameSpace = DefaultNameSpace.castOrCopy(nameSpace);
            CharSequence charSequence = DefaultScopedName.name((GenericName)localName2);
            while (true) {
                defaultNameSpace = defaultNameSpace.child(charSequence);
                charSequence = DefaultScopedName.name((GenericName)localName);
                localName = new DefaultLocalName(defaultNameSpace, charSequence);
                localNameArray[n++] = localName;
                if (!iterator.hasNext()) break;
                localName = (LocalName)iterator.next();
            }
        }
        if (n != localNameArray.length) {
            throw new ConcurrentModificationException(Errors.format((short)108, "tail"));
        }
        this.parsedNames = UnmodifiableArrayList.wrap(localNameArray);
        if (genericName2 instanceof LocalName) {
            this.path = genericName;
        }
    }

    private static CharSequence name(GenericName genericName) {
        if (genericName instanceof DefaultLocalName) {
            return ((DefaultLocalName)genericName).name;
        }
        InternationalString internationalString = genericName.toInternationalString();
        return (CharSequence)(internationalString != null ? internationalString : genericName.toString());
    }

    @Override
    final int arraySize() {
        return this.parsedNames.arraySize();
    }

    @Override
    public NameSpace scope() {
        return this.head().scope();
    }

    public synchronized GenericName tail() {
        if (this.tail == null) {
            int n = this.parsedNames.size();
            switch (n) {
                default: {
                    this.tail = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(1, n));
                    break;
                }
                case 2: {
                    this.tail = (GenericName)this.parsedNames.get(1);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(n);
                }
            }
        }
        return this.tail;
    }

    public synchronized GenericName path() {
        if (this.path == null) {
            int n = this.parsedNames.size();
            switch (n) {
                default: {
                    this.path = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(0, n - 1));
                    break;
                }
                case 2: {
                    this.path = (GenericName)this.parsedNames.get(0);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(n);
                }
            }
        }
        return this.path;
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.parsedNames;
    }
}

