/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqltranslator.rule;

import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sqltranslator.api.config.SQLTranslatorRuleConfiguration;
import org.apache.shardingsphere.sqltranslator.exception.SQLTranslationException;
import org.apache.shardingsphere.sqltranslator.factory.SQLTranslatorFactory;
import org.apache.shardingsphere.sqltranslator.spi.SQLTranslator;

public final class SQLTranslatorRule
implements GlobalRule {
    private final SQLTranslator translator;
    private final boolean useOriginalSQLWhenTranslatingFailed;

    public SQLTranslatorRule(SQLTranslatorRuleConfiguration ruleConfig) {
        this.translator = SQLTranslatorFactory.getInstance((String)ruleConfig.getType());
        this.useOriginalSQLWhenTranslatingFailed = ruleConfig.isUseOriginalSQLWhenTranslatingFailed();
    }

    public String translate(String sql, SQLStatement sqlStatement, DatabaseType protocolType, DatabaseType storageType) {
        if (protocolType.equals(storageType)) {
            return sql;
        }
        try {
            return this.translator.translate(sql, sqlStatement, protocolType, storageType);
        }
        catch (SQLTranslationException ex) {
            if (this.useOriginalSQLWhenTranslatingFailed) {
                return sql;
            }
            throw new ShardingSphereException((Exception)((Object)ex));
        }
    }

    public String getType() {
        return SQLTranslatorRule.class.getSimpleName();
    }
}

