/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.util;

import java.math.BigInteger;
import lombok.Generated;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;

public final class SQLFederationDataTypeUtil {
    public static RelDataType createRelDataType(ShardingSphereTable table, DatabaseType protocolType, RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = typeFactory.builder();
        for (ShardingSphereColumn each : table.getColumns().values()) {
            fieldInfoBuilder.add(each.getName(), SQLFederationDataTypeUtil.getRelDataType(protocolType, each, typeFactory));
        }
        return fieldInfoBuilder.build();
    }

    private static RelDataType getRelDataType(DatabaseType protocolType, ShardingSphereColumn column, RelDataTypeFactory typeFactory) {
        Class<?> sqlTypeClass = SQLFederationDataTypeUtil.getSqlTypeClass(protocolType, column);
        RelDataType javaType = typeFactory.createJavaType(sqlTypeClass);
        return typeFactory.createTypeWithNullability(javaType, true);
    }

    private static Class<?> getSqlTypeClass(DatabaseType protocolType, ShardingSphereColumn column) {
        if (protocolType instanceof MySQLDatabaseType) {
            if (-6 == column.getDataType() || 5 == column.getDataType()) {
                return Integer.class;
            }
            if (4 == column.getDataType()) {
                return column.isUnsigned() ? Long.class : Integer.class;
            }
            if (-5 == column.getDataType()) {
                return column.isUnsigned() ? BigInteger.class : Long.class;
            }
        }
        return SqlType.valueOf((int)column.getDataType()).clazz;
    }

    @Generated
    private SQLFederationDataTypeUtil() {
    }
}

