/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.row;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.wrapper.SQLWrapperException;

public final class SQLFederationRowEnumerator<T>
implements Enumerator<T> {
    private final Collection<T> rows;
    private final Collection<Statement> statements;
    private Iterator<T> iterator;
    private T currentRow;

    public SQLFederationRowEnumerator(Collection<T> rows, Collection<Statement> statements) {
        this.rows = rows;
        this.statements = statements;
        this.iterator = rows.iterator();
    }

    public T current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.currentRow = this.iterator.next();
            return true;
        }
        this.currentRow = null;
        this.iterator = this.rows.iterator();
        return false;
    }

    public void reset() {
    }

    public void close() {
        try {
            for (Statement each : this.statements) {
                each.close();
            }
            this.currentRow = null;
            this.iterator = this.rows.iterator();
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }
}

