/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.tools.RelBuilder;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.SQLDialectFactory;
import org.apache.shardingsphere.sqlfederation.executor.TableScanExecutorContext;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.FilterableScanNodeExecutorContext;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.ScanNodeExecutorContext;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.filter.FilterableSchema;
import org.apache.shardingsphere.sqlfederation.optimizer.util.SQLFederationPlannerUtil;
import org.apache.shardingsphere.sqlfederation.row.EmptyRowEnumerator;
import org.apache.shardingsphere.sqlfederation.row.MemoryEnumerator;
import org.apache.shardingsphere.sqlfederation.row.SQLFederationRowEnumerator;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutorContext;

public final class FilterableTableScanExecutor
implements TableScanExecutor {
    private static final JavaTypeFactory JAVA_TYPE_FACTORY = new JavaTypeFactoryImpl();
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;
    private final JDBCExecutor jdbcExecutor;
    private final JDBCExecutorCallback<? extends ExecuteResult> callback;
    private final OptimizerContext optimizerContext;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final TableScanExecutorContext executorContext;
    private final ShardingSphereData data;

    public Enumerable<Object> executeScalar(ShardingSphereTable table, ScanNodeExecutorContext scanContext) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new EmptyRowEnumerator<Object>();
            }
        };
    }

    public Enumerable<Object[]> execute(ShardingSphereTable table, ScanNodeExecutorContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName().toLowerCase();
        String schemaName = this.executorContext.getSchemaName().toLowerCase();
        DatabaseType databaseType = DatabaseTypeEngine.getTrunkDatabaseType((String)this.optimizerContext.getParserContext(databaseName).getDatabaseType().getType());
        if (databaseType.getSystemSchemas().contains(schemaName)) {
            return this.executeByShardingSphereData(databaseName, schemaName, table);
        }
        SqlString sqlString = this.createSQLString(table, (FilterableScanNodeExecutorContext)scanContext, SQLDialectFactory.getSQLDialect(databaseType));
        SQLFederationExecutorContext federationContext = this.executorContext.getFederationContext();
        QueryContext queryContext = this.createQueryContext(federationContext.getMetaData(), sqlString, databaseType);
        ShardingSphereDatabase database = federationContext.getMetaData().getDatabase(databaseName);
        ExecutionContext context = new KernelProcessor().generateExecutionContext(queryContext, database, this.globalRuleMetaData, this.executorContext.getProps(), new ConnectionContext());
        if (federationContext.isPreview()) {
            federationContext.getExecutionUnits().addAll(context.getExecutionUnits());
            return this.createEmptyEnumerable();
        }
        return this.execute(databaseType, queryContext, database, context);
    }

    private AbstractEnumerable<Object[]> execute(DatabaseType databaseType, QueryContext queryContext, ShardingSphereDatabase database, ExecutionContext context) {
        ExecuteProcessEngine executeProcessEngine = new ExecuteProcessEngine();
        try {
            ExecutionGroupContext executionGroupContext = this.prepareEngine.prepare(context.getRouteContext(), context.getExecutionUnits(), new ExecutionGroupReportContext(database.getName()));
            this.setParameters(executionGroupContext.getInputGroups());
            executeProcessEngine.initializeExecution(executionGroupContext, context.getQueryContext());
            List<QueryResult> queryResults = this.execute((ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext, databaseType);
            MergeEngine mergeEngine = new MergeEngine(database, this.executorContext.getProps(), new ConnectionContext());
            MergedResult mergedResult = mergeEngine.merge(queryResults, queryContext.getSqlStatementContext());
            Collection<Statement> statements = this.getStatements(executionGroupContext.getInputGroups());
            AbstractEnumerable<Object[]> abstractEnumerable = this.createEnumerable(mergedResult, queryResults.get(0).getMetaData(), statements);
            return abstractEnumerable;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
        finally {
            executeProcessEngine.cleanExecution();
        }
    }

    private List<QueryResult> execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, DatabaseType databaseType) throws SQLException {
        Collection queryResults = this.jdbcExecutor.execute(executionGroupContext, this.callback).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
        LinkedList<QueryResult> result = new LinkedList<QueryResult>();
        for (QueryResult each2 : queryResults) {
            QueryResult queryResult = each2 instanceof JDBCStreamQueryResult ? new JDBCMemoryQueryResult(((JDBCStreamQueryResult)each2).getResultSet(), databaseType) : each2;
            result.add(queryResult);
        }
        return result;
    }

    private Enumerable<Object[]> executeByShardingSphereData(String databaseName, String schemaName, ShardingSphereTable table) {
        Optional<ShardingSphereTableData> tableData = Optional.ofNullable((ShardingSphereDatabaseData)this.data.getDatabaseData().get(databaseName)).map(optional -> (ShardingSphereSchemaData)optional.getSchemaData().get(schemaName)).map(ShardingSphereSchemaData::getTableData).map(shardingSphereData -> (ShardingSphereTableData)shardingSphereData.get(table.getName()));
        return tableData.map(this::createMemoryEnumerator).orElseGet(this::createEmptyEnumerable);
    }

    private Enumerable<Object[]> createMemoryEnumerator(final ShardingSphereTableData tableData) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new MemoryEnumerator<Object[]>(tableData.getRows());
            }
        };
    }

    private Collection<Statement> getStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                result.add(executionUnit.getStorageResource());
            }
        }
        return result;
    }

    private SqlString createSQLString(ShardingSphereTable table, FilterableScanNodeExecutorContext scanContext, SqlDialect sqlDialect) {
        return new RelToSqlConverter(sqlDialect).visitRoot(this.createRelNode(table, scanContext)).asStatement().toSqlString(sqlDialect);
    }

    private void setParameters(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                if (!(executionUnit.getStorageResource() instanceof PreparedStatement)) continue;
                this.setParameters((PreparedStatement)executionUnit.getStorageResource(), executionUnit.getExecutionUnit().getSqlUnit().getParameters());
            }
        }
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> params) {
        for (int i = 0; i < params.size(); ++i) {
            preparedStatement.setObject(i + 1, params.get(i));
        }
    }

    private RelNode createRelNode(ShardingSphereTable table, FilterableScanNodeExecutorContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName();
        String schemaName = this.executorContext.getSchemaName();
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(this.optimizerContext.getParserContext(databaseName).getDialectProps());
        ShardingSphereDatabase database = this.executorContext.getFederationContext().getMetaData().getDatabase(databaseName);
        CalciteCatalogReader catalogReader = SQLFederationPlannerUtil.createCatalogReader((String)schemaName, (Schema)new FilterableSchema(schemaName, database.getSchema(schemaName), database.getProtocolType(), JAVA_TYPE_FACTORY, null), (RelDataTypeFactory)JAVA_TYPE_FACTORY, (CalciteConnectionConfig)connectionConfig);
        RelOptCluster relOptCluster = RelOptCluster.create((RelOptPlanner)SQLFederationPlannerUtil.createVolcanoPlanner(), (RexBuilder)new RexBuilder((RelDataTypeFactory)JAVA_TYPE_FACTORY));
        RelBuilder builder = RelFactories.LOGICAL_BUILDER.create(relOptCluster, (RelOptSchema)catalogReader).scan(new String[]{table.getName()}).filter((Iterable)scanContext.getFilterValues());
        if (null != scanContext.getProjects()) {
            builder.project(this.createProjections(scanContext.getProjects(), builder, table.getColumnNames()));
        }
        return builder.build();
    }

    private Collection<RexNode> createProjections(int[] projects, RelBuilder relBuilder, List<String> columnNames) {
        LinkedList<RexNode> result = new LinkedList<RexNode>();
        for (int each : projects) {
            result.add((RexNode)relBuilder.field(columnNames.get(each)));
        }
        return result;
    }

    private AbstractEnumerable<Object[]> createEnumerable(MergedResult mergedResult, QueryResultMetaData metaData, final Collection<Statement> statements) throws SQLException {
        final Collection<Object[]> rows = this.getRows(mergedResult, metaData);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new SQLFederationRowEnumerator<Object[]>(rows, statements);
            }
        };
    }

    private Collection<Object[]> getRows(MergedResult mergedResult, QueryResultMetaData metaData) throws SQLException {
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        while (mergedResult.next()) {
            Object[] currentRow = new Object[metaData.getColumnCount()];
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                currentRow[i] = mergedResult.getValue(i + 1, Object.class);
            }
            result.add(currentRow);
        }
        return result;
    }

    private QueryContext createQueryContext(ShardingSphereMetaData metaData, SqlString sqlString, DatabaseType databaseType) {
        String sql = sqlString.getSql().replace("\n", " ");
        SQLStatement sqlStatement = new SQLStatementParserEngine(databaseType.getType(), this.optimizerContext.getSqlParserRule().getSqlStatementCache(), this.optimizerContext.getSqlParserRule().getParseTreeCache(), this.optimizerContext.getSqlParserRule().isSqlCommentParseEnabled()).parse(sql, false);
        List<Object> params = this.getParameters((List<Integer>)sqlString.getDynamicParameters());
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((ShardingSphereMetaData)metaData, params, (SQLStatement)sqlStatement, (String)this.executorContext.getDatabaseName());
        return new QueryContext(sqlStatementContext, sql, params);
    }

    private List<Object> getParameters(List<Integer> paramIndexes) {
        if (null == paramIndexes) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Integer each : paramIndexes) {
            result.add(this.executorContext.getFederationContext().getQueryContext().getParameters().get(each));
        }
        return result;
    }

    private AbstractEnumerable<Object[]> createEmptyEnumerable() {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new EmptyRowEnumerator<Object[]>();
            }
        };
    }

    @Generated
    public FilterableTableScanExecutor(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutor jdbcExecutor, JDBCExecutorCallback<? extends ExecuteResult> callback, OptimizerContext optimizerContext, ShardingSphereRuleMetaData globalRuleMetaData, TableScanExecutorContext executorContext, ShardingSphereData data) {
        this.prepareEngine = prepareEngine;
        this.jdbcExecutor = jdbcExecutor;
        this.callback = callback;
        this.optimizerContext = optimizerContext;
        this.globalRuleMetaData = globalRuleMetaData;
        this.executorContext = executorContext;
        this.data = data;
    }
}

