/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.datanode;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.common.SchemaTableNamesLoader;
import org.apache.shardingsphere.singletable.exception.SingleTablesLoadingException;

public final class SingleTableDataNodeLoader {
    public static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<String> excludedTables) {
        ConcurrentHashMap<String, Collection<DataNode>> result = new ConcurrentHashMap<String, Collection<DataNode>>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Map<String, Collection<DataNode>> dataNodeMap = SingleTableDataNodeLoader.load(databaseName, databaseType, entry.getKey(), entry.getValue(), excludedTables);
            for (String each : dataNodeMap.keySet()) {
                Collection<DataNode> addedDataNodes = dataNodeMap.get(each);
                Collection existDataNodes = result.getOrDefault(each.toLowerCase(), new LinkedHashSet(addedDataNodes.size(), 1.0f));
                existDataNodes.addAll(addedDataNodes);
                result.putIfAbsent(each.toLowerCase(), existDataNodes);
            }
        }
        return result;
    }

    private static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType databaseType, String dataSourceName, DataSource dataSource, Collection<String> excludedTables) {
        Map<String, Collection<String>> schemaTableNames = SingleTableDataNodeLoader.loadSchemaTableNames(databaseName, databaseType, dataSource, dataSourceName);
        LinkedHashMap<String, Collection<DataNode>> result = new LinkedHashMap<String, Collection<DataNode>>();
        for (Map.Entry<String, Collection<String>> entry : schemaTableNames.entrySet()) {
            for (String each : entry.getValue()) {
                if (excludedTables.contains(each)) continue;
                Collection dataNodes = result.getOrDefault(each, new LinkedList());
                DataNode dataNode = new DataNode(dataSourceName, each);
                dataNode.setSchemaName(entry.getKey());
                dataNodes.add(dataNode);
                result.putIfAbsent(each, dataNodes);
            }
        }
        return result;
    }

    private static Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DatabaseType databaseType, DataSource dataSource, String dataSourceName) {
        try {
            return SchemaTableNamesLoader.loadSchemaTableNames((String)databaseName, (DatabaseType)databaseType, (DataSource)dataSource);
        }
        catch (SQLException ex) {
            throw new SingleTablesLoadingException(databaseName, dataSourceName, ex);
        }
    }

    @Generated
    private SingleTableDataNodeLoader() {
    }
}

