/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.yaml.config.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.datanode.YamlDataNode;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.NewYamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.path.RuleNodePath;
import org.apache.shardingsphere.single.api.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.metadata.nodepath.SingleRuleNodePathProvider;
import org.apache.shardingsphere.single.yaml.config.pojo.YamlSingleRuleConfiguration;

public final class NewYamlSingleRuleConfigurationSwapper
implements NewYamlRuleConfigurationSwapper<SingleRuleConfiguration> {
    private final RuleNodePath singleRuleNodePath = new SingleRuleNodePathProvider().getRuleNodePath();

    public Collection<YamlDataNode> swapToDataNodes(SingleRuleConfiguration data) {
        return Collections.singletonList(new YamlDataNode("tables", YamlEngine.marshal((Object)this.swapToYamlConfiguration(data))));
    }

    private YamlSingleRuleConfiguration swapToYamlConfiguration(SingleRuleConfiguration data) {
        YamlSingleRuleConfiguration result = new YamlSingleRuleConfiguration();
        result.getTables().addAll(data.getTables());
        data.getDefaultDataSource().ifPresent(result::setDefaultDataSource);
        return result;
    }

    public Optional<SingleRuleConfiguration> swapToObject(Collection<YamlDataNode> dataNodes) {
        List validDataNodes = dataNodes.stream().filter(each -> this.singleRuleNodePath.getRoot().isValidatedPath(each.getKey())).collect(Collectors.toList());
        for (YamlDataNode each2 : validDataNodes) {
            if (!this.singleRuleNodePath.getUniqueItem("tables").isValidatedPath(each2.getKey())) continue;
            return Optional.of(this.swapToObject((YamlSingleRuleConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlSingleRuleConfiguration.class)));
        }
        return Optional.empty();
    }

    private SingleRuleConfiguration swapToObject(YamlSingleRuleConfiguration yamlConfig) {
        SingleRuleConfiguration result = new SingleRuleConfiguration();
        result.getTables().addAll(yamlConfig.getTables());
        result.setDefaultDataSource(yamlConfig.getDefaultDataSource());
        return result;
    }

    public Class<SingleRuleConfiguration> getTypeClass() {
        return SingleRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SINGLE";
    }

    public int getOrder() {
        return 30;
    }
}

