/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.util;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;

public final class SingleTableLoadUtils {
    private static final String DELIMITER = ",";

    public static Map<String, DataSource> getAggregatedDataSourceMap(Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        Map<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSourceMap);
        for (ShardingSphereRule each : builtRules) {
            if (!(each instanceof DataSourceContainedRule)) continue;
            result = SingleTableLoadUtils.getAggregatedDataSourceMap(result, (DataSourceContainedRule)each);
        }
        return result;
    }

    private static Map<String, DataSource> getAggregatedDataSourceMap(Map<String, DataSource> dataSourceMap, DataSourceContainedRule builtRule) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry entry : builtRule.getDataSourceMapper().entrySet()) {
            for (String each : (Collection)entry.getValue()) {
                if (!dataSourceMap.containsKey(each)) continue;
                result.putIfAbsent((String)entry.getKey(), dataSourceMap.remove(each));
            }
        }
        result.putAll(dataSourceMap);
        return result;
    }

    public static Collection<String> getExcludedTables(Collection<ShardingSphereRule> builtRules) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ShardingSphereRule each : builtRules) {
            if (!(each instanceof TableContainedRule)) continue;
            result.addAll(((TableContainedRule)each).getDistributedTableMapper().getTableNames());
            result.addAll(((TableContainedRule)each).getActualTableMapper().getTableNames());
        }
        return result;
    }

    public static Collection<String> getFeatureRequiredSingleTables(Collection<ShardingSphereRule> builtRules) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ShardingSphereRule each : builtRules) {
            TableContainedRule tableContainedRule;
            if (!(each instanceof TableContainedRule) || (tableContainedRule = (TableContainedRule)each).getEnhancedTableMapper().getTableNames().isEmpty() || !tableContainedRule.getDistributedTableMapper().getTableNames().isEmpty()) continue;
            result.addAll(tableContainedRule.getEnhancedTableMapper().getTableNames());
        }
        return result;
    }

    public static Collection<String> splitTableLines(Collection<String> tables) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String each : tables) {
            if (each.contains(DELIMITER)) {
                result.addAll(Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)each));
                continue;
            }
            result.add(each);
        }
        return result;
    }

    public static Collection<DataNode> convertToDataNodes(String databaseName, DatabaseType databaseType, Collection<String> tables) {
        LinkedHashSet<DataNode> result = new LinkedHashSet<DataNode>();
        for (String each : tables) {
            result.add(new DataNode(databaseName, databaseType, each));
        }
        return result;
    }

    public static String getAllTablesNodeStr(DatabaseType databaseType) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? "*.*.*" : "*.*";
    }

    public static String getAllTablesNodeStrFromDataSource(DatabaseType databaseType, String dataSourceName, String schemaName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? SingleTableLoadUtils.formatDataNode(dataSourceName, schemaName, "*") : SingleTableLoadUtils.formatDataNode(dataSourceName, "*");
    }

    public static String getDataNodeString(DatabaseType databaseType, String dataSourceName, String schemaName, String tableName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? SingleTableLoadUtils.formatDataNode(dataSourceName, schemaName, tableName) : SingleTableLoadUtils.formatDataNode(dataSourceName, tableName);
    }

    private static String formatDataNode(String dataSourceName, String tableName) {
        return String.format("%s.%s", dataSourceName, tableName);
    }

    private static String formatDataNode(String dataSourceName, String schemaName, String tableName) {
        return String.format("%s.%s.%s", dataSourceName, schemaName, tableName);
    }

    @Generated
    private SingleTableLoadUtils() {
    }
}

