/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.single.api.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.single.yaml.config.pojo.YamlSingleRuleConfiguration;
import org.apache.shardingsphere.single.yaml.config.swapper.YamlSingleRuleConfigurationSwapper;

public final class SingleTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<SingleRuleConfiguration, SingleRuleConfiguration> {
    public SingleRuleConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new YamlSingleRuleConfigurationSwapper().swapToObject((YamlSingleRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlSingleRuleConfiguration.class));
    }

    public SingleRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(SingleRule.class).map(SingleRule::getConfiguration).orElseGet(SingleRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, SingleRuleConfiguration currentRuleConfig, SingleRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().clear();
        currentRuleConfig.getTables().addAll(toBeChangedItemConfig.getTables());
        toBeChangedItemConfig.getDefaultDataSource().ifPresent(optional -> currentRuleConfig.setDefaultDataSource((String)toBeChangedItemConfig.getDefaultDataSource().get()));
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, SingleRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().clear();
        currentRuleConfig.setDefaultDataSource(null);
    }

    public String getType() {
        return "single.tables";
    }
}

