/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.scope.DatabaseRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableNamesMapper;
import org.apache.shardingsphere.infra.rule.identifier.type.exportable.ExportableRule;
import org.apache.shardingsphere.infra.state.datasource.DataSourceStateManager;
import org.apache.shardingsphere.single.api.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class SingleRule
implements DatabaseRule,
DataNodeContainedRule,
TableContainedRule,
MutableDataNodeRule,
ExportableRule {
    private final SingleRuleConfiguration configuration;
    private final String defaultDataSource;
    private final Collection<String> dataSourceNames;
    private final Map<String, Collection<DataNode>> singleTableDataNodes;
    private final TableNamesMapper tableNamesMapper = new TableNamesMapper();
    private final DatabaseType databaseType;

    public SingleRule(SingleRuleConfiguration ruleConfig, String databaseName, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.configuration = ruleConfig;
        this.defaultDataSource = ruleConfig.getDefaultDataSource().orElse(null);
        Map enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSources(databaseName, dataSourceMap);
        Map<String, DataSource> aggregateDataSourceMap = SingleTableLoadUtils.getAggregatedDataSourceMap((Map<String, DataSource>)enabledDataSources, builtRules);
        this.dataSourceNames = aggregateDataSourceMap.keySet();
        this.databaseType = DatabaseTypeEngine.getStorageType(enabledDataSources.values());
        this.singleTableDataNodes = SingleTableDataNodeLoader.load(databaseName, this.databaseType, aggregateDataSourceMap, builtRules, (Collection<String>)this.configuration.getTables());
        this.singleTableDataNodes.forEach((key, value) -> this.tableNamesMapper.put(((DataNode)value.iterator().next()).getTableName()));
    }

    public String assignNewDataSourceName() {
        return null == this.defaultDataSource ? new ArrayList<String>(this.dataSourceNames).get(ThreadLocalRandom.current().nextInt(this.dataSourceNames.size())) : this.defaultDataSource;
    }

    public boolean isAllTablesInSameComputeNode(Collection<DataNode> dataNodes, Collection<QualifiedTable> singleTables) {
        if (!this.isSingleTablesInSameComputeNode(singleTables)) {
            return false;
        }
        QualifiedTable sampleTable = singleTables.iterator().next();
        Optional<DataNode> sampleDataNode = this.findTableDataNode(sampleTable.getSchemaName(), sampleTable.getTableName());
        if (sampleDataNode.isPresent()) {
            for (DataNode each : dataNodes) {
                if (this.isSameComputeNode(sampleDataNode.get().getDataSourceName(), each.getDataSourceName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSameComputeNode(String sampleDataSourceName, String dataSourceName) {
        return sampleDataSourceName.equalsIgnoreCase(dataSourceName);
    }

    private boolean isSingleTablesInSameComputeNode(Collection<QualifiedTable> singleTables) {
        String sampleDataSourceName = null;
        for (QualifiedTable each : singleTables) {
            Optional<DataNode> dataNode = this.findTableDataNode(each.getSchemaName(), each.getTableName());
            if (!dataNode.isPresent()) continue;
            if (null == sampleDataSourceName) {
                sampleDataSourceName = dataNode.get().getDataSourceName();
                continue;
            }
            if (this.isSameComputeNode(sampleDataSourceName, dataNode.get().getDataSourceName())) continue;
            return false;
        }
        return true;
    }

    public Collection<QualifiedTable> getSingleTables(Collection<QualifiedTable> qualifiedTables) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        for (QualifiedTable each : qualifiedTables) {
            Collection dataNodes = this.singleTableDataNodes.getOrDefault(each.getTableName().toLowerCase(), new LinkedList());
            if (dataNodes.isEmpty() || !this.containsDataNode(each, dataNodes)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean containsDataNode(QualifiedTable qualifiedTable, Collection<DataNode> dataNodes) {
        for (DataNode each : dataNodes) {
            if (!qualifiedTable.getSchemaName().equalsIgnoreCase(each.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    public Collection<QualifiedTable> getQualifiedTables(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        Collection result = this.getQualifiedTables(database, this.databaseType, sqlStatementContext.getTablesContext().getSimpleTableSegments());
        if (result.isEmpty() && sqlStatementContext instanceof IndexAvailable) {
            result = IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)this.databaseType, (Collection)((IndexAvailable)sqlStatementContext).getIndexes());
        }
        return result;
    }

    private Collection<QualifiedTable> getQualifiedTables(ShardingSphereDatabase database, DatabaseType databaseType, Collection<SimpleTableSegment> tableSegments) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        String schemaName = new DatabaseTypeRegistry(databaseType).getDefaultSchemaName(database.getName());
        for (SimpleTableSegment each : tableSegments) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(schemaName);
            result.add(new QualifiedTable(actualSchemaName, each.getTableName().getIdentifier().getValue()));
        }
        return result;
    }

    public void put(String dataSourceName, String schemaName, String tableName) {
        if (this.dataSourceNames.contains(dataSourceName)) {
            Collection dataNodes = this.singleTableDataNodes.computeIfAbsent(tableName.toLowerCase(), key -> new LinkedHashSet());
            DataNode dataNode = new DataNode(dataSourceName, tableName);
            dataNode.setSchemaName(schemaName);
            dataNodes.add(dataNode);
            this.tableNamesMapper.put(tableName);
            this.addTableConfiguration(dataSourceName, schemaName, tableName);
        }
    }

    private void addTableConfiguration(String dataSourceName, String schemaName, String tableName) {
        Collection<String> splitTables = SingleTableLoadUtils.splitTableLines(this.configuration.getTables());
        if (splitTables.contains(SingleTableLoadUtils.getAllTablesNodeStr(this.databaseType)) || splitTables.contains(SingleTableLoadUtils.getAllTablesNodeStrFromDataSource(this.databaseType, dataSourceName, schemaName))) {
            return;
        }
        String dataNodeString = SingleTableLoadUtils.getDataNodeString(this.databaseType, dataSourceName, schemaName, tableName);
        if (!this.configuration.getTables().contains(dataNodeString)) {
            this.configuration.getTables().add(dataNodeString);
        }
    }

    public void remove(String schemaName, String tableName) {
        this.remove(Collections.singleton(schemaName.toLowerCase()), tableName);
    }

    public void remove(Collection<String> schemaNames, String tableName) {
        if (!this.singleTableDataNodes.containsKey(tableName.toLowerCase())) {
            return;
        }
        Collection<DataNode> dataNodes = this.singleTableDataNodes.get(tableName.toLowerCase());
        Iterator<DataNode> iterator = dataNodes.iterator();
        while (iterator.hasNext()) {
            DataNode each = iterator.next();
            if (!schemaNames.contains(each.getSchemaName().toLowerCase())) continue;
            iterator.remove();
            this.configuration.getTables().remove(SingleTableLoadUtils.getDataNodeString(this.databaseType, each.getDataSourceName(), each.getSchemaName(), tableName));
        }
        if (dataNodes.isEmpty()) {
            this.singleTableDataNodes.remove(tableName.toLowerCase());
            this.tableNamesMapper.remove(tableName);
        }
    }

    public Optional<DataNode> findTableDataNode(String schemaName, String tableName) {
        Collection dataNodes = this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), new LinkedHashSet());
        for (DataNode each : dataNodes) {
            if (!schemaName.equalsIgnoreCase(each.getSchemaName())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public ShardingSphereRule reloadRule(RuleConfiguration config, String databaseName, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        return new SingleRule((SingleRuleConfiguration)config, databaseName, dataSourceMap, builtRules);
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.singleTableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), Collections.emptyList());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return Optional.empty();
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return false;
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return Optional.empty();
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return Optional.empty();
    }

    public TableNamesMapper getLogicTableMapper() {
        return this.tableNamesMapper;
    }

    public TableNamesMapper getActualTableMapper() {
        return new TableNamesMapper();
    }

    public TableNamesMapper getDistributedTableMapper() {
        return new TableNamesMapper();
    }

    public TableNamesMapper getEnhancedTableMapper() {
        return new TableNamesMapper();
    }

    public Map<String, Object> getExportData() {
        return Collections.singletonMap("single_tables", this.tableNamesMapper.getTableNames());
    }

    @Generated
    public SingleRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, Collection<DataNode>> getSingleTableDataNodes() {
        return this.singleTableDataNodes;
    }
}

