/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.route.engine;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.single.route.engine.SingleDatabaseBroadcastRouteEngine;
import org.apache.shardingsphere.single.route.engine.SingleRouteEngine;
import org.apache.shardingsphere.single.route.engine.SingleStandardRouteEngine;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropSchemaStatement;

public final class SingleRouteEngineFactory {
    public static Optional<SingleRouteEngine> newInstance(Collection<QualifiedTable> singleTables, SQLStatement sqlStatement) {
        if (!singleTables.isEmpty()) {
            return Optional.of(new SingleStandardRouteEngine(singleTables, sqlStatement));
        }
        if (SingleRouteEngineFactory.isSchemaDDLStatement(sqlStatement)) {
            return Optional.of(new SingleDatabaseBroadcastRouteEngine());
        }
        return Optional.empty();
    }

    private static boolean isSchemaDDLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateSchemaStatement || sqlStatement instanceof AlterSchemaStatement || sqlStatement instanceof DropSchemaStatement;
    }

    @Generated
    private SingleRouteEngineFactory() {
    }
}

