/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.route;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.connection.validator.ShardingSphereMetaDataValidateUtils;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.single.route.engine.SingleRouteEngineFactory;
import org.apache.shardingsphere.single.route.validator.SingleMetaDataValidatorFactory;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;

public final class SingleSQLRouter
implements SQLRouter<SingleRule> {
    public RouteContext createRouteContext(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, SingleRule rule, ConfigurationProperties props, ConnectionContext connectionContext) {
        if (1 == database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits().size()) {
            return this.createSingleDataSourceRouteContext(rule, database, queryContext);
        }
        RouteContext result = new RouteContext();
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SingleMetaDataValidatorFactory.newInstance(sqlStatementContext.getSqlStatement()).ifPresent(optional -> optional.validate(rule, sqlStatementContext, database));
        Collection<QualifiedTable> singleTables = this.getSingleTables(database, rule, result, sqlStatementContext);
        this.validateSingleTableMetaData(database, sqlStatementContext, singleTables);
        SingleRouteEngineFactory.newInstance(singleTables, sqlStatementContext.getSqlStatement()).ifPresent(optional -> optional.route(result, rule));
        return result;
    }

    private void validateSingleTableMetaData(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext, Collection<QualifiedTable> singleTables) {
        if (!singleTables.isEmpty() && sqlStatementContext.getSqlStatement() instanceof DMLStatement) {
            ShardingSphereMetaDataValidateUtils.validateTableExist((SQLStatementContext)sqlStatementContext, (ShardingSphereDatabase)database);
        }
    }

    private Collection<QualifiedTable> getSingleTables(ShardingSphereDatabase database, SingleRule rule, RouteContext result, SQLStatementContext sqlStatementContext) {
        Collection<QualifiedTable> qualifiedTables = rule.getQualifiedTables(sqlStatementContext, database);
        return result.getRouteUnits().isEmpty() && sqlStatementContext.getSqlStatement() instanceof CreateTableStatement ? qualifiedTables : rule.getSingleTables(qualifiedTables);
    }

    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, SingleRule rule, ConfigurationProperties props, ConnectionContext connectionContext) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        Collection<QualifiedTable> singleTables = this.getSingleTables(database, rule, routeContext, sqlStatementContext);
        this.validateSingleTableMetaData(database, sqlStatementContext, singleTables);
        SingleRouteEngineFactory.newInstance(singleTables, sqlStatementContext.getSqlStatement()).ifPresent(optional -> optional.route(routeContext, rule));
    }

    private RouteContext createSingleDataSourceRouteContext(SingleRule rule, ShardingSphereDatabase database, QueryContext queryContext) {
        String logicDataSource = rule.getDataSourceNames().iterator().next();
        String actualDataSource = (String)database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits().keySet().iterator().next();
        RouteContext result = new RouteContext();
        result.getRouteUnits().add(new RouteUnit(new RouteMapper(logicDataSource, actualDataSource), this.createTableMappers(queryContext.getSqlStatementContext().getTablesContext().getTableNames())));
        return result;
    }

    private Collection<RouteMapper> createTableMappers(Collection<String> tableNames) {
        LinkedList<RouteMapper> result = new LinkedList<RouteMapper>();
        for (String each : tableNames) {
            result.add(new RouteMapper(each, each));
        }
        return result;
    }

    public int getOrder() {
        return 30;
    }

    public Class<SingleRule> getTypeClass() {
        return SingleRule.class;
    }
}

