/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.decorator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.rule.decorator.RuleConfigurationDecorator;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.state.datasource.DataSourceStateManager;
import org.apache.shardingsphere.single.api.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;
import org.apache.shardingsphere.single.exception.InvalidSingleRuleConfigurationException;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;

public final class SingleRuleConfigurationDecorator
implements RuleConfigurationDecorator<SingleRuleConfiguration> {
    public SingleRuleConfiguration decorate(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, SingleRuleConfiguration ruleConfig) {
        return new SingleRuleConfiguration(this.decorateTables(databaseName, dataSources, new LinkedList<ShardingSphereRule>(builtRules), ruleConfig.getTables()), (String)ruleConfig.getDefaultDataSource().orElse(null));
    }

    private Collection<String> decorateTables(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, Collection<String> tables) {
        builtRules.removeIf(SingleRule.class::isInstance);
        if (tables.isEmpty() && builtRules.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<String> splitTables = SingleTableLoadUtils.splitTableLines(tables);
        if (!this.isExpandRequired(splitTables)) {
            return splitTables;
        }
        Map enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSources(databaseName, dataSources);
        Map<String, DataSource> aggregatedDataSources = SingleTableLoadUtils.getAggregatedDataSourceMap((Map<String, DataSource>)enabledDataSources, builtRules);
        DatabaseType databaseType = DatabaseTypeEngine.getStorageType(enabledDataSources.values());
        Collection<String> excludedTables = SingleTableLoadUtils.getExcludedTables(builtRules);
        Map<String, Collection<DataNode>> actualDataNodes = SingleTableDataNodeLoader.load(databaseName, databaseType, aggregatedDataSources, excludedTables);
        Collection<DataNode> configuredDataNodes = SingleTableLoadUtils.convertToDataNodes(databaseName, databaseType, splitTables);
        this.checkRuleConfiguration(databaseName, aggregatedDataSources, excludedTables, configuredDataNodes);
        boolean isSchemaSupportedDatabaseType = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getDefaultSchema().isPresent();
        if (splitTables.contains("*.*") || splitTables.contains("*.*.*")) {
            return this.loadAllTables(isSchemaSupportedDatabaseType, actualDataNodes);
        }
        return this.loadSpecifiedTables(isSchemaSupportedDatabaseType, actualDataNodes, builtRules, configuredDataNodes);
    }

    private boolean isExpandRequired(Collection<String> splitTables) {
        return splitTables.stream().anyMatch(each -> each.contains("*"));
    }

    private Collection<String> loadSpecifiedTables(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes, Collection<ShardingSphereRule> builtRules, Collection<DataNode> configuredDataNodes) {
        LinkedHashSet<String> expandRequiredDataSources = new LinkedHashSet<String>();
        LinkedHashMap<String, DataNode> expectedDataNodes = new LinkedHashMap<String, DataNode>();
        for (DataNode each : configuredDataNodes) {
            if ("*".equals(each.getTableName())) {
                expandRequiredDataSources.add(each.getDataSourceName());
                continue;
            }
            expectedDataNodes.put(each.getTableName(), each);
        }
        if (expandRequiredDataSources.isEmpty()) {
            return this.loadSpecifiedTablesWithoutExpand(isSchemaSupportedDatabaseType, actualDataNodes, configuredDataNodes);
        }
        Collection<String> featureRequiredSingleTables = SingleTableLoadUtils.getFeatureRequiredSingleTables(builtRules);
        return this.loadSpecifiedTablesWithExpand(isSchemaSupportedDatabaseType, actualDataNodes, featureRequiredSingleTables, expandRequiredDataSources, expectedDataNodes);
    }

    private Collection<String> loadSpecifiedTablesWithExpand(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes, Collection<String> featureRequiredSingleTables, Collection<String> expandRequiredDataSources, Map<String, DataNode> expectedDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry<String, Collection<DataNode>> entry : actualDataNodes.entrySet()) {
            if (featureRequiredSingleTables.contains(entry.getKey())) continue;
            DataNode physicalDataNode = entry.getValue().iterator().next();
            if (expandRequiredDataSources.contains(physicalDataNode.getDataSourceName())) {
                result.add(this.getTableNodeString(isSchemaSupportedDatabaseType, physicalDataNode));
                continue;
            }
            if (!expectedDataNodes.containsKey(entry.getKey())) continue;
            DataNode dataNode = expectedDataNodes.get(entry.getKey());
            String tableNodeStr = this.getTableNodeString(isSchemaSupportedDatabaseType, physicalDataNode);
            ShardingSpherePreconditions.checkState((boolean)physicalDataNode.equals((Object)dataNode), () -> new InvalidSingleRuleConfigurationException(String.format("Single table `%s` is found that does not match %s", tableNodeStr, this.getTableNodeString(isSchemaSupportedDatabaseType, dataNode))));
            result.add(tableNodeStr);
        }
        return result;
    }

    private Collection<String> loadSpecifiedTablesWithoutExpand(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes, Collection<DataNode> configuredDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (DataNode each : configuredDataNodes) {
            ShardingSpherePreconditions.checkState((boolean)actualDataNodes.containsKey(each.getTableName()), () -> new InvalidSingleRuleConfigurationException(String.format("Single table `%s` does not exist", this.getTableNodeString(isSchemaSupportedDatabaseType, each))));
            DataNode actualDataNode = actualDataNodes.get(each.getTableName()).iterator().next();
            String tableNodeStr = this.getTableNodeString(isSchemaSupportedDatabaseType, actualDataNode);
            ShardingSpherePreconditions.checkState((boolean)actualDataNode.equals((Object)each), () -> new InvalidSingleRuleConfigurationException(String.format("Single table `%s` is found that does not match %s", tableNodeStr, this.getTableNodeString(isSchemaSupportedDatabaseType, each))));
            result.add(tableNodeStr);
        }
        return result;
    }

    private Collection<String> loadAllTables(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, Collection<DataNode>> entry : actualDataNodes.entrySet()) {
            result.add(this.getTableNodeString(isSchemaSupportedDatabaseType, entry.getValue().iterator().next()));
        }
        return result;
    }

    private String getTableNodeString(boolean isSchemaSupportedDatabaseType, DataNode dataNode) {
        return isSchemaSupportedDatabaseType ? this.formatTableName(dataNode.getDataSourceName(), dataNode.getSchemaName(), dataNode.getTableName()) : this.formatTableName(dataNode.getDataSourceName(), dataNode.getTableName());
    }

    private void checkRuleConfiguration(String databaseName, Map<String, DataSource> dataSources, Collection<String> excludedTables, Collection<DataNode> dataNodes) {
        for (DataNode each : dataNodes) {
            if (!"*".equals(each.getDataSourceName())) {
                ShardingSpherePreconditions.checkState((boolean)dataSources.containsKey(each.getDataSourceName()), () -> new InvalidSingleRuleConfigurationException(String.format("Data source `%s` does not exist in database `%s`", each.getDataSourceName(), databaseName)));
            }
            ShardingSpherePreconditions.checkState((!excludedTables.contains(each.getTableName()) ? 1 : 0) != 0, () -> new InvalidSingleRuleConfigurationException(String.format("Table `%s` existed and is not a single table in database `%s`", each.getTableName(), databaseName)));
        }
    }

    private String formatTableName(String dataSourceName, String tableName) {
        return String.format("%s.%s", dataSourceName, tableName);
    }

    private String formatTableName(String dataSourceName, String schemaName, String tableName) {
        return String.format("%s.%s.%s", dataSourceName, schemaName, tableName);
    }

    public Class<SingleRuleConfiguration> getType() {
        return SingleRuleConfiguration.class;
    }
}

