/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.decider;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationDecider;

public final class SingleSQLFederationDecider
implements SQLFederationDecider<SingleRule> {
    public boolean decide(SelectStatementContext selectStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, SingleRule rule, Collection<DataNode> includedDataNodes) {
        Collection<QualifiedTable> singleTables = this.getSingleTables(selectStatementContext, database, rule);
        if (singleTables.isEmpty()) {
            return false;
        }
        if (this.containsView(database, singleTables)) {
            return true;
        }
        boolean isAllTablesInSameComputeNode = rule.isAllTablesInSameComputeNode(includedDataNodes, singleTables);
        includedDataNodes.addAll(this.getTableDataNodes(rule, singleTables));
        return !isAllTablesInSameComputeNode;
    }

    private Collection<QualifiedTable> getSingleTables(SelectStatementContext selectStatementContext, ShardingSphereDatabase database, SingleRule rule) {
        Collection<QualifiedTable> qualifiedTables = rule.getQualifiedTables((SQLStatementContext)selectStatementContext, database);
        return rule.getSingleTables(qualifiedTables);
    }

    private boolean containsView(ShardingSphereDatabase database, Collection<QualifiedTable> singleTables) {
        for (QualifiedTable each : singleTables) {
            if (!database.getSchema(each.getSchemaName()).containsView(each.getTableName())) continue;
            return true;
        }
        return false;
    }

    private Collection<DataNode> getTableDataNodes(SingleRule rule, Collection<QualifiedTable> singleTables) {
        HashSet<DataNode> result = new HashSet<DataNode>();
        for (QualifiedTable each : singleTables) {
            rule.findTableDataNode(each.getSchemaName(), each.getTableName()).ifPresent(result::add);
        }
        return result;
    }

    public int getOrder() {
        return 30;
    }

    public Class<SingleRule> getTypeClass() {
        return SingleRule.class;
    }
}

