/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.datanode;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.loader.type.SchemaMetaDataLoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.single.exception.SingleTablesLoadingException;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;

public final class SingleTableDataNodeLoader {
    public static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules, Collection<String> configuredTables) {
        Collection<String> featureRequiredSingleTables = SingleTableLoadUtils.getFeatureRequiredSingleTables(builtRules);
        if (configuredTables.isEmpty() && featureRequiredSingleTables.isEmpty()) {
            return new LinkedHashMap<String, Collection<DataNode>>();
        }
        Collection<String> excludedTables = SingleTableLoadUtils.getExcludedTables(builtRules);
        Map<String, Collection<DataNode>> actualDataNodes = SingleTableDataNodeLoader.load(databaseName, databaseType, dataSourceMap, excludedTables);
        Collection<String> splitTables = SingleTableLoadUtils.splitTableLines(configuredTables);
        if (splitTables.contains("*.*") || splitTables.contains("*.*.*")) {
            return actualDataNodes;
        }
        Map<String, Map<String, Collection<String>>> configuredTableMap = SingleTableDataNodeLoader.getConfiguredTableMap(databaseName, databaseType, splitTables);
        return SingleTableDataNodeLoader.loadSpecifiedDataNodes(actualDataNodes, featureRequiredSingleTables, configuredTableMap);
    }

    public static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<String> excludedTables) {
        ConcurrentHashMap<String, Collection<DataNode>> result = new ConcurrentHashMap<String, Collection<DataNode>>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Map<String, Collection<DataNode>> dataNodeMap = SingleTableDataNodeLoader.load(databaseName, databaseType, entry.getKey(), entry.getValue(), excludedTables);
            for (Map.Entry<String, Collection<DataNode>> each : dataNodeMap.entrySet()) {
                Collection<DataNode> addedDataNodes = each.getValue();
                Collection existDataNodes = result.getOrDefault(each.getKey().toLowerCase(), new LinkedHashSet(addedDataNodes.size(), 1.0f));
                existDataNodes.addAll(addedDataNodes);
                result.putIfAbsent(each.getKey().toLowerCase(), existDataNodes);
            }
        }
        return result;
    }

    private static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType databaseType, String dataSourceName, DataSource dataSource, Collection<String> excludedTables) {
        Map<String, Collection<String>> schemaTableNames = SingleTableDataNodeLoader.loadSchemaTableNames(databaseName, databaseType, dataSource, dataSourceName);
        LinkedHashMap<String, Collection<DataNode>> result = new LinkedHashMap<String, Collection<DataNode>>();
        for (Map.Entry<String, Collection<String>> entry : schemaTableNames.entrySet()) {
            for (String each : entry.getValue()) {
                if (excludedTables.contains(each)) continue;
                Collection dataNodes = result.getOrDefault(each, new LinkedList());
                DataNode dataNode = new DataNode(dataSourceName, each);
                dataNode.setSchemaName(entry.getKey());
                dataNodes.add(dataNode);
                result.putIfAbsent(each, dataNodes);
            }
        }
        return result;
    }

    private static Map<String, Collection<DataNode>> loadSpecifiedDataNodes(Map<String, Collection<DataNode>> actualDataNodes, Collection<String> featureRequiredSingleTables, Map<String, Map<String, Collection<String>>> configuredTableMap) {
        ConcurrentHashMap<String, Collection<DataNode>> result = new ConcurrentHashMap<String, Collection<DataNode>>();
        for (Map.Entry<String, Collection<DataNode>> entry : actualDataNodes.entrySet()) {
            Collection<DataNode> singleNode = SingleTableDataNodeLoader.loadSpecifiedDataNode(entry.getValue(), featureRequiredSingleTables, configuredTableMap);
            if (singleNode.isEmpty()) continue;
            result.put(entry.getKey(), singleNode);
        }
        return result;
    }

    private static Collection<DataNode> loadSpecifiedDataNode(Collection<DataNode> dataNodes, Collection<String> featureRequiredSingleTables, Map<String, Map<String, Collection<String>>> configuredTableMap) {
        for (DataNode each : dataNodes) {
            if (featureRequiredSingleTables.contains(each.getTableName())) {
                return SingleTableDataNodeLoader.getSingleDataNodeCollection(each);
            }
            Map<String, Collection<String>> configuredTablesForDataSource = configuredTableMap.get(each.getDataSourceName());
            if (null == configuredTablesForDataSource || configuredTablesForDataSource.isEmpty()) continue;
            if (configuredTablesForDataSource.containsKey("*")) {
                return SingleTableDataNodeLoader.getSingleDataNodeCollection(each);
            }
            Collection<String> configuredTablesForSchema = configuredTablesForDataSource.get(each.getSchemaName());
            if (null == configuredTablesForSchema || configuredTablesForSchema.isEmpty() || !configuredTablesForSchema.contains("*") && !configuredTablesForSchema.contains(each.getTableName().toLowerCase())) continue;
            return SingleTableDataNodeLoader.getSingleDataNodeCollection(each);
        }
        return Collections.emptyList();
    }

    private static Collection<DataNode> getSingleDataNodeCollection(DataNode dataNode) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        result.add(dataNode);
        return result;
    }

    private static Map<String, Map<String, Collection<String>>> getConfiguredTableMap(String databaseName, DatabaseType databaseType, Collection<String> configuredTables) {
        if (configuredTables.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Map<String, Collection<String>>> result = new LinkedHashMap<String, Map<String, Collection<String>>>();
        Collection<DataNode> dataNodes = SingleTableLoadUtils.convertToDataNodes(databaseName, databaseType, configuredTables);
        for (DataNode each : dataNodes) {
            Map schemaTables = result.getOrDefault(each.getDataSourceName(), new LinkedHashMap());
            Collection tables = schemaTables.getOrDefault(each.getSchemaName(), new LinkedList());
            tables.add(each.getTableName());
            schemaTables.putIfAbsent(each.getSchemaName(), tables);
            result.putIfAbsent(each.getDataSourceName(), schemaTables);
        }
        return result;
    }

    public static Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DatabaseType databaseType, DataSource dataSource, String dataSourceName) {
        try {
            return SchemaMetaDataLoader.loadSchemaTableNames((String)databaseName, (DatabaseType)databaseType, (DataSource)dataSource);
        }
        catch (SQLException ex) {
            throw new SingleTablesLoadingException(databaseName, dataSourceName, ex);
        }
    }

    @Generated
    private SingleTableDataNodeLoader() {
    }
}

